/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.config.SecurityContextPersistenceFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.springframework.security.core.context.DeferredSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.web.filter.OncePerRequestFilter;

public class GeoServerSecurityContextPersistenceFilter
extends GeoServerCompositeFilter {
    public static final String ALLOWSESSIONCREATION_ATTR = "_allowSessionCreation";
    Boolean isAllowSessionCreation;
    static final String FILTER_APPLIED = "__spring_security_scpf_applied";

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        SecurityContextPersistenceFilterConfig pConfig = (SecurityContextPersistenceFilterConfig)config;
        final HttpSessionSecurityContextRepository repo = new HttpSessionSecurityContextRepository();
        OncePerRequestFilter eagerFilter = new OncePerRequestFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
                request.setAttribute(GeoServerSecurityContextPersistenceFilter.ALLOWSESSIONCREATION_ATTR, (Object)GeoServerSecurityContextPersistenceFilter.this.isAllowSessionCreation);
                if (GeoServerSecurityContextPersistenceFilter.this.isAllowSessionCreation.booleanValue()) {
                    request.getSession();
                }
                request.setAttribute("org.geoserver.security.enabled", (Object)Boolean.TRUE);
                if (request.getAttribute(GeoServerSecurityContextPersistenceFilter.FILTER_APPLIED) != null) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return;
                }
                request.setAttribute(GeoServerSecurityContextPersistenceFilter.FILTER_APPLIED, (Object)Boolean.TRUE);
                try {
                    DeferredSecurityContext securityContext = repo.loadDeferredContext(request);
                    SecurityContextHolder.setDeferredContext((Supplier)securityContext);
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                finally {
                    SecurityContext contextAfterChainExecution = SecurityContextHolder.getContext();
                    SecurityContextHolder.clearContext();
                    repo.saveContext(contextAfterChainExecution, request, response);
                    request.removeAttribute(GeoServerSecurityContextPersistenceFilter.FILTER_APPLIED);
                }
            }
        };
        this.isAllowSessionCreation = pConfig.isAllowSessionCreation();
        repo.setAllowSessionCreation(pConfig.isAllowSessionCreation());
        try {
            eagerFilter.afterPropertiesSet();
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.getNestedFilters().add((Filter)eagerFilter);
    }
}

