/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.security.GeoServerSecurityFilterChain;
import org.geoserver.security.RequestFilterChain;
import org.geoserver.security.config.LogoutFilterConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerSecurityFilter;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.util.StringUtils;

public class GeoServerLogoutFilter
extends GeoServerSecurityFilter {
    public static final String URL_AFTER_LOGOUT = "/web/";
    public static final String LOGOUT_REDIRECT_ATTR = "_logout_redirect";
    private String redirectUrl;
    SecurityContextLogoutHandler logoutHandler;
    SimpleUrlLogoutSuccessHandler logoutSuccessHandler;
    String[] pathInfos;

    @Override
    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.logoutHandler = new SecurityContextLogoutHandler();
        this.redirectUrl = ((LogoutFilterConfig)config).getRedirectURL();
        this.logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
        if (StringUtils.hasLength((String)this.redirectUrl)) {
            this.logoutSuccessHandler.setDefaultTargetUrl(this.redirectUrl);
        }
        String formLogoutChain = ((LogoutFilterConfig)config).getFormLogoutChain() != null ? ((LogoutFilterConfig)config).getFormLogoutChain() : "/j_spring_security_logout,/j_spring_security_logout/,/logout";
        this.pathInfos = formLogoutChain.split(",");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        boolean doLogout = false;
        for (String pathInfo : this.pathInfos) {
            if (!this.getRequestPath(request).startsWith(pathInfo)) continue;
            doLogout = true;
            break;
        }
        if (doLogout) {
            this.doLogout(request, response, new String[0]);
        }
    }

    public void doLogout(HttpServletRequest request, HttpServletResponse response, String ... skipHandlerName) throws IOException, ServletException {
        String redirectUrl;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            List<LogoutHandler> logoutHandlers = this.calculateActiveLogoutHandlers(skipHandlerName);
            for (LogoutHandler h : logoutHandlers) {
                h.logout(request, response, authentication);
            }
            RememberMeServices rms = this.securityManager.getRememberMeService();
            ((LogoutHandler)rms).logout(request, response, authentication);
            this.logoutHandler.logout(request, response, authentication);
        }
        if (StringUtils.hasLength((String)(redirectUrl = (String)request.getAttribute(LOGOUT_REDIRECT_ATTR)))) {
            SimpleUrlLogoutSuccessHandler h = new SimpleUrlLogoutSuccessHandler();
            h.setDefaultTargetUrl(redirectUrl);
            h.onLogoutSuccess(request, response, authentication);
            return;
        }
        this.logoutSuccessHandler.onLogoutSuccess(request, response, authentication);
    }

    List<LogoutHandler> calculateActiveLogoutHandlers(String ... skipHandlerName) throws IOException {
        ArrayList<LogoutHandler> result = new ArrayList<LogoutHandler>();
        SortedSet<String> logoutFilterNames = this.getSecurityManager().listFilters(LogoutHandler.class);
        logoutFilterNames.removeAll(Arrays.asList(skipHandlerName));
        HashSet<String> handlerNames = new HashSet<String>();
        GeoServerSecurityFilterChain chain = this.getSecurityManager().getSecurityConfig().getFilterChain();
        for (RequestFilterChain requestChain : chain.getRequestChains()) {
            for (String filterName : requestChain.getFilterNames()) {
                if (!logoutFilterNames.contains(filterName)) continue;
                handlerNames.add(filterName);
            }
        }
        for (String handlerName : handlerNames) {
            result.add((LogoutHandler)this.getSecurityManager().loadFilter(handlerName));
        }
        return result;
    }
}

