/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.security.GeoServerRoleService;
import org.geoserver.security.config.J2eeAuthenticationBaseFilterConfig;
import org.geoserver.security.filter.GeoServerPreAuthenticatedUserNameFilter;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.RoleCalculator;

public abstract class GeoServerJ2eeBaseAuthenticationFilter
extends GeoServerPreAuthenticatedUserNameFilter {
    @Override
    protected Collection<GeoServerRole> getRoles(HttpServletRequest request, String principal) throws IOException {
        if (J2eeAuthenticationBaseFilterConfig.J2EERoleSource.J2EE.equals(this.getRoleSource())) {
            return this.getRolesFromJ2EE(request, principal);
        }
        return super.getRoles(request, principal);
    }

    protected Collection<GeoServerRole> getRolesFromJ2EE(HttpServletRequest request, String principal) throws IOException {
        ArrayList<GeoServerRole> roles = new ArrayList<GeoServerRole>();
        boolean useActiveService = this.getRoleServiceName() == null || this.getRoleServiceName().trim().isEmpty();
        GeoServerRoleService service = useActiveService ? this.getSecurityManager().getActiveRoleService() : this.getSecurityManager().loadRoleService(this.getRoleServiceName());
        for (GeoServerRole role : service.getRoles()) {
            if (!request.isUserInRole(role.getAuthority())) continue;
            roles.add(role);
        }
        RoleCalculator calc = new RoleCalculator(service);
        calc.addInheritedRoles(roles);
        calc.addMappedSystemRoles(roles);
        return roles;
    }
}

