/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.geoserver.security.csp.CSPHttpRequestWrapper;
import org.geoserver.security.csp.CSPUtils;
import org.geoserver.security.csp.predicate.CSPPredicate;
import org.geoserver.security.csp.predicate.CSPPredicateParameter;
import org.geoserver.security.csp.predicate.CSPPredicatePath;
import org.geoserver.security.csp.predicate.CSPPredicateProperty;

public class CSPRule
implements CSPPredicate,
Serializable {
    private static final long serialVersionUID = 838336921193518382L;
    private static final String DEFAULT_NAME = null;
    private static final String DEFAULT_DESCRIPTION = "";
    private static final Boolean DEFAULT_ENABLED = true;
    private static final String DEFAULT_FILTER = "";
    private static final String DEFAULT_DIRECTIVES = "";
    private static final Splitter PREDICATE_SPLITTER = Splitter.on((String)" AND ").trimResults().omitEmptyStrings();
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',').trimResults().limit(2);
    private String name;
    private String description;
    private Boolean enabled;
    private String filter;
    private String directives;
    private transient List<CSPPredicate> predicates = null;

    public CSPRule() {
        this(DEFAULT_NAME, "", DEFAULT_ENABLED, "", "");
    }

    public CSPRule(String name, String description, boolean enabled, String filter, String directives) {
        this.name = name;
        this.description = description;
        this.enabled = enabled;
        this.filter = filter;
        this.directives = directives;
    }

    public CSPRule(CSPRule other) {
        this(other.getName(), other.getDescription(), other.isEnabled(), other.getFilter(), other.getDirectives());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getDirectives() {
        return this.directives;
    }

    public void setDirectives(String directives) {
        this.directives = directives;
    }

    public void parseFilter() {
        this.predicates = CSPRule.parseFilter(this.filter);
    }

    @Override
    public boolean test(CSPHttpRequestWrapper request) {
        Preconditions.checkState((this.predicates != null ? 1 : 0) != 0, (Object)"The filter has not been parsed yet");
        return this.enabled != false && this.predicates.stream().allMatch(p -> p.test(request));
    }

    public boolean equals(Object obj) {
        if (obj instanceof CSPRule) {
            CSPRule other = (CSPRule)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.filter, other.filter) && Objects.equals(this.directives, other.directives);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.enabled, this.filter, this.directives);
    }

    private Object readResolve() {
        Preconditions.checkNotNull((Object)this.name, (Object)"The rule name can not be null");
        this.description = (String)MoreObjects.firstNonNull((Object)this.description, (Object)"");
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)this.enabled, (Object)DEFAULT_ENABLED);
        this.filter = (String)MoreObjects.firstNonNull((Object)this.filter, (Object)"");
        this.directives = (String)MoreObjects.firstNonNull((Object)this.directives, (Object)"");
        return this;
    }

    public static List<CSPPredicate> parseFilter(String filter) {
        filter = CSPUtils.trimWhitespace(filter);
        try {
            TreeMap<Integer, List<CSPPredicate>> map = new TreeMap<Integer, List<CSPPredicate>>();
            block12: for (String pred : PREDICATE_SPLITTER.split((CharSequence)filter)) {
                int index = pred.indexOf(40);
                Preconditions.checkArgument((index > 0 ? 1 : 0) != 0, (String)"Unable to determine type of predicate: %s", (Object)pred);
                Preconditions.checkArgument((pred.charAt(pred.length() - 1) == ')' ? 1 : 0) != 0, (String)"Unable to parse arguments in predicate: %s", (Object)pred);
                String type = pred.substring(0, index).trim().toUpperCase();
                String arg = pred.substring(index + 1, pred.length() - 1).trim();
                List args = COMMA_SPLITTER.splitToList((CharSequence)arg);
                switch (type) {
                    case "PROP": {
                        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Insuffient arguments in predicate: %s", (Object)pred);
                        CSPRule.addToMap(map, 1, new CSPPredicateProperty((String)args.get(0), (String)args.get(1)));
                        continue block12;
                    }
                    case "PATH": {
                        CSPRule.addToMap(map, 2, new CSPPredicatePath(arg));
                        continue block12;
                    }
                    case "PARAM": {
                        Preconditions.checkArgument((args.size() == 2 ? 1 : 0) != 0, (String)"Insuffient arguments in predicate: %s", (Object)pred);
                        CSPRule.addToMap(map, 3, new CSPPredicateParameter((String)args.get(0), (String)args.get(1)));
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Unknown type for predicate: " + pred);
            }
            return Collections.unmodifiableList(map.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse predicates from string '" + filter + "'", e);
        }
    }

    private static void addToMap(Map<Integer, List<CSPPredicate>> map, int key, CSPPredicate predicate) {
        map.computeIfAbsent(key, x -> new ArrayList()).add(predicate);
    }
}

