/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.csp;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.geoserver.security.csp.CSPPolicy;
import org.geoserver.security.csp.CSPRule;
import org.geoserver.security.csp.CSPUtils;

public class CSPConfiguration
implements Serializable {
    private static final long serialVersionUID = 975607551448404268L;
    private static final Boolean DEFAULT_ENABLED = true;
    private static final Boolean DEFAULT_REPORT_ONLY = false;
    private static final Boolean DEFAULT_ALLOW_OVERRIDE = false;
    private static final Boolean DEFAULT_INJECT_PROXY_BASE = false;
    private static final String DEFAULT_REMOTE_RESOURCES = "";
    private static final String DEFAULT_FRAME_ANCESTORS = "";
    private Boolean enabled;
    private Boolean reportOnly;
    private Boolean allowOverride;
    private Boolean injectProxyBase;
    private String remoteResources;
    private String frameAncestors;
    private List<CSPPolicy> policies;

    public CSPConfiguration() {
        this(DEFAULT_ENABLED, DEFAULT_REPORT_ONLY, DEFAULT_ALLOW_OVERRIDE, DEFAULT_INJECT_PROXY_BASE, "", "", new ArrayList<CSPPolicy>());
    }

    public CSPConfiguration(boolean enabled, boolean reportOnly, boolean allowOverride, boolean injectProxyBase, String remoteResources, String frameAncestors, List<CSPPolicy> policies) {
        this.enabled = enabled;
        this.reportOnly = reportOnly;
        this.allowOverride = allowOverride;
        this.injectProxyBase = injectProxyBase;
        this.remoteResources = remoteResources;
        this.frameAncestors = frameAncestors;
        this.policies = policies;
    }

    public CSPConfiguration(CSPConfiguration other) {
        this(other.isEnabled(), other.isReportOnly(), other.isAllowOverride(), other.isInjectProxyBase(), other.getRemoteResources(), other.getFrameAncestors(), other.getPolicies().stream().map(CSPPolicy::new).collect(Collectors.toList()));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isReportOnly() {
        return this.reportOnly;
    }

    public void setReportOnly(boolean reportOnly) {
        this.reportOnly = reportOnly;
    }

    public boolean isAllowOverride() {
        return this.allowOverride;
    }

    public void setAllowOverride(boolean allowOverride) {
        this.allowOverride = allowOverride;
    }

    public boolean isInjectProxyBase() {
        return this.injectProxyBase;
    }

    public void setInjectProxyBase(boolean injectProxyBase) {
        this.injectProxyBase = injectProxyBase;
    }

    public String getRemoteResources() {
        return this.remoteResources;
    }

    public void setRemoteResources(String externalResources) {
        this.remoteResources = externalResources;
    }

    public String getFrameAncestors() {
        return this.frameAncestors;
    }

    public void setFrameAncestors(String frameAncestors) {
        this.frameAncestors = frameAncestors;
    }

    public List<CSPPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<CSPPolicy> policies) {
        this.policies = policies;
    }

    public String getField(String key) {
        switch (key) {
            case "geoserver.csp.remoteResources": {
                return CSPUtils.trimWhitespace(this.remoteResources);
            }
            case "geoserver.csp.frameAncestors": {
                return CSPUtils.trimWhitespace(this.frameAncestors);
            }
        }
        return "";
    }

    public CSPPolicy getPolicyByName(String name) {
        return this.policies.stream().filter(p -> name.equals(p.getName())).findFirst().orElse(null);
    }

    public CSPConfiguration parseFilters() {
        this.getPolicies().stream().map(CSPPolicy::getRules).flatMap(Collection::stream).forEach(CSPRule::parseFilter);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CSPConfiguration) {
            CSPConfiguration other = (CSPConfiguration)obj;
            return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.reportOnly, other.reportOnly) && Objects.equals(this.allowOverride, other.allowOverride) && Objects.equals(this.injectProxyBase, other.injectProxyBase) && Objects.equals(this.remoteResources, other.remoteResources) && Objects.equals(this.frameAncestors, other.frameAncestors) && Objects.equals(this.policies, other.policies);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.reportOnly, this.allowOverride, this.injectProxyBase, this.remoteResources, this.frameAncestors, this.policies);
    }

    private Object readResolve() {
        this.enabled = (Boolean)MoreObjects.firstNonNull((Object)this.enabled, (Object)DEFAULT_ENABLED);
        this.reportOnly = (Boolean)MoreObjects.firstNonNull((Object)this.reportOnly, (Object)DEFAULT_REPORT_ONLY);
        this.allowOverride = (Boolean)MoreObjects.firstNonNull((Object)this.allowOverride, (Object)DEFAULT_ALLOW_OVERRIDE);
        this.injectProxyBase = (Boolean)MoreObjects.firstNonNull((Object)this.injectProxyBase, (Object)DEFAULT_INJECT_PROXY_BASE);
        this.remoteResources = (String)MoreObjects.firstNonNull((Object)this.remoteResources, (Object)"");
        this.frameAncestors = (String)MoreObjects.firstNonNull((Object)this.frameAncestors, (Object)"");
        this.policies = (List)MoreObjects.firstNonNull(this.policies, new ArrayList());
        long count = this.policies.stream().map(CSPPolicy::getName).distinct().count();
        Preconditions.checkArgument((count == (long)this.policies.size() ? 1 : 0) != 0, (Object)"Policy names must be unique");
        return this.parseFilters();
    }
}

