/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.concurrent;

import java.io.IOException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.SecretKey;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.KeyStoreProvider;

public class LockingKeyStoreProvider
implements KeyStoreProvider {
    protected final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    protected final Lock readLock = this.readWriteLock.readLock();
    protected final Lock writeLock = this.readWriteLock.writeLock();
    protected KeyStoreProvider provider;

    protected void readLock() {
        this.readLock.lock();
    }

    protected void readUnLock() {
        this.readLock.unlock();
    }

    protected void writeLock() {
        this.writeLock.lock();
    }

    protected void writeUnLock() {
        this.writeLock.unlock();
    }

    public LockingKeyStoreProvider(KeyStoreProvider prov) {
        this.provider = prov;
    }

    @Override
    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.provider.setSecurityManager(securityManager);
    }

    @Override
    public Resource getResource() {
        return this.provider.getResource();
    }

    @Override
    public void reloadKeyStore() throws IOException {
        this.writeLock();
        try {
            this.provider.reloadKeyStore();
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public Key getKey(String alias) throws IOException {
        this.readLock();
        try {
            Key key = this.provider.getKey(alias);
            return key;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public byte[] getConfigPasswordKey() throws IOException {
        this.readLock();
        try {
            byte[] byArray = this.provider.getConfigPasswordKey();
            return byArray;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public boolean hasConfigPasswordKey() throws IOException {
        this.readLock();
        try {
            boolean bl = this.provider.hasConfigPasswordKey();
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public boolean containsAlias(String alias) throws IOException {
        this.readLock();
        try {
            boolean bl = this.provider.containsAlias(alias);
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public byte[] getUserGroupKey(String serviceName) throws IOException {
        this.readLock();
        try {
            byte[] byArray = this.provider.getUserGroupKey(serviceName);
            return byArray;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public boolean hasUserGroupKey(String serviceName) throws IOException {
        this.readLock();
        try {
            boolean bl = this.provider.hasUserGroupKey(serviceName);
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public SecretKey getSecretKey(String name) throws IOException {
        this.readLock();
        try {
            SecretKey secretKey = this.provider.getSecretKey(name);
            return secretKey;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public PublicKey getPublicKey(String name) throws IOException {
        this.readLock();
        try {
            PublicKey publicKey = this.provider.getPublicKey(name);
            return publicKey;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public PrivateKey getPrivateKey(String name) throws IOException {
        this.readLock();
        try {
            PrivateKey privateKey = this.provider.getPrivateKey(name);
            return privateKey;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public String aliasForGroupService(String serviceName) {
        return this.provider.aliasForGroupService(serviceName);
    }

    @Override
    public boolean isKeyStorePassword(char[] password) throws IOException {
        this.readLock();
        try {
            boolean bl = this.provider.isKeyStorePassword(password);
            return bl;
        }
        finally {
            this.readUnLock();
        }
    }

    @Override
    public void setSecretKey(String alias, char[] key) throws IOException {
        this.writeLock();
        try {
            this.provider.setSecretKey(alias, key);
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public void setUserGroupKey(String serviceName, char[] password) throws IOException {
        this.writeLock();
        try {
            this.provider.setUserGroupKey(serviceName, password);
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public void removeKey(String alias) throws IOException {
        this.writeLock();
        try {
            this.provider.removeKey(alias);
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public void storeKeyStore() throws IOException {
        this.writeLock();
        try {
            this.provider.storeKeyStore();
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public void prepareForMasterPasswordChange(char[] oldPassword, char[] newPassword) throws IOException {
        this.writeLock();
        try {
            this.provider.prepareForMasterPasswordChange(oldPassword, newPassword);
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public void abortMasterPasswordChange() {
        this.writeLock();
        try {
            this.provider.abortMasterPasswordChange();
        }
        finally {
            this.writeUnLock();
        }
    }

    @Override
    public void commitMasterPasswordChange() throws IOException {
        this.writeLock();
        try {
            this.provider.commitMasterPasswordChange();
        }
        finally {
            this.writeUnLock();
        }
    }
}

