/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.geoserver.platform.GeoServerEnvironment;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.password.GeoServerPasswordEncoder;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

class EnvironmentUserDetailService
implements UserDetailsService {
    private GeoServerUserGroupService delegate;
    private final GeoServerEnvironment environment;
    private static Logger LOGGER = Logging.getLogger(EnvironmentUserDetailService.class);

    EnvironmentUserDetailService(GeoServerUserGroupService userDetailsService, GeoServerEnvironment environment) {
        this.delegate = userDetailsService;
        this.environment = environment;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        UserDetails userDetails = this.delegate.loadUserByUsername(username);
        if (userDetails instanceof GeoServerUser) {
            GeoServerUser user = (GeoServerUser)userDetails;
            String password = user.getPassword();
            GeoServerSecurityManager manager = this.delegate.getSecurityManager();
            List<GeoServerPasswordEncoder> encoders = manager.loadPasswordEncoders(null, true, null);
            String decodedPwd = this.decode(password, encoders);
            return this.resolvePassword(decodedPwd, user);
        }
        return userDetails;
    }

    private GeoServerUser resolvePassword(String decodedPwd, GeoServerUser user) {
        String resolved;
        if (this.isParametrized(decodedPwd) && !(resolved = (String)this.environment.resolveValue((Object)decodedPwd)).equals(decodedPwd)) {
            user = user.copy();
            user.setPassword(resolved);
        }
        return user;
    }

    private boolean isParametrized(String pwd) {
        return StringUtils.isNotBlank((String)pwd) && pwd.startsWith("${") && pwd.endsWith("}");
    }

    private String decode(String value, List<GeoServerPasswordEncoder> encoders) {
        for (GeoServerPasswordEncoder encoder : encoders) {
            if (!encoder.isReversible() || !encoder.isResponsibleForEncoding(value)) continue;
            try {
                encoder.initializeFor(this.delegate);
                return encoder.decode(value);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error initializing password encoder " + encoder.getName() + ", in context of user pwd env resolution.", e);
            }
        }
        return value;
    }
}

