/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.auth;

import org.springframework.security.core.Authentication;

public class AuthenticationCacheEntry {
    private Authentication authentication;
    private int timeToIdleSeconds;
    private int timeToLiveSeconds;
    private long lastAccessed;
    private long created;

    public AuthenticationCacheEntry(Authentication authentication, int timeToIdleSeconds, int timeToLiveSeconds) {
        this.authentication = authentication;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.created = this.lastAccessed = System.currentTimeMillis();
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public int getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public int getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public long getCreated() {
        return this.created;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public boolean hasExpired(long timeInMilliSecs) {
        if (this.lastAccessed + (long)(this.timeToIdleSeconds * 1000) < timeInMilliSecs) {
            return true;
        }
        return this.created + (long)(this.timeToLiveSeconds * 1000) < timeInMilliSecs;
    }

    public int hashCode() {
        return this.authentication == null ? 0 : this.authentication.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthenticationCacheEntry)) {
            return false;
        }
        AuthenticationCacheEntry other = (AuthenticationCacheEntry)o;
        if (this.authentication == other.authentication) {
            return true;
        }
        if (this.authentication == null || other.authentication == null) {
            return false;
        }
        return this.authentication.equals(other.authentication);
    }
}

