/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.DataAccessLimits;
import org.geotools.api.data.Query;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.factory.CommonFactoryFinder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;

public class VectorAccessLimits
extends DataAccessLimits {
    private static final long serialVersionUID = 1646981660625898503L;
    private static FilterFactory FF = CommonFactoryFinder.getFilterFactory(null);
    transient List<PropertyName> readAttributes;
    transient List<PropertyName> writeAttributes;
    transient Filter writeFilter;
    Geometry clipVectorFilter;
    Geometry intersectVectorFilter;

    public VectorAccessLimits(CatalogMode mode, List<PropertyName> readAttributes, Filter readFilter, List<PropertyName> writeAttributes, Filter writeFilter, MultiPolygon clipVectorFilter) {
        super(mode, readFilter);
        this.readAttributes = readAttributes;
        this.writeAttributes = writeAttributes;
        this.writeFilter = writeFilter;
        this.clipVectorFilter = clipVectorFilter;
    }

    public VectorAccessLimits(CatalogMode mode, List<PropertyName> readAttributes, Filter readFilter, List<PropertyName> writeAttributes, Filter writeFilter) {
        this(mode, readAttributes, readFilter, writeAttributes, writeFilter, null);
    }

    public List<PropertyName> getReadAttributes() {
        return this.readAttributes;
    }

    public void setReadAttributes(List<PropertyName> readAttributes) {
        this.readAttributes = readAttributes;
    }

    public List<PropertyName> getWriteAttributes() {
        return this.writeAttributes;
    }

    public void setWriteAttributes(List<PropertyName> writeAttributes) {
        this.writeAttributes = writeAttributes;
    }

    public void setWriteFilter(Filter writeFilter) {
        this.writeFilter = writeFilter;
    }

    public Filter getWriteFilter() {
        return this.writeFilter;
    }

    public Query getReadQuery() {
        return this.buildQuery(this.readAttributes, this.readFilter);
    }

    public Query getWriteQuery() {
        return this.buildQuery(this.writeAttributes, this.writeFilter);
    }

    private Query buildQuery(List<PropertyName> attributes, Filter filter) {
        if (attributes == null && (filter == null || filter == Filter.INCLUDE)) {
            return Query.ALL;
        }
        Query q = new Query();
        q.setFilter(filter);
        q.setPropertyNames(this.flattenNames(attributes));
        return q;
    }

    List<String> flattenNames(List<PropertyName> names) {
        if (names == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(names.size());
        for (PropertyName name : names) {
            result.add(name.getPropertyName());
        }
        return result;
    }

    public String toString() {
        return "VectorAccessLimits [readAttributes=" + this.readAttributes + ", writeAttributes=" + this.writeAttributes + ", writeFilter=" + this.writeFilter + ", readFilter=" + this.readFilter + ", mode=" + this.mode + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.readAttributes = this.readProperties(in);
        this.readFilter = this.readFilter(in);
        this.writeAttributes = this.readProperties(in);
        this.writeFilter = this.readFilter(in);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeProperties(this.readAttributes, out);
        this.writeFilter(this.readFilter, out);
        this.writeProperties(this.writeAttributes, out);
        this.writeFilter(this.writeFilter, out);
    }

    private void writeProperties(List<PropertyName> attributes, ObjectOutputStream oos) throws IOException {
        if (attributes == null) {
            oos.writeInt(-1);
        } else {
            oos.writeInt(attributes.size());
            for (PropertyName property : attributes) {
                oos.writeObject(property.getPropertyName());
            }
        }
    }

    private List<PropertyName> readProperties(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        if (size == -1) {
            return null;
        }
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>();
        for (int i = 0; i < size; ++i) {
            String name = (String)ois.readObject();
            properties.add(FF.property(name));
        }
        return properties;
    }

    public Geometry getClipVectorFilter() {
        return this.clipVectorFilter;
    }

    public void setClipVectorFilter(Geometry clipVectorFilter) {
        this.clipVectorFilter = clipVectorFilter;
    }

    public Geometry getIntersectVectorFilter() {
        return this.intersectVectorFilter;
    }

    public void setIntersectVectorFilter(Geometry intersectVectorFilter) {
        this.intersectVectorFilter = intersectVectorFilter;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.readAttributes == null ? 0 : this.readAttributes.hashCode());
        result = 31 * result + (this.writeAttributes == null ? 0 : this.writeAttributes.hashCode());
        result = 31 * result + (this.writeFilter == null ? 0 : this.writeFilter.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VectorAccessLimits other = (VectorAccessLimits)obj;
        if (this.readAttributes == null ? other.readAttributes != null : !this.readAttributes.equals(other.readAttributes)) {
            return false;
        }
        if (this.writeAttributes == null ? other.writeAttributes != null : !this.writeAttributes.equals(other.writeAttributes)) {
            return false;
        }
        return !(this.writeFilter == null ? other.writeFilter != null : !this.writeFilter.equals(other.writeFilter));
    }
}

