/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.impl.DataAccessRule;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geotools.util.logging.Logging;

public class SecuredResourceNameChangeListener
implements CatalogListener {
    static final Logger LOGGER = Logging.getLogger(SecuredResourceNameChangeListener.class);
    Catalog catalog;
    DataAccessRuleDAO dao;

    public SecuredResourceNameChangeListener(Catalog catalog, DataAccessRuleDAO dao) {
        this.catalog = catalog;
        this.dao = dao;
        catalog.addListener(this);
    }

    @Override
    public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        Resource.Lock lock = this.dao.lock();
        try {
            String removedObjectName;
            Predicate<DataAccessRule> filter;
            CatalogInfo eventSource = event.getSource();
            if (eventSource instanceof WorkspaceInfo) {
                WorkspaceInfo ws = (WorkspaceInfo)eventSource;
                filter = this.workspaceFilter(ws.getName());
                removedObjectName = "Workspace " + ws.getName();
            } else if (eventSource instanceof LayerInfo) {
                LayerInfo l = (LayerInfo)eventSource;
                WorkspaceInfo ws = l.getResource().getStore().getWorkspace();
                filter = this.layerFilter(ws.getName(), l.getName());
                removedObjectName = "Layer " + l.getName();
            } else if (eventSource instanceof LayerGroupInfo) {
                LayerGroupInfo lg = (LayerGroupInfo)eventSource;
                filter = this.layerGroupFilter(lg.getWorkspace(), lg.getName());
                removedObjectName = "Layer Group " + lg.getName();
            } else {
                return;
            }
            Supplier<String> message = () -> String.format("Removing Security Rules for deleted %s", removedObjectName);
            this.apply(filter, this.dao::removeRule, message);
        }
        finally {
            lock.release();
        }
    }

    @Override
    public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        Resource.Lock lock = this.dao.lock();
        try {
            String renamedObject;
            Consumer<DataAccessRule> updater;
            Predicate<DataAccessRule> filter;
            String newName;
            int indexOfName = event.getPropertyNames().indexOf("name");
            if (indexOfName == -1) {
                return;
            }
            String oldName = String.valueOf(event.getOldValues().get(indexOfName));
            if (oldName.equalsIgnoreCase(newName = String.valueOf(event.getNewValues().get(indexOfName)))) {
                return;
            }
            CatalogInfo eventSource = event.getSource();
            if (eventSource instanceof WorkspaceInfo) {
                filter = this.workspaceFilter(oldName);
                updater = r -> r.setRoot(newName);
                renamedObject = "Workspace";
            } else if (eventSource instanceof ResourceInfo) {
                String wsName = ((ResourceInfo)eventSource).getStore().getWorkspace().getName();
                filter = this.layerFilter(wsName, oldName);
                updater = r -> r.setLayer(newName);
                renamedObject = "Resource";
            } else if (eventSource instanceof LayerGroupInfo) {
                LayerGroupInfo lg = (LayerGroupInfo)eventSource;
                filter = this.layerGroupFilter(lg.getWorkspace(), oldName);
                updater = this.layerGroupRuleUpdater(lg.getWorkspace(), newName);
                renamedObject = "LayerGroup";
            } else {
                return;
            }
            Supplier<String> message = () -> String.format("Updating Security Rules for renamed %s: %s -> %s", renamedObject, oldName, newName);
            Consumer<DataAccessRule> safeUpdater = r -> {
                this.dao.removeRule(r);
                updater.accept((DataAccessRule)r);
                this.dao.addRule(r);
            };
            this.apply(filter, safeUpdater, message);
        }
        finally {
            lock.release();
        }
    }

    private Consumer<DataAccessRule> layerGroupRuleUpdater(WorkspaceInfo ws, String newName) {
        if (ws == null) {
            return r -> r.setRoot(newName);
        }
        return r -> r.setLayer(newName);
    }

    private Predicate<DataAccessRule> workspaceFilter(String workspaceName) {
        return r -> r.getRoot().equalsIgnoreCase(workspaceName) && r.getLayer() != null;
    }

    private Predicate<DataAccessRule> layerFilter(String workspace, String layerName) {
        return this.filter(workspace::equalsIgnoreCase, layerName::equalsIgnoreCase);
    }

    private Predicate<DataAccessRule> layerGroupFilter(WorkspaceInfo ws, String lgName) {
        boolean isGlobalLayerGroup;
        boolean bl = isGlobalLayerGroup = null == ws;
        if (isGlobalLayerGroup) {
            return this.filter(lgName::equalsIgnoreCase, Objects::isNull);
        }
        return this.layerFilter(ws.getName(), lgName);
    }

    void apply(Predicate<DataAccessRule> filter, Consumer<DataAccessRule> action, Supplier<String> logMessage) {
        List<DataAccessRule> matches = this.getDataAccessRules(filter);
        if (!matches.isEmpty()) {
            LOGGER.info(logMessage);
            matches.forEach(action);
            this.save();
        }
    }

    private void save() {
        try {
            this.dao.storeRules();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw new CatalogException(e);
        }
    }

    @Override
    public void reloaded() {
    }

    private Predicate<DataAccessRule> filter(Predicate<String> rootFilter, Predicate<String> layerFilter) {
        return r -> rootFilter.test(r.getRoot()) && layerFilter.test(r.getLayer());
    }

    private List<DataAccessRule> getDataAccessRules(Predicate<DataAccessRule> filter) {
        return this.dao.getRules().stream().filter(filter).collect(Collectors.toList());
    }
}

