/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerUserGroupService;
import org.geoserver.security.SecurityUtils;
import org.geoserver.security.impl.GeoServerRole;
import org.geoserver.security.impl.GeoServerUser;
import org.geoserver.security.impl.UserDetailsWrapper;
import org.geoserver.security.password.GeoServerMultiplexingPasswordEncoder;
import org.geoserver.security.password.UserDetailsPasswordWrapper;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.codec.Hex;

public class HttpDigestUserDetailsServiceWrapper
implements UserDetailsService {
    private GeoServerSecurityManager manager;
    protected GeoServerUserGroupService service;
    protected Charset charSet;
    protected final char[] delimArray = new char[]{':'};
    protected MessageDigest digest;
    protected GeoServerMultiplexingPasswordEncoder enc;

    public HttpDigestUserDetailsServiceWrapper(GeoServerUserGroupService service, Charset charSet) {
        this.service = service;
        this.charSet = charSet;
        this.manager = service.getSecurityManager();
        this.enc = new GeoServerMultiplexingPasswordEncoder(service.getSecurityManager(), service);
        try {
            this.digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("No MD5 algorithm available!");
        }
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        if ("root".equals(username)) {
            return this.prepareForRootUser();
        }
        GeoServerUser user = (GeoServerUser)this.service.loadUserByUsername(username);
        return this.prepareForUser(user);
    }

    UserDetails prepareForUser(GeoServerUser user) {
        char[] pw = null;
        try {
            pw = this.enc.decodeToCharArray(user.getPassword());
        }
        catch (UnsupportedOperationException ex) {
            pw = user.getPassword().toCharArray();
        }
        String a1 = this.encodePasswordInA1Format(user.getUsername(), "GeoServer Realm", pw);
        this.manager.disposePassword(pw);
        ArrayList<GrantedAuthority> roles = new ArrayList<GrantedAuthority>();
        roles.addAll(user.getAuthorities());
        roles.add(GeoServerRole.AUTHENTICATED_ROLE);
        return new DigestUserDetails(user, a1, roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserDetails prepareForRootUser() {
        char[] mpw = null;
        try {
            mpw = this.manager.getMasterPassword();
            String a1 = this.encodePasswordInA1Format("root", "GeoServer Realm", mpw);
            UserDetailsPasswordWrapper userDetailsPasswordWrapper = new UserDetailsPasswordWrapper(GeoServerUser.createRoot(), a1);
            return userDetailsPasswordWrapper;
        }
        finally {
            if (mpw != null) {
                this.manager.disposePassword(mpw);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String encodePasswordInA1Format(String username, String realm, char[] password) {
        char[] array = null;
        try {
            char[] usernameArray = username.toCharArray();
            char[] realmArray = realm.toCharArray();
            array = new char[usernameArray.length + realmArray.length + password.length + 2];
            int pos = 0;
            System.arraycopy(usernameArray, 0, array, pos, usernameArray.length);
            System.arraycopy(this.delimArray, 0, array, pos += usernameArray.length, 1);
            System.arraycopy(realmArray, 0, array, ++pos, realmArray.length);
            System.arraycopy(this.delimArray, 0, array, pos += realmArray.length, 1);
            System.arraycopy(password, 0, array, ++pos, password.length);
            MessageDigest md = null;
            try {
                md = (MessageDigest)this.digest.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            String string = String.valueOf(Hex.encode((byte[])md.digest(SecurityUtils.toBytes(array, this.charSet))));
            if (array != null) {
                this.manager.disposePassword(array);
            }
            return string;
        }
        catch (Throwable throwable) {
            if (array != null) {
                this.manager.disposePassword(array);
            }
            throw throwable;
        }
    }

    public static class DigestUserDetails
    extends UserDetailsWrapper {
        private static final long serialVersionUID = 1L;
        private String password;
        private Collection<GrantedAuthority> roles;

        public DigestUserDetails(UserDetails details, String password, Collection<GrantedAuthority> roles) {
            super(details);
            this.password = password;
            this.roles = roles;
        }

        public Collection<GrantedAuthority> getAuthorities() {
            return this.roles;
        }

        @Override
        public String getPassword() {
            return this.password;
        }
    }
}

