/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.util.List;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.impl.DefaultFileAccessManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public interface FileAccessManager {
    public List<File> getAvailableRoots();

    public File getSandbox();

    public boolean checkAccess(File var1);

    public static FileAccessManager lookupFileAccessManager() {
        List managers = GeoServerExtensions.extensions(FileAccessManager.class);
        if (managers.isEmpty()) {
            throw new RuntimeException("Unexpected, no FileAdminAccessManager found");
        }
        FileAccessManager manager = null;
        for (FileAccessManager resourceAccessManager : managers) {
            if (DefaultFileAccessManager.class.equals(resourceAccessManager.getClass())) continue;
            manager = resourceAccessManager;
            break;
        }
        if (manager == null) {
            manager = (FileAccessManager)managers.get(0);
        }
        return manager;
    }

    default public Authentication user() {
        return SecurityContextHolder.getContext().getAuthentication();
    }
}

