/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.CatalogFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.expression.InternalVolatileFunction;
import org.geotools.util.logging.Logging;

public abstract class AbstractCatalogFilter
implements CatalogFilter {
    private static Logger LOGGER = Logging.getLogger(AbstractCatalogFilter.class);

    @Override
    public boolean hideLayer(LayerInfo layer) {
        return false;
    }

    @Override
    public boolean hideStyle(StyleInfo style) {
        return false;
    }

    @Override
    public boolean hideLayerGroup(LayerGroupInfo layerGroup) {
        return false;
    }

    @Override
    public boolean hideWorkspace(WorkspaceInfo workspace) {
        return false;
    }

    @Override
    public boolean hideResource(ResourceInfo resource) {
        return false;
    }

    protected Catalog getCatalog() {
        return (Catalog)GeoServerExtensions.bean((String)"catalog");
    }

    @Override
    public Filter getSecurityFilter(Class<? extends CatalogInfo> clazz) {
        InternalVolatileFunction visible;
        if (ResourceInfo.class.isAssignableFrom(clazz)) {
            visible = new InternalVolatileFunction(){

                public Boolean evaluate(Object object) {
                    return !AbstractCatalogFilter.this.hideResource((ResourceInfo)object);
                }
            };
        } else if (WorkspaceInfo.class.isAssignableFrom(clazz)) {
            visible = new InternalVolatileFunction(){

                public Boolean evaluate(Object object) {
                    return !AbstractCatalogFilter.this.hideWorkspace((WorkspaceInfo)object);
                }
            };
        } else if (LayerGroupInfo.class.isAssignableFrom(clazz)) {
            visible = new InternalVolatileFunction(){

                public Boolean evaluate(Object object) {
                    return !AbstractCatalogFilter.this.hideLayerGroup((LayerGroupInfo)object);
                }
            };
        } else if (StyleInfo.class.isAssignableFrom(clazz)) {
            visible = new InternalVolatileFunction(){

                public Boolean evaluate(Object object) {
                    return !AbstractCatalogFilter.this.hideStyle((StyleInfo)object);
                }
            };
        } else if (LayerInfo.class.isAssignableFrom(clazz)) {
            visible = new InternalVolatileFunction(){

                public Boolean evaluate(Object object) {
                    return !AbstractCatalogFilter.this.hideLayer((LayerInfo)object);
                }
            };
        } else if (NamespaceInfo.class.isAssignableFrom(clazz)) {
            visible = new InternalVolatileFunction(){

                public Boolean evaluate(Object object) {
                    WorkspaceInfo wsInfo = AbstractCatalogFilter.this.getCatalog().getWorkspaceByName(((NamespaceInfo)object).getPrefix());
                    return !AbstractCatalogFilter.this.hideWorkspace(wsInfo);
                }
            };
        } else {
            LOGGER.log(Level.FINE, "CatalogFilter does not recognize interface {0} accepting all.", clazz);
            return Predicates.acceptAll();
        }
        FilterFactory factory = Predicates.factory;
        PropertyIsEqualTo filter = factory.equals((Expression)factory.literal((Object)Boolean.TRUE), (Expression)visible);
        return filter;
    }
}

