/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geoserver.security.DisabledServiceResourceFilter;
import org.geotools.util.decorate.Wrapper;
import org.geotools.util.logging.Logging;

public class DisabledServiceCheck
implements DispatcherCallback {
    static final Logger LOGGER = Logging.getLogger(DisabledServiceCheck.class);
    private GeoServer geoServer;

    public DisabledServiceCheck(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public Request init(Request request) {
        return request;
    }

    public static ServiceInfo lookupServiceInfo(Service service) throws Exception {
        Object s = service.getService();
        Method m = null;
        if (s instanceof Proxy) {
            Class<?>[] interfaces = s.getClass().getInterfaces();
            for (int i = 0; m == null && i < interfaces.length; ++i) {
                m = OwsUtils.getter(interfaces[i], (String)"serviceInfo", ServiceInfo.class);
            }
        } else {
            m = OwsUtils.getter(s.getClass(), (String)"serviceInfo", ServiceInfo.class);
        }
        if (m != null) {
            return (ServiceInfo)m.invoke(s, null);
        }
        return null;
    }

    public Service serviceDispatched(Request request, Service service) {
        try {
            ServiceInfo info = DisabledServiceCheck.lookupServiceInfo(service);
            if (info == null) {
                LOGGER.warning("Could not get a ServiceInfo for service " + service.getId() + " even if the service implements ServiceInfo, thus could not check if the service is enabled");
            } else {
                List<String> disabledServices;
                boolean disabled;
                String layerName;
                LayerInfo layerInfo;
                if (!info.isEnabled()) {
                    throw new ServiceException("Service " + info.getName() + " is disabled", "ServiceUnavailable");
                }
                String context = this.context(request);
                if (context != null && context.contains("/") && (layerInfo = this.getLayerByName(layerName = context.replace("/", ":"))) != null && (disabled = (disabledServices = DisabledServiceResourceFilter.disabledServices(layerInfo.getResource())).stream().anyMatch(serviceType -> StringUtils.equalsIgnoreCase((CharSequence)service.getId(), (CharSequence)serviceType)))) {
                    throw new ServiceException("Service " + info.getName() + " is disabled for layer " + layerName, "ServiceUnavailable");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof ServiceException) {
                throw (ServiceException)e;
            }
            throw new ServiceException((Throwable)e);
        }
        return service;
    }

    String context(Request request) {
        String context = request.getContext();
        if (context != null) {
            int idx2;
            int idx1;
            if (context.contains("gwc/service")) {
                context = context.substring(0, context.indexOf("gwc/service"));
            }
            if (context.startsWith("/")) {
                context = context.substring(1);
            }
            if (context.endsWith("/")) {
                context = context.substring(0, context.length() - 1);
            }
            if ((idx1 = context.indexOf("/")) != -1 && (idx2 = context.indexOf("/", idx1 + 1)) != -1) {
                return context.substring(0, idx2);
            }
        }
        return context;
    }

    LayerInfo getLayerByName(String layerName) {
        Catalog unwrapped;
        Catalog catalog = this.geoServer.getCatalog();
        while (catalog instanceof Wrapper && ((Wrapper)catalog).isWrapperFor(Catalog.class) && (unwrapped = (Catalog)((Wrapper)catalog).unwrap(Catalog.class)) != catalog && unwrapped != null) {
            catalog = unwrapped;
        }
        return catalog.getLayerByName(layerName);
    }

    public Operation operationDispatched(Request request, Operation operation) {
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return result;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return response;
    }

    public void finished(Request request) {
    }
}

