/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.feature.retype.FeatureTypeMap;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.feature.retype.RetypingFeatureSource;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.util.Converters;

public class RetypingFeatureStore
extends RetypingFeatureSource
implements SimpleFeatureStore {
    RetypingFeatureStore(RetypingDataStore ds, SimpleFeatureStore wrapped, FeatureTypeMap typeMap) {
        super(ds, (SimpleFeatureSource)wrapped, typeMap);
    }

    RetypingFeatureStore(SimpleFeatureStore wrapped, FeatureTypeMap typeMap) throws IOException {
        super((SimpleFeatureSource)wrapped, typeMap);
    }

    protected SimpleFeatureStore featureStore() {
        return (SimpleFeatureStore)this.wrapped;
    }

    public Transaction getTransaction() {
        return this.featureStore().getTransaction();
    }

    public void setTransaction(Transaction transaction) {
        this.featureStore().setTransaction(transaction);
    }

    public void removeFeatures(Filter filter) throws IOException {
        this.featureStore().removeFeatures(this.store.retypeFilter(filter, this.typeMap));
    }

    public void setFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        RetypingFeatureCollection.RetypingFeatureReader retypingFeatureReader = new RetypingFeatureCollection.RetypingFeatureReader(reader, this.typeMap.getOriginalFeatureType());
        this.featureStore().setFeatures((FeatureReader)retypingFeatureReader);
    }

    public List<FeatureId> addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        List ids = this.featureStore().addFeatures((FeatureCollection)new RetypingFeatureCollection(DataUtilities.simple(collection), this.typeMap.getOriginalFeatureType()));
        ArrayList<FeatureId> retyped = new ArrayList<FeatureId>();
        for (FeatureId id : ids) {
            retyped.add(RetypingFeatureCollection.reTypeId(id, this.typeMap.getOriginalFeatureType(), this.typeMap.getFeatureType()));
        }
        return retyped;
    }

    public void modifyFeatures(String[] names, Object[] attributeValues, Filter filter) throws IOException {
        Name[] param = (Name[])Arrays.stream(names).map(n -> new NameImpl(n)).toArray(Name[]::new);
        this.modifyFeatures(param, attributeValues, filter);
    }

    public void modifyFeatures(String name, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{new NameImpl(name)}, new Object[]{attributeValue}, filter);
    }

    public void modifyFeatures(Name[] names, Object[] values, Filter filter) throws IOException {
        SimpleFeatureType original = this.typeMap.getOriginalFeatureType();
        Object[] originalValues = new Object[values.length];
        for (int i = 0; i < names.length; ++i) {
            AttributeDescriptor ad = original.getDescriptor(names[i]);
            if (values[i] == null) continue;
            Class target = ad.getType().getBinding();
            originalValues[i] = Converters.convert((Object)values[i], (Class)target);
            if (originalValues[i] != null) continue;
            throw new IOException("Could not map back " + values[i] + " to type " + target);
        }
        this.featureStore().modifyFeatures(names, originalValues, this.store.retypeFilter(filter, this.typeMap));
    }

    public void modifyFeatures(Name attributeName, Object attributeValue, Filter filter) throws IOException {
        this.modifyFeatures(new Name[]{attributeName}, new Object[]{attributeValue}, filter);
    }
}

