/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.awt.RenderingHints;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.geoserver.feature.RetypingFeatureCollection;
import org.geoserver.feature.retype.FeatureTypeMap;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.feature.retype.RetypingFeatureLocking;
import org.geoserver.feature.retype.RetypingFeatureStore;
import org.geoserver.feature.retype.WrappingFeatureListener;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.decorate.Wrapper;

public class RetypingFeatureSource
implements SimpleFeatureSource,
Wrapper {
    SimpleFeatureSource wrapped;
    FeatureTypeMap typeMap;
    RetypingDataStore store;
    Map<FeatureListener, FeatureListener> listeners = new HashMap<FeatureListener, FeatureListener>();

    public static SimpleFeatureSource getRetypingSource(SimpleFeatureSource wrapped, SimpleFeatureType targetSchema) throws IOException {
        FeatureTypeMap map = new FeatureTypeMap((SimpleFeatureType)wrapped.getSchema(), targetSchema);
        if (wrapped instanceof SimpleFeatureLocking) {
            return new RetypingFeatureLocking((SimpleFeatureLocking)wrapped, map);
        }
        if (wrapped instanceof SimpleFeatureStore) {
            return new RetypingFeatureStore((SimpleFeatureStore)wrapped, map);
        }
        return new RetypingFeatureSource(wrapped, map);
    }

    RetypingFeatureSource(RetypingDataStore ds, SimpleFeatureSource wrapped, FeatureTypeMap typeMap) {
        this.store = ds;
        this.wrapped = wrapped;
        this.typeMap = typeMap;
    }

    RetypingFeatureSource(SimpleFeatureSource wrapped, final FeatureTypeMap typeMap) throws IOException {
        this.wrapped = wrapped;
        this.typeMap = typeMap;
        this.store = new RetypingDataStore((DataStore)wrapped.getDataStore()){

            @Override
            protected String transformFeatureTypeName(String originalName) {
                if (typeMap.getOriginalName().equals(originalName)) {
                    return typeMap.getName();
                }
                if (typeMap.getName().equals(originalName)) {
                    return null;
                }
                return originalName;
            }

            @Override
            protected SimpleFeatureType transformFeatureType(SimpleFeatureType original) throws IOException {
                if (typeMap.getOriginalName().equals(original.getTypeName())) {
                    return typeMap.featureType;
                }
                return super.transformFeatureType(original);
            }

            @Override
            public String[] getTypeNames() throws IOException {
                ConcurrentHashMap<String, FeatureTypeMap> forwardMapLocal = new ConcurrentHashMap<String, FeatureTypeMap>();
                ConcurrentHashMap<String, FeatureTypeMap> backwardsMapLocal = new ConcurrentHashMap<String, FeatureTypeMap>();
                forwardMapLocal.put(typeMap.getOriginalName(), typeMap);
                backwardsMapLocal.put(typeMap.getName(), typeMap);
                this.forwardMap = forwardMapLocal;
                this.backwardsMap = backwardsMapLocal;
                return new String[]{typeMap.getName()};
            }
        };
    }

    public Name getName() {
        return this.getSchema().getName();
    }

    public void addFeatureListener(FeatureListener listener) {
        WrappingFeatureListener wrapper = new WrappingFeatureListener(this, listener);
        this.listeners.put(listener, wrapper);
        this.wrapped.addFeatureListener((FeatureListener)wrapper);
    }

    public void removeFeatureListener(FeatureListener listener) {
        FeatureListener wrapper = this.listeners.get(listener);
        if (wrapper != null) {
            this.wrapped.removeFeatureListener(wrapper);
            this.listeners.remove(listener);
        }
    }

    public ReferencedEnvelope getBounds() throws IOException {
        return this.wrapped.getBounds();
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.wrapped.getBounds(this.store.retypeQuery(query, this.typeMap));
    }

    public int getCount(Query query) throws IOException {
        return this.wrapped.getCount(this.store.retypeQuery(query, this.typeMap));
    }

    public DataStore getDataStore() {
        return this.store;
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Query.ALL);
    }

    public SimpleFeatureCollection getFeatures(Query query) throws IOException {
        if (query.getTypeName() == null) {
            query = new Query(query);
            query.setTypeName(this.typeMap.getName());
        } else if (!this.typeMap.getName().equals(query.getTypeName())) {
            throw new IOException("Cannot query this feature source with " + query.getTypeName() + " since it serves only " + this.typeMap.getName());
        }
        SimpleFeatureType target = this.typeMap.getFeatureType(query);
        return new RetypingFeatureCollection(this.wrapped.getFeatures(this.store.retypeQuery(query, this.typeMap)), target);
    }

    public SimpleFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.typeMap.getName(), filter));
    }

    public SimpleFeatureType getSchema() {
        return this.typeMap.getFeatureType();
    }

    public Set<RenderingHints.Key> getSupportedHints() {
        return this.wrapped.getSupportedHints();
    }

    public ResourceInfo getInfo() {
        return this.wrapped.getInfo();
    }

    public QueryCapabilities getQueryCapabilities() {
        return this.wrapped.getQueryCapabilities();
    }

    public boolean isWrapperFor(Class<?> iface) {
        if (this.wrapped instanceof Wrapper) {
            return ((Wrapper)this.wrapped).isWrapperFor(iface);
        }
        return iface.isInstance(this.wrapped);
    }

    public <T> T unwrap(Class<T> iface) throws IllegalArgumentException {
        if (this.wrapped instanceof Wrapper) {
            return (T)((Wrapper)this.wrapped).unwrap(iface);
        }
        if (iface.isInstance(this.wrapped)) {
            return (T)this.wrapped;
        }
        throw new IllegalArgumentException("Cannot unwrap to the requested interface " + iface);
    }
}

