/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.geoserver.feature.SimpleFeatureCollectionBridge;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;

public class CompositeFeatureCollection<T extends FeatureType, F extends Feature>
implements FeatureCollection<T, F> {
    List<? extends FeatureCollection<T, F>> collections;
    T schema;

    public CompositeFeatureCollection(List<? extends FeatureCollection<T, F>> collections) {
        this.collections = collections;
    }

    public CompositeFeatureCollection(List<? extends FeatureCollection<T, F>> collections, T schema) {
        this.collections = collections;
        this.schema = schema;
    }

    public FeatureIterator<F> features() {
        return new CompositeIterator();
    }

    public T getSchema() {
        return this.schema;
    }

    public String getID() {
        throw new RuntimeException("Can't get the id for a composite featurecollection; you need to identify the consituent collections directly.");
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
    }

    public FeatureCollection<T, F> subCollection(Filter filter) {
        return new FilteringFeatureCollection((FeatureCollection)this, filter);
    }

    public FeatureCollection<T, F> sort(SortBy order) {
        if (this.schema instanceof SimpleFeatureCollection) {
            return new SortedSimpleFeatureCollection(DataUtilities.simple((FeatureCollection)this), new SortBy[]{order});
        }
        throw new UnsupportedOperationException("Cannot perform sorting on complex features");
    }

    public ReferencedEnvelope getBounds() {
        Function<FeatureCollection, ReferencedEnvelope> mapper = c -> {
            ReferencedEnvelope envelope = c.getBounds();
            if (envelope == null) {
                return DataUtilities.bounds((FeatureCollection)c);
            }
            return envelope;
        };
        return this.collections.stream().map(mapper).reduce((e1, e2) -> {
            CoordinateReferenceSystem crs2;
            CoordinateReferenceSystem crs1 = e1.getCoordinateReferenceSystem();
            if (crs1 != (crs2 = e2.getCoordinateReferenceSystem()) && !CRS.equalsIgnoreMetadata((Object)crs1, (Object)crs2)) {
                throw new RuntimeException("Two collections are returning different CRSs, cannot perform this accumulation (yet): \n" + crs1 + "\n" + crs2);
            }
            e1.expandToInclude((Envelope)e2);
            return e1;
        }).orElse(null);
    }

    public boolean contains(Object o) {
        return false;
    }

    public boolean containsAll(Collection<?> o) {
        return false;
    }

    public boolean isEmpty() {
        return this.collections.stream().allMatch(c -> c.isEmpty());
    }

    public int size() {
        return this.collections.stream().mapToInt(c -> {
            int size = c.size();
            if (size < 0) {
                size = DataUtilities.count((FeatureCollection)c);
            }
            return size;
        }).sum();
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public <O> O[] toArray(O[] array) {
        ArrayList<SimpleFeature> list2 = new ArrayList<SimpleFeature>();
        for (SimpleFeatureCollection simpleFeatureCollection : this.collections) {
            SimpleFeatureIterator it2 = simpleFeatureCollection.features();
            try {
                while (it2.hasNext()) {
                    list2.add((SimpleFeature)it2.next());
                }
            }
            finally {
                if (it2 == null) continue;
                it2.close();
            }
        }
        return list2.toArray(array);
    }

    public List<? extends FeatureCollection<T, F>> getCollections() {
        return this.collections;
    }

    public boolean isSimple() {
        for (FeatureCollection<T, F> collection : this.collections) {
            if (collection instanceof SimpleFeatureCollection || collection.getSchema() instanceof SimpleFeatureType) continue;
            return false;
        }
        return true;
    }

    public SimpleFeatureCollection simple() {
        if (this.isSimple()) {
            CompositeFeatureCollection cast = this;
            return new SimpleFeatureCollectionBridge(cast);
        }
        throw new ClassCastException("This collection cannot be coerced to SimpleFeatureCollection");
    }

    class CompositeIterator
    implements FeatureIterator<F> {
        int index = 0;
        FeatureIterator<F> iterator;

        public void remove() {
        }

        public boolean hasNext() {
            if (this.iterator != null && this.iterator.hasNext()) {
                return true;
            }
            while (this.index < CompositeFeatureCollection.this.collections.size()) {
                if (this.iterator != null) {
                    this.iterator.close();
                }
                this.iterator = CompositeFeatureCollection.this.collections.get(this.index++).features();
                if (!this.iterator.hasNext()) continue;
                return true;
            }
            if (this.iterator != null) {
                this.iterator.close();
                this.iterator = null;
            }
            return false;
        }

        public F next() {
            return this.iterator.next();
        }

        public void close() {
            if (this.iterator instanceof Closeable) {
                this.iterator.close();
            }
        }
    }
}

