/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.geoserver.catalog.AuthorityURLInfo;
import org.geoserver.catalog.impl.AuthorityURL;

public class AuthorityURLInfoInfoListConverter {
    private static final String NAME = "name";
    private static final String HREF = "href";

    public static List<AuthorityURLInfo> fromString(String str) throws IllegalArgumentException {
        try {
            JSONArray array = JSONArray.fromObject((Object)str);
            int size = array.size();
            ArrayList<AuthorityURLInfo> list2 = new ArrayList<AuthorityURLInfo>(size);
            for (int i = 0; i < size; ++i) {
                JSONObject jsonAuth = array.getJSONObject(i);
                AuthorityURL auth = new AuthorityURL();
                auth.setName(jsonAuth.getString(NAME));
                auth.setHref(jsonAuth.getString(HREF));
                list2.add(auth);
            }
            return list2;
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String toString(List<AuthorityURLInfo> obj) {
        if (obj == null || obj.isEmpty()) {
            return null;
        }
        JSONArray array = new JSONArray();
        for (AuthorityURLInfo auth : obj) {
            if (auth == null) continue;
            JSONObject jsonAuth = new JSONObject();
            jsonAuth.put((Object)NAME, (Object)auth.getName());
            jsonAuth.put((Object)HREF, (Object)auth.getHref());
            array.add((Object)jsonAuth);
        }
        if (array.isEmpty()) {
            return null;
        }
        String serialized = array.toString();
        return serialized;
    }
}

