/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.Info;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geotools.util.logging.Logging;
import org.springframework.util.StringUtils;

class XStreamLoader {
    private static final Logger LOGGER = Logging.getLogger((String)XStreamLoader.class.getPackage().getName());
    private XStreamPersisterFactory xpf;
    static final ThreadLocal<XStreamPersister> XP = new ThreadLocal();

    public XStreamLoader(XStreamPersisterFactory xpfac) {
        this.xpf = xpfac;
    }

    XStreamPersisterFactory getPersisterFactory() {
        return this.xpf;
    }

    public <C extends Info> Optional<C> depersist(Path file) {
        Optional<C> optional;
        block8: {
            InputStream contents = Files.newInputStream(file, StandardOpenOption.READ);
            try {
                optional = Optional.of(this.parse(contents));
                if (contents == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    this.logParseError(file, e);
                    return Optional.empty();
                }
            }
            contents.close();
        }
        return optional;
    }

    public void persist(CatalogInfo info, Path path) throws IOException {
        XStreamPersister persister = this.getXStream();
        try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
            persister.save(info, out);
        }
    }

    private <C extends Info> C parse(InputStream contents) {
        try {
            XStreamPersister xp = this.getXStream();
            return (C)xp.load(contents, Info.class);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void logParseError(Path file, Exception e) {
        String err = e.getMessage();
        if (!StringUtils.hasText((String)err)) {
            err = e.getCause().getMessage();
        }
        LOGGER.log(Level.SEVERE, "Error parsing " + file, err);
    }

    private XStreamPersister getXStream() {
        XStreamPersister xp = XP.get();
        if (xp == null) {
            xp = this.xpf.createXMLPersister();
            XP.set(xp);
        }
        xp.setUnwrapNulls(false);
        xp.setEncryptPasswordFields(false);
        return xp;
    }
}

