/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.datadir;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Info;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSLayerInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.ResolvingProxyResolver;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.datadir.CatalogLoader;
import org.geoserver.config.datadir.DataDirectoryWalker;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.util.IOUtils;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.util.logging.Logging;
import org.springframework.lang.Nullable;

class CatalogLoaderSanitizer {
    private static final Logger LOGGER = Logging.getLogger((String)CatalogLoaderSanitizer.class.getPackage().getName());
    private CatalogLoader loader;

    public CatalogLoaderSanitizer(CatalogLoader loader) {
        this.loader = loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultWorkspace() {
        CatalogImpl catalog = this.loader.catalog;
        DataDirectoryWalker fileWalk = this.loader.fileWalk;
        Optional<Path> defaultWorkspaceFile = fileWalk.defaultWorkspace();
        if (defaultWorkspaceFile.isPresent()) {
            Optional<Object> defaultWorkspace = this.loader.depersist(defaultWorkspaceFile.orElseThrow());
            if ((defaultWorkspace = defaultWorkspace.map(Info::getId).map(catalog::getWorkspace)).isPresent()) {
                WorkspaceInfo ws = (WorkspaceInfo)defaultWorkspace.orElseThrow();
                NamespaceInfo ns = catalog.getNamespaceByPrefix(ws.getName());
                catalog.setDefaultWorkspace(ws);
                catalog.setDefaultNamespace(ns);
                return;
            }
        }
        fileWalk.lock();
        try {
            WorkspaceInfo newDefault;
            if (fileWalk.defaultWorkspace().isEmpty() && (newDefault = this.findFirstWorkspace()) != null) {
                Path path = fileWalk.getDefaultWorkspaceFile();
                try {
                    this.loader.persist(newDefault, path);
                    NamespaceInfo ns = Objects.requireNonNull(catalog.getNamespaceByPrefix(newDefault.getName()));
                    catalog.setDefaultWorkspace(newDefault);
                    catalog.setDefaultNamespace(ns);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Failed to persist " + newDefault + " at '" + path + "'", e);
                }
            }
        }
        finally {
            fileWalk.unlock();
        }
    }

    private WorkspaceInfo findFirstWorkspace() {
        CatalogImpl catalog = this.loader.catalog;
        SortBy sortByName = Predicates.sortBy("name", true);
        try (CloseableIterator<WorkspaceInfo> list2 = catalog.list(WorkspaceInfo.class, Predicates.acceptAll(), 0, 1, sortByName);){
            if (list2.hasNext()) {
                WorkspaceInfo workspaceInfo = (WorkspaceInfo)list2.next();
                return workspaceInfo;
            }
        }
        return null;
    }

    public void initializeDefaultStyles() throws IOException {
        this.initializeStyle("point", "default_point.sld");
        this.initializeStyle("line", "default_line.sld");
        this.initializeStyle("polygon", "default_polygon.sld");
        this.initializeStyle("raster", "default_raster.sld");
        this.initializeStyle("generic", "default_generic.sld");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initializeStyle(String styleName, String sld) throws IOException {
        CatalogImpl catalog = this.loader.catalog;
        if (catalog.getStyleByName(styleName) != null) {
            return;
        }
        DataDirectoryWalker fileWalk = this.loader.fileWalk;
        fileWalk.lock();
        try {
            if (catalog.getStyleByName(styleName) == null) {
                this.copySld(sld);
                StyleInfo s = catalog.getFactory().createStyle();
                s.setName(styleName);
                s.setFilename(sld);
                catalog.add(s);
                Resource resource = fileWalk.getDataDirectory().config(s);
                Path path = resource.file().toPath();
                this.loader.persist(s, path);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Error initializing default style %s" + styleName, e);
        }
        finally {
            fileWalk.unlock();
        }
    }

    private void copySld(String sld) throws IOException {
        GeoServerDataDirectory dataDirectory = this.loader.fileWalk.getDataDirectory();
        Resource styleResource = dataDirectory.getStyles(sld);
        if (!Resources.exists((Resource)styleResource)) {
            try (InputStream in = GeoServerLoader.class.getResourceAsStream(sld);
                 OutputStream out = styleResource.out();){
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
        }
    }

    public boolean validate(@Nullable WorkspaceInfo expectedWorkspace, StyleInfo style) {
        if (null == expectedWorkspace) {
            if (style.getWorkspace() != null) {
                String ws = style.getWorkspace().getId();
                String msg = "Style %s (%s) is expected to have no workspace but has workspace %s. Style ignored.";
                LOGGER.severe(String.format(msg, style.getName(), style.getId(), ws));
                return false;
            }
        } else {
            if (style.getWorkspace() == null) {
                String msg = "Style %s[%s] should have workspace %s but has no workspace. Style ignored.";
                LOGGER.severe(String.format(msg, style.getName(), style.getId(), expectedWorkspace.getName()));
                return false;
            }
            if (!expectedWorkspace.getId().equals(style.getWorkspace().getId())) {
                String ws = style.getWorkspace().getId();
                String msg = "Style %s[%s] should have workspace %s but has workspace %s. Style ignored.";
                LOGGER.severe(String.format(msg, style.getName(), style.getId(), expectedWorkspace.getName(), ws));
                return false;
            }
        }
        return true;
    }

    public void resolveProxies(CatalogInfo info) {
        CatalogImpl catalog = this.loader.catalog;
        catalog.resolve(info);
        ResolvingProxyResolver.resolve(info, (Catalog)catalog);
        if (info instanceof LayerInfo) {
            this.sanitize(catalog, (LayerInfo)info);
        }
    }

    private void sanitize(CatalogImpl catalog, LayerInfo layer) {
        if (layer.getDefaultStyle() == null) {
            LOGGER.warning(() -> String.format("Layer %s is missing the default style, assigning one automatically", layer.prefixedName()));
            ResourceInfo resource = layer.getResource();
            String styleName = resource instanceof FeatureTypeInfo ? "generic" : "raster";
            layer.setDefaultStyle(catalog.getStyleByName(styleName));
        }
    }

    public <I extends CatalogInfo> String typeOf(I info) {
        if (info instanceof WorkspaceInfo) {
            return "workspace";
        }
        if (info instanceof NamespaceInfo) {
            return "namespace";
        }
        if (info instanceof DataStoreInfo) {
            return "data store";
        }
        if (info instanceof CoverageStoreInfo) {
            return "coverage store";
        }
        if (info instanceof WMSStoreInfo) {
            return "WMS store";
        }
        if (info instanceof WMTSStoreInfo) {
            return "WMTS store";
        }
        if (info instanceof FeatureTypeInfo) {
            return "feature type";
        }
        if (info instanceof CoverageInfo) {
            return "coverage";
        }
        if (info instanceof WMSLayerInfo) {
            return "WMS layer";
        }
        if (info instanceof WMTSLayerInfo) {
            return "WMTS layer";
        }
        if (info instanceof LayerInfo) {
            return "layer";
        }
        if (info instanceof LayerGroupInfo) {
            return "layer group";
        }
        if (info instanceof StyleInfo) {
            return "style";
        }
        return "unknown type";
    }
}

