/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ConfigurationException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ReaderUtils {
    private static final Logger LOGGER = Logger.getLogger("org.vfny.geoserver.global");

    private ReaderUtils() {
    }

    public static Element parse(Reader xml) {
        Document doc;
        InputSource in = new InputSource(xml);
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        dfactory.setNamespaceAware(false);
        dfactory.setValidating(false);
        dfactory.setIgnoringComments(true);
        dfactory.setCoalescing(true);
        dfactory.setIgnoringElementContentWhitespace(true);
        try {
            doc = dfactory.newDocumentBuilder().parse(in);
        }
        catch (Exception e) {
            String msg = "Error reading : " + xml;
            throw new RuntimeException(msg, e);
        }
        return doc.getDocumentElement();
    }

    public static File checkFile(File file, boolean isDir) throws Exception {
        if (!file.exists()) {
            throw new Exception("File does not exist: " + file);
        }
        if (isDir && !file.isDirectory()) {
            throw new Exception("File is not a directory:" + file);
        }
        if (!isDir && !file.isFile()) {
            throw new Exception("File is not valid:" + file);
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("File is valid: ").append(file).toString());
        }
        return file;
    }

    public static Element[] getChildElements(Element root, String name) {
        try {
            return ReaderUtils.getChildElements(root, name, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Element[] getChildElements(Element root, String name, boolean mandatory) throws Exception {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            elements.add((Element)child);
        }
        if (mandatory && elements.isEmpty()) {
            throw new Exception(root.getNodeName() + " does not contains a child element named " + name);
        }
        return elements.toArray(new Element[0]);
    }

    public static Element getChildElement(Element root, String name, boolean mandatory) throws Exception {
        Node child;
        for (child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals(child.getNodeName())) continue;
            return (Element)child;
        }
        if (mandatory && child == null) {
            throw new Exception(root.getNodeName() + " does not contains a child element named " + name);
        }
        return null;
    }

    public static Element getChildElement(Element root, String name) {
        try {
            return ReaderUtils.getChildElement(root, name, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getIntAttribute(Element elem, String attName, boolean mandatory, int defaultValue) throws Exception {
        String attValue = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (!mandatory && attValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(attValue);
        }
        catch (Exception ex) {
            if (mandatory) {
                throw new Exception(attName + " attribute of element " + elem.getNodeName() + " must be an integer, but it's '" + attValue + "'");
            }
            return defaultValue;
        }
    }

    public static String getAttribute(Element elem, String attName, boolean mandatory) throws Exception {
        if (elem == null) {
            if (mandatory) {
                throw new NullPointerException();
            }
            return "";
        }
        Attr att = elem.getAttributeNode(attName);
        String value = null;
        if (att != null) {
            value = att.getValue();
        }
        if (mandatory) {
            if (att == null) {
                throw new Exception("element " + elem.getNodeName() + " does not contains an attribute named " + attName);
            }
            if ("".equals(value)) {
                throw new Exception("attribute " + attName + "in element " + elem.getNodeName() + " is empty");
            }
        }
        return value;
    }

    public static boolean getBooleanAttribute(Element elem, String attName, boolean mandatory, boolean defaultValue) throws Exception {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (value == null || "".equals(value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static String getChildText(Element root, String childName) {
        try {
            return ReaderUtils.getChildText(root, childName, false);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getChildText(Element root, String childName, boolean mandatory) throws Exception {
        Element elem = ReaderUtils.getChildElement(root, childName, mandatory);
        if (elem != null) {
            return ReaderUtils.getElementText(elem, mandatory);
        }
        if (mandatory) {
            String msg = "Mandatory child " + childName + "not found in  element: " + root;
            throw new Exception(msg);
        }
        return null;
    }

    public static String getChildAttribute(Element root, String childName, String attName) {
        try {
            return ReaderUtils.getChildAttribute(root, childName, attName, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getChildAttribute(Element root, String childName, String attName, boolean mandatory) throws Exception {
        Element elem = ReaderUtils.getChildElement(root, childName);
        if (elem == null) {
            if (mandatory) {
                throw new Exception("No such child: " + childName);
            }
            return null;
        }
        if (mandatory && !elem.hasAttribute(attName)) {
            throw new Exception("No such attribute: " + attName);
        }
        return elem.getAttribute(attName);
    }

    public static String getElementText(Element elem) {
        try {
            return ReaderUtils.getElementText(elem, false);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getElementText(Element elem, boolean mandatory) throws Exception {
        String value = null;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(new StringBuffer("getting element text for ").append(elem).toString());
        }
        if (elem != null) {
            NodeList childs = elem.getChildNodes();
            int nChilds = childs.getLength();
            for (int i = 0; i < nChilds; ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 3) continue;
                value = child.getNodeValue();
                if (!mandatory || !"".equals(value.trim())) break;
                throw new Exception(elem.getNodeName() + " text is empty");
            }
            if (mandatory && value == null) {
                throw new Exception(elem.getNodeName() + " element does not contains text");
            }
        } else {
            throw new Exception("Argument element can't be null");
        }
        return value;
    }

    public static List<String> getKeyWords(Element keywordsElem) {
        NodeList klist = keywordsElem.getElementsByTagName("keyword");
        int kCount = klist.getLength();
        ArrayList<String> keywords = new ArrayList<String>(kCount);
        for (int i = 0; i < kCount; ++i) {
            Element kelem = (Element)klist.item(i);
            String kword = ReaderUtils.getElementText(kelem);
            if (kword == null) continue;
            keywords.add(kword);
        }
        return keywords;
    }

    public static Element getFirstChildElement(Element root) {
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            return (Element)child;
        }
        return null;
    }

    public static double getDoubleAttribute(Element elem, String attName, boolean mandatory) throws Exception {
        String value = ReaderUtils.getAttribute(elem, attName, mandatory);
        if (value == null || "".equals(value)) {
            return 0.0;
        }
        double d = Double.NaN;
        if (value != null) {
            try {
                d = Double.parseDouble(value);
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationException("Illegal attribute value for " + attName + " in element " + elem.getNodeName() + ". Expected double, but was " + value);
            }
        }
        return d;
    }
}

