/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.LegendInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.LegacyCatalogReader;
import org.geoserver.catalog.util.LegacyCoverageInfoReader;
import org.geoserver.catalog.util.LegacyFeatureTypeInfoReader;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.DataAccess;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.DefaultMathTransformFactory;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class LegacyCatalogImporter {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.catalog");
    Catalog catalog;
    GeoServerResourceLoader resourceLoader;

    public LegacyCatalogImporter(Catalog catalog) {
        this.catalog = catalog;
    }

    public LegacyCatalogImporter() {
    }

    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void imprt(File dir) throws Exception {
        File[] coverageDirectories;
        File coverages;
        File[] featureTypeDirectories;
        CatalogFactory factory = this.catalog.getFactory();
        File catalogFile = new File(dir, "catalog.xml");
        if (!catalogFile.exists()) {
            throw new FileNotFoundException("Could not find catalog.xml under:" + dir.getAbsolutePath());
        }
        this.importCatalog(catalogFile);
        File featureTypes = new File(dir, "featureTypes");
        if (!featureTypes.exists()) {
            featureTypes.mkdir();
        }
        if ((featureTypeDirectories = featureTypes.listFiles()) != null) {
            for (File featureTypeDirectory : featureTypeDirectories) {
                if (!featureTypeDirectory.isDirectory() || featureTypeDirectory.isHidden()) continue;
                File ftInfoFile = new File(featureTypeDirectory, "info.xml");
                if (!ftInfoFile.exists()) {
                    LOGGER.fine("No info.xml found in directory: '" + featureTypeDirectory.getName() + "', ignoring");
                    continue;
                }
                LegacyFeatureTypeInfoReader ftInfoReader = new LegacyFeatureTypeInfoReader();
                try {
                    Map<String, Object> legendURL;
                    List<String> styles;
                    StyleInfo style;
                    ftInfoReader.read(Files.asResource((File)ftInfoFile));
                    FeatureTypeInfo featureType = this.readFeatureType(ftInfoReader, featureTypeDirectory);
                    if (featureType == null) continue;
                    this.catalog.add(featureType);
                    LOGGER.config("Loaded feature type '" + featureType.prefixedName() + "'");
                    LayerInfo layer = factory.createLayer();
                    layer.setResource(featureType);
                    layer.setName(featureType.getName());
                    layer.setPath(ftInfoReader.wmsPath());
                    if (layer.getPath() == null) {
                        layer.setPath("/");
                    }
                    layer.setType(PublishedType.VECTOR);
                    String defaultStyleName = ftInfoReader.defaultStyle();
                    if (defaultStyleName != null && (style = this.catalog.getStyleByName(defaultStyleName)) != null) {
                        layer.setDefaultStyle(style);
                    }
                    if ((styles = ftInfoReader.styles()) != null) {
                        for (String styleName : styles) {
                            StyleInfo style2 = this.catalog.getStyleByName(styleName);
                            if (style2 == null) continue;
                            layer.getStyles().add(style2);
                        }
                    }
                    if ((legendURL = ftInfoReader.legendURL()) != null) {
                        LegendInfo legend = factory.createLegend();
                        legend.setHeight((Integer)legendURL.get("height"));
                        legend.setWidth((Integer)legendURL.get("width"));
                        legend.setFormat((String)legendURL.get("format"));
                        legend.setOnlineResource((String)legendURL.get("onlineResource"));
                        layer.setLegend(legend);
                    }
                    layer.setEnabled(featureType.isEnabled());
                    this.catalog.add(layer);
                }
                catch (Exception e) {
                    LOGGER.warning("Error loadin '" + featureTypeDirectory.getName() + "/info.xml', ignoring");
                    LOGGER.log(Level.INFO, "", e);
                }
            }
        }
        if (!(coverages = new File(dir, "coverages")).exists()) {
            coverages.mkdir();
        }
        if ((coverageDirectories = coverages.listFiles()) != null) {
            for (File coverageDirectory : coverageDirectories) {
                if (!coverageDirectory.isDirectory() || coverageDirectory.isHidden()) continue;
                File cInfoFile = new File(coverageDirectory, "info.xml");
                if (!cInfoFile.exists()) {
                    LOGGER.fine("No info.xml found in directory: '" + coverageDirectory.getName() + "', ignoring");
                    continue;
                }
                LegacyCoverageInfoReader cInfoReader = new LegacyCoverageInfoReader();
                try {
                    List<String> styles;
                    StyleInfo style;
                    cInfoReader.read(cInfoFile);
                    CoverageInfo coverage = this.readCoverage(cInfoReader);
                    if (coverage == null) continue;
                    this.catalog.add(coverage);
                    LayerInfo layer = factory.createLayer();
                    layer.setResource(coverage);
                    layer.setName(coverage.getName());
                    layer.setPath(cInfoReader.wmsPath());
                    if (layer.getPath() == null) {
                        layer.setPath("/");
                    }
                    layer.setType(PublishedType.RASTER);
                    String defaultStyleName = cInfoReader.defaultStyle();
                    if (defaultStyleName != null && (style = this.catalog.getStyleByName(defaultStyleName)) != null) {
                        layer.setDefaultStyle(style);
                    }
                    if ((styles = cInfoReader.styles()) != null) {
                        for (String styleName : styles) {
                            StyleInfo style3 = this.catalog.getStyleByName(styleName);
                            if (style3 == null) continue;
                            layer.getStyles().add(style3);
                        }
                    }
                    layer.setEnabled(coverage.isEnabled());
                    this.catalog.add(layer);
                }
                catch (Exception e) {
                    LOGGER.warning("Error loading '" + coverageDirectory.getName() + "/info.xml', ignoring");
                    LOGGER.log(Level.INFO, "", e);
                }
            }
        }
    }

    void importCatalog(File catalogFile) throws FileNotFoundException, IOException, Exception {
        CatalogFactory factory = this.catalog.getFactory();
        LegacyCatalogReader reader = new LegacyCatalogReader();
        reader.read(Files.asResource((File)catalogFile));
        this.importNamespaces(factory, reader.namespaces(), false);
        this.importNamespaces(factory, reader.isolatedNamespaces(), true);
        this.importStyles(factory, reader.styles());
        this.importDataStores(factory, reader.dataStores());
        this.importFormats(factory, reader.formats());
    }

    void importFormats(CatalogFactory factory, List formats) {
        for (Object format : formats) {
            Map map = (Map)format;
            CoverageStoreInfo coverageStore = factory.createCoverageStore();
            coverageStore.setName((String)map.get("id"));
            coverageStore.setType((String)map.get("type"));
            coverageStore.setURL((String)map.get("url"));
            coverageStore.setDescription((String)map.get("description"));
            String namespacePrefix = (String)map.get("namespace");
            coverageStore.setWorkspace(this.catalog.getWorkspaceByName(namespacePrefix));
            coverageStore.setEnabled((Boolean)map.get("enabled"));
            this.catalog.add(coverageStore);
            LOGGER.info("Processed coverage store '" + coverageStore.getName() + "', " + (coverageStore.isEnabled() ? "enabled" : "disabled"));
        }
    }

    void importDataStores(CatalogFactory factory, Map dataStores) {
        for (Object item : dataStores.values()) {
            Map map = (Map)item;
            DataStoreInfo dataStore = factory.createDataStore();
            dataStore.setName((String)map.get("id"));
            String namespacePrefix = (String)map.get("namespace");
            dataStore.setWorkspace(this.catalog.getWorkspaceByName(namespacePrefix));
            Map connectionParams = (Map)map.get("connectionParams");
            Iterator iterator = connectionParams.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry entry = o = iterator.next();
                String key = (String)entry.getKey();
                Serializable value = (Serializable)entry.getValue();
                dataStore.getConnectionParameters().put(key, value);
            }
            NamespaceInfo ns = this.catalog.getNamespaceByPrefix(dataStore.getWorkspace().getName());
            dataStore.getConnectionParameters().put("namespace", (Serializable)((Object)ns.getURI()));
            dataStore.setEnabled((Boolean)map.get("enabled"));
            if ("app-schema".equals(connectionParams.get("dbtype"))) {
                dataStore.setType("Application Schema DataAccess");
            }
            this.catalog.add(dataStore);
            if (!dataStore.isEnabled()) continue;
            try {
                dataStore.getDataStore(null);
                LOGGER.config("Processed data store '" + dataStore.getName() + "', " + (dataStore.isEnabled() ? "enabled" : "disabled"));
            }
            catch (Exception e) {
                LOGGER.warning("Error connecting to '" + dataStore.getName() + "'");
                LOGGER.log(Level.INFO, "", e);
                dataStore.setError(e);
                dataStore.setEnabled(false);
            }
        }
    }

    void importStyles(CatalogFactory factory, Map styles) {
        Iterator iterator = styles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            StyleInfo style = factory.createStyle();
            style.setName((String)entry.getKey());
            style.setFilename((String)entry.getValue());
            this.catalog.add(style);
            LOGGER.info("Loaded style '" + style.getName() + "'");
        }
    }

    void importNamespaces(CatalogFactory factory, Map namespaces) {
        this.importNamespaces(factory, namespaces, false);
    }

    void importNamespaces(CatalogFactory factory, Map namespaces, boolean isolated) {
        for (Map.Entry o : namespaces.entrySet()) {
            Map.Entry entry = o;
            if (entry.getKey() == null || "".equals(entry.getKey())) continue;
            NamespaceInfo namespace = factory.createNamespace();
            namespace.setPrefix((String)entry.getKey());
            namespace.setURI((String)entry.getValue());
            namespace.setIsolated(isolated);
            this.catalog.add(namespace);
            WorkspaceInfo workspace = factory.createWorkspace();
            workspace.setName((String)entry.getKey());
            workspace.setIsolated(isolated);
            this.catalog.add(workspace);
            if (namespace.getURI().equals(namespaces.get(""))) {
                this.catalog.setDefaultNamespace(namespace);
                this.catalog.setDefaultWorkspace(workspace);
            }
            LOGGER.config("Loaded namespace '" + namespace.getPrefix() + "' (" + namespace.getURI() + ")");
        }
        if (this.catalog.getDefaultNamespace() != null) {
            LOGGER.config("Default namespace: '" + this.catalog.getDefaultNamespace().getPrefix() + "'");
        } else {
            LOGGER.warning("No default namespace set.");
        }
    }

    FeatureTypeInfo readFeatureType(LegacyFeatureTypeInfoReader ftInfoReader, File ftDirectory) throws Exception {
        CatalogFactory factory = this.catalog.getFactory();
        FeatureTypeInfo featureType = factory.createFeatureType();
        featureType.setNativeName(ftInfoReader.name());
        if (ftInfoReader.alias() != null) {
            featureType.setName(ftInfoReader.alias());
        } else {
            featureType.setName(ftInfoReader.name());
        }
        featureType.setSRS("EPSG:" + ftInfoReader.srs());
        ProjectionPolicy pp = ProjectionPolicy.get(ftInfoReader.srsHandling());
        featureType.setProjectionPolicy(pp);
        featureType.setTitle(ftInfoReader.title());
        featureType.setAbstract(ftInfoReader.abstrct());
        for (String string : ftInfoReader.keywords()) {
            featureType.getKeywords().add(new Keyword(string));
        }
        for (Map map : ftInfoReader.metadataLinks()) {
            MetadataLinkInfo link = factory.createMetadataLink();
            link.setContent((String)map.get(null));
            link.setMetadataType((String)map.get("metadataType"));
            link.setType((String)map.get("type"));
            featureType.getMetadataLinks().add(link);
        }
        featureType.setLatLonBoundingBox(new ReferencedEnvelope(ftInfoReader.latLonBoundingBox(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        featureType.setEnabled(true);
        featureType.setMaxFeatures(ftInfoReader.maxFeatures());
        featureType.getMetadata().put("dirName", (Serializable)((Object)ftInfoReader.parentDirectoryName()));
        featureType.getMetadata().put("indexingEnabled", Boolean.valueOf(ftInfoReader.searchable()));
        featureType.getMetadata().put("cachingEnabled", Boolean.valueOf(ftInfoReader.cachingEnabled()));
        featureType.getMetadata().put("cacheAgeMax", (Serializable)((Object)ftInfoReader.cacheAgeMax()));
        featureType.getMetadata().put("kml.regionateAttribute", (Serializable)((Object)ftInfoReader.regionateAttribute()));
        featureType.getMetadata().put("kml.regionateStrategy", (Serializable)((Object)ftInfoReader.regionateStrategy()));
        featureType.getMetadata().put("kml.regionateFeatureLimit", Integer.valueOf(ftInfoReader.regionateFeatureLimit()));
        String dataStoreName = ftInfoReader.dataStore();
        DataStoreInfo dataStoreInfo = this.catalog.getDataStoreByName(dataStoreName);
        if (dataStoreInfo == null) {
            LOGGER.warning("Ignoring feature type: '" + ftInfoReader.parentDirectoryName() + "', data store '" + dataStoreName + "'  not found");
            return null;
        }
        featureType.setStore(dataStoreInfo);
        String prefix = dataStoreInfo.getWorkspace().getName();
        featureType.setNamespace(this.catalog.getNamespaceByPrefix(prefix));
        if (featureType.isEnabled() && !dataStoreInfo.isEnabled()) {
            LOGGER.info("Ignoring feature type: '" + ftInfoReader.parentDirectoryName() + "', data store is disabled");
            featureType.setEnabled(false);
        }
        if (featureType.isEnabled()) {
            Envelope nativeBBOX;
            Exception error = null;
            DataAccess<? extends FeatureType, ? extends Feature> ds = null;
            try {
                ds = dataStoreInfo.getDataStore(null);
            }
            catch (Exception e) {
                LOGGER.warning("Ignoring feature type: '" + featureType.getName() + "', error occured connecting to data store: " + e.getMessage());
                LOGGER.log(Level.INFO, "", e);
                error = e;
            }
            if (error == null) {
                try {
                    FeatureType ft = ds.getSchema(featureType.getQualifiedNativeName());
                    featureType.setNativeCRS(ft.getCoordinateReferenceSystem());
                }
                catch (Exception e) {
                    LOGGER.warning("Ignoring feature type: '" + featureType.getNativeName() + "', error occured loading schema: " + e.getMessage());
                    LOGGER.log(Level.INFO, "", e);
                    error = e;
                }
            }
            if (error == null && (nativeBBOX = ftInfoReader.nativeBoundingBox()) != null) {
                featureType.setNativeBoundingBox(new ReferencedEnvelope(nativeBBOX, featureType.getNativeCRS()));
            }
            if (error != null) {
                featureType.setEnabled(false);
            }
        }
        return featureType;
    }

    CoverageInfo readCoverage(LegacyCoverageInfoReader cInfoReader) throws Exception {
        CatalogFactory factory = this.catalog.getFactory();
        String coverageStoreName = cInfoReader.format();
        CoverageStoreInfo coverageStore = this.catalog.getCoverageStoreByName(coverageStoreName);
        if (coverageStore == null) {
            LOGGER.warning("Ignoring coverage: '" + cInfoReader.parentDirectoryName() + "', coverage store '" + coverageStoreName + "'  not found");
            return null;
        }
        if (!coverageStore.isEnabled()) {
            LOGGER.info("Ignoring coverage: '" + cInfoReader.parentDirectoryName() + "', coverage store is disabled");
            return null;
        }
        CoverageInfo coverage = factory.createCoverage();
        coverage.setStore(coverageStore);
        coverage.setName(cInfoReader.name());
        coverage.setNativeName(cInfoReader.name());
        coverage.setTitle(cInfoReader.label());
        coverage.setDescription(cInfoReader.description());
        for (String kw : cInfoReader.keywords()) {
            coverage.getKeywords().add(new Keyword(kw));
        }
        Map<String, Object> envelope = cInfoReader.envelope();
        String userDefinedCrsIdentifier = (String)envelope.get("srsName");
        String nativeCrsWkt = (String)envelope.get("crs");
        coverage.setSRS(userDefinedCrsIdentifier);
        CoordinateReferenceSystem crs = CRS.parseWKT((String)nativeCrsWkt);
        coverage.setNativeCRS(crs);
        ReferencedEnvelope bounds = new ReferencedEnvelope(((Double)envelope.get("x1")).doubleValue(), ((Double)envelope.get("x2")).doubleValue(), ((Double)envelope.get("y1")).doubleValue(), ((Double)envelope.get("y2")).doubleValue(), crs);
        coverage.setNativeBoundingBox(bounds);
        GeneralBounds boundsLatLon = CoverageStoreUtils.getWGS84LonLatEnvelope(new GeneralBounds((Bounds)bounds));
        coverage.setLatLonBoundingBox(new ReferencedEnvelope((Bounds)boundsLatLon));
        GeneralBounds gridEnvelope = new GeneralBounds((Bounds)bounds);
        Map<String, Object> grid = cInfoReader.grid();
        if (grid != null) {
            int[] low = (int[])grid.get("low");
            int[] nArray = (int[])grid.get("high");
            GeneralGridEnvelope range = new GeneralGridEnvelope(low, nArray);
            Map tx = (Map)grid.get("geoTransform");
            if (tx != null) {
                double[] matrix = new double[9];
                matrix[0] = tx.get("scaleX") != null ? (Double)tx.get("scaleX") : matrix[0];
                matrix[1] = tx.get("shearX") != null ? (Double)tx.get("shearX") : matrix[1];
                matrix[2] = tx.get("translateX") != null ? (Double)tx.get("translateX") : matrix[2];
                matrix[3] = tx.get("shearY") != null ? (Double)tx.get("shearY") : matrix[3];
                matrix[4] = tx.get("scaleY") != null ? (Double)tx.get("scaleY") : matrix[4];
                matrix[5] = tx.get("translateY") != null ? (Double)tx.get("translateY") : matrix[5];
                matrix[8] = 1.0;
                MathTransform gridToCRS = new DefaultMathTransformFactory().createAffineTransform((Matrix)new GeneralMatrix(3, 3, matrix));
                coverage.setGrid((GridGeometry)new GridGeometry2D((GridEnvelope)range, gridToCRS, crs));
            } else {
                coverage.setGrid((GridGeometry)new GridGeometry2D((GridEnvelope)range, (Bounds)gridEnvelope));
            }
        } else {
            GeneralGridEnvelope range = new GeneralGridEnvelope(new int[]{0, 0}, new int[]{1, 1});
            coverage.setGrid((GridGeometry)new GridGeometry2D((GridEnvelope)range, (Bounds)gridEnvelope));
        }
        for (Map map : cInfoReader.coverageDimensions()) {
            CoverageDimensionInfo cd = factory.createCoverageDimension();
            cd.setName((String)map.get("name"));
            cd.setDescription((String)map.get("description"));
            cd.setRange((NumberRange<? extends Number>)NumberRange.create((double)((Double)map.get("min")), (double)((Double)map.get("max"))));
            coverage.getDimensions().add(cd);
        }
        coverage.setNativeFormat(cInfoReader.nativeFormat());
        coverage.getSupportedFormats().addAll(cInfoReader.supportedFormats());
        coverage.setDefaultInterpolationMethod(cInfoReader.defaultInterpolation());
        coverage.getInterpolationMethods().addAll(cInfoReader.supportedInterpolations());
        coverage.getRequestSRS().addAll(cInfoReader.requestCRSs());
        coverage.getResponseSRS().addAll(cInfoReader.responseCRSs());
        coverage.getMetadata().put("dirName", (Serializable)((Object)cInfoReader.parentDirectoryName()));
        coverage.setEnabled(coverageStore.isEnabled());
        coverage.getParameters().putAll(cInfoReader.parameters());
        String prefix = this.catalog.getCoverageStoreByName(coverageStoreName).getWorkspace().getName();
        coverage.setNamespace(this.catalog.getNamespaceByPrefix(prefix));
        return coverage;
    }
}

