/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geotools.util.logging.Logging;

class ModificationProxyCloner {
    private static final XStreamPersisterFactory XSTREAM_PERSISTER_FACTORY = new XStreamPersisterFactory();
    static final Logger LOGGER = Logging.getLogger(ModificationProxyCloner.class);
    static final Map<Class<? extends CatalogInfo>, Class<? extends CatalogInfo>> CATALOGINFO_INTERFACE_CACHE = new ConcurrentHashMap<Class<? extends CatalogInfo>, Class<? extends CatalogInfo>>();

    ModificationProxyCloner() {
    }

    static <T> T clone(T source) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (source == null) {
            return null;
        }
        if (ModificationProxy.handler(source) != null) {
            return source;
        }
        if (source instanceof CatalogInfo) {
            CatalogInfo cis = (CatalogInfo)source;
            return (T)ModificationProxy.create(cis, ModificationProxyCloner.getDeepestCatalogInfoInterface(cis));
        }
        if (source instanceof LayerGroupStyle) {
            return (T)ModificationProxy.create(source, LayerGroupStyle.class);
        }
        if (source instanceof String || source instanceof Byte || source instanceof Short || source instanceof Integer || source instanceof Float || source instanceof Double || source instanceof BigInteger || source instanceof BigDecimal) {
            return source;
        }
        if (source instanceof TimeZone) {
            return (T)((TimeZone)source).clone();
        }
        if (source instanceof Map) {
            return (T)ModificationProxyCloner.cloneMap((Map)source, true);
        }
        if (source instanceof Collection) {
            return (T)ModificationProxyCloner.cloneCollection((Collection)source, true);
        }
        try {
            Method method;
            if (source instanceof Cloneable && Modifier.isPublic((method = source.getClass().getDeclaredMethod("clone", new Class[0])).getModifiers()) && method.getParameterTypes().length == 0) {
                return (T)method.invoke(source, new Object[0]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Source object is cloneable, yet it does not have a public no argument method 'clone'", e);
        }
        Constructor copyConstructor = ConstructorUtils.getAccessibleConstructor(source.getClass(), source.getClass());
        if (copyConstructor != null) {
            try {
                return copyConstructor.newInstance(source);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Source has a copy constructor, but it failed, skipping to XStream", e);
            }
        }
        if (source instanceof Serializable) {
            return (T)ModificationProxyCloner.cloneSerializable((Serializable)source);
        }
        XStreamPersister persister = XSTREAM_PERSISTER_FACTORY.createXMLPersister();
        XStream xs = persister.getXStream();
        String xml = xs.toXML(source);
        Object copy = xs.fromXML(xml);
        return (T)copy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static <T extends Serializable> T cloneSerializable(T source) {
        byte[] bytes = SerializationUtils.serialize(source);
        try (ModProxyObjectInputStream input = new ModProxyObjectInputStream(new ByteArrayInputStream(bytes));){
            Serializable copy;
            Serializable serializable = copy = (Serializable)input.readObject();
            return (T)serializable;
        }
        catch (Exception e) {
            throw new RuntimeException("Error cloning serializable object", e);
        }
    }

    static Class<? extends CatalogInfo> getDeepestCatalogInfoInterface(CatalogInfo object) {
        Class<?> sourceClass = object.getClass();
        Class result = CATALOGINFO_INTERFACE_CACHE.get(sourceClass);
        if (result == null) {
            List interfaces = ClassUtils.getAllInterfaces(sourceClass);
            ArrayList<Class> cis = new ArrayList<Class>();
            for (Class clazz : interfaces) {
                if (!CatalogInfo.class.isAssignableFrom(clazz)) continue;
                Class cast = clazz;
                cis.add(cast);
            }
            if (cis.isEmpty()) {
                result = null;
            } else if (cis.size() == 1) {
                result = (Class)cis.get(0);
            } else {
                Collections.sort(cis, (c1, c2) -> {
                    if (c1.isAssignableFrom((Class<?>)c2)) {
                        return 1;
                    }
                    if (c2.isAssignableFrom((Class<?>)c1)) {
                        return -1;
                    }
                    return 0;
                });
                result = (Class)cis.get(0);
            }
            CATALOGINFO_INTERFACE_CACHE.put(sourceClass, result);
        }
        return result;
    }

    public static <T> Collection<T> cloneCollection(Collection<T> source, boolean deepCopy) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Collection<T> copy;
        if (source == null) {
            return null;
        }
        try {
            Collection coll = (Collection)source.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            copy = coll;
        }
        catch (InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            copy = source instanceof Set ? new HashSet() : new ArrayList();
        }
        if (deepCopy) {
            for (T object : source) {
                T objectCopy = ModificationProxyCloner.clone(object);
                copy.add(objectCopy);
            }
        } else {
            copy.addAll(source);
        }
        return copy;
    }

    public static <K, V> Map<K, V> cloneMap(Map<K, V> source, boolean deepCopy) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (source == null) {
            return null;
        }
        Map copy = (Map)source.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (deepCopy) {
            for (Map.Entry<K, V> entry : source.entrySet()) {
                K keyCopy = ModificationProxyCloner.clone(entry.getKey());
                V valueCopy = ModificationProxyCloner.clone(entry.getValue());
                copy.put(keyCopy, valueCopy);
            }
        } else {
            copy.putAll(source);
        }
        return copy;
    }

    static class ModProxyObjectInputStream
    extends ObjectInputStream {
        ClassLoader classLoader = ModificationProxy.class.getClassLoader();

        public ModProxyObjectInputStream(InputStream input) throws IOException {
            super(input);
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }
}

