/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.LayerGroupStyle;
import org.geoserver.util.InternationalStringUtils;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;

public class LayerGroupStyleImpl
implements LayerGroupStyle {
    private String id = this.getClass().getSimpleName().concat("--").concat(new UID().toString());
    private StyleInfo name;
    private String title;
    private GrowableInternationalString internationalTitle;
    private String abstractTxt;
    private GrowableInternationalString internationalAbstract;
    private List<PublishedInfo> layers = new ArrayList<PublishedInfo>();
    private List<StyleInfo> styles = new ArrayList<StyleInfo>();

    public LayerGroupStyleImpl() {
    }

    public LayerGroupStyleImpl(LayerGroupStyleImpl groupStyle) {
        this((LayerGroupStyle)groupStyle);
    }

    public LayerGroupStyleImpl(LayerGroupStyle groupStyle) {
        this.id = groupStyle.getId();
        this.name = groupStyle.getName();
        this.title = groupStyle.getTitle();
        this.abstractTxt = groupStyle.getAbstract();
        this.internationalTitle = groupStyle.getInternationalTitle();
        this.internationalAbstract = groupStyle.getInternationalAbstract();
        this.layers = new ArrayList<PublishedInfo>();
        this.layers.addAll(groupStyle.getLayers());
        this.styles = new ArrayList<StyleInfo>(groupStyle.getStyles().size());
        this.styles.addAll(groupStyle.getStyles());
    }

    @Override
    public StyleInfo getName() {
        return this.name;
    }

    @Override
    public void setName(StyleInfo name) {
        this.name = name;
    }

    @Override
    public List<PublishedInfo> getLayers() {
        return this.layers;
    }

    @Override
    public void setLayers(List<PublishedInfo> layers) {
        this.layers = layers;
    }

    @Override
    public List<StyleInfo> getStyles() {
        return this.styles;
    }

    @Override
    public void setStyles(List<StyleInfo> styles) {
        this.styles = styles;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTitle() {
        return InternationalStringUtils.getOrDefault(this.title, (InternationalString)this.internationalAbstract);
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public GrowableInternationalString getInternationalTitle() {
        return this.internationalTitle;
    }

    @Override
    public void setInternationalTitle(InternationalString internationalTitle) {
        this.internationalTitle = InternationalStringUtils.growable(internationalTitle);
    }

    @Override
    public String getAbstract() {
        return InternationalStringUtils.getOrDefault(this.abstractTxt, (InternationalString)this.internationalAbstract);
    }

    @Override
    public void setAbstract(String abstractTxt) {
        this.abstractTxt = abstractTxt;
    }

    @Override
    public GrowableInternationalString getInternationalAbstract() {
        return this.internationalAbstract;
    }

    @Override
    public void setInternationalAbstract(GrowableInternationalString internationalAbstract) {
        this.internationalAbstract = InternationalStringUtils.growable((InternationalString)internationalAbstract);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayerGroupStyleImpl that = (LayerGroupStyleImpl)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.title, that.title) && Objects.equals(this.internationalTitle, that.internationalTitle) && Objects.equals(this.abstractTxt, that.abstractTxt) && Objects.equals(this.internationalAbstract, that.internationalAbstract) && Objects.equals(this.layers, that.layers) && Objects.equals(this.styles, that.styles);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.title, this.internationalTitle, this.abstractTxt, this.internationalAbstract, this.layers, this.styles);
    }
}

