/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogCapabilities;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.LocalWorkspace;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;

final class IsolatedCatalogFacade
implements CatalogFacade {
    private final CatalogFacade facade;

    IsolatedCatalogFacade(CatalogFacade facade) {
        this.facade = facade;
    }

    @Override
    public Catalog getCatalog() {
        return this.facade.getCatalog();
    }

    @Override
    public void setCatalog(Catalog catalog) {
        this.facade.setCatalog(catalog);
    }

    @Override
    public StoreInfo add(StoreInfo store) {
        return this.facade.add(store);
    }

    @Override
    public void remove(StoreInfo store) {
        this.facade.remove(store);
    }

    @Override
    public void save(StoreInfo store) {
        this.facade.save(store);
    }

    @Override
    public <T extends StoreInfo> T detach(T store) {
        return this.facade.detach(store);
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        return this.enforceStoreIsolation(this.facade.getStore(id, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        return this.canSeeWorkspace(workspace) ? (T)this.facade.getStoreByName(workspace, name, clazz) : null;
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        return this.canSeeWorkspace(workspace) ? this.facade.getStoresByWorkspace(workspace, clazz) : Collections.emptyList();
    }

    @Override
    public <T extends StoreInfo> List<T> getStores(Class<T> clazz) {
        return this.filterIsolated(this.facade.getStores(clazz), clazz, this::enforceStoreIsolation);
    }

    @Override
    public DataStoreInfo getDefaultDataStore(WorkspaceInfo workspace) {
        return this.enforceStoreIsolation(this.facade.getDefaultDataStore(workspace));
    }

    @Override
    public void setDefaultDataStore(WorkspaceInfo workspace, DataStoreInfo store) {
        this.facade.setDefaultDataStore(workspace, store);
    }

    @Override
    public ResourceInfo add(ResourceInfo resource) {
        return this.facade.add(resource);
    }

    @Override
    public void remove(ResourceInfo resource) {
        this.facade.remove(resource);
    }

    @Override
    public void save(ResourceInfo resource) {
        this.facade.save(resource);
    }

    @Override
    public <T extends ResourceInfo> T detach(T resource) {
        return this.facade.detach(resource);
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        return this.enforceResourceIsolation(this.facade.getResource(id, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo namespace, String name, Class<T> clazz) {
        NamespaceInfo localNamespace = this.tryMatchLocalNamespace(namespace);
        if (localNamespace != null) {
            return this.facade.getResourceByName(localNamespace, name, clazz);
        }
        return this.enforceResourceIsolation(this.facade.getResourceByName(namespace, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResources(Class<T> clazz) {
        return this.filterIsolated(this.facade.getResources(clazz), clazz, this::enforceResourceIsolation);
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo namespace, Class<T> clazz) {
        NamespaceInfo localNamespace = this.tryMatchLocalNamespace(namespace);
        if (localNamespace != null) {
            return this.facade.getResourcesByNamespace(localNamespace, clazz);
        }
        return this.filterIsolated(this.facade.getResourcesByNamespace(namespace, clazz), clazz, this::enforceResourceIsolation);
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        return this.enforceResourceIsolation(this.facade.getResourceByStore(store, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        return this.filterIsolated(this.facade.getResourcesByStore(store, clazz), clazz, this::enforceResourceIsolation);
    }

    @Override
    public LayerInfo add(LayerInfo layer) {
        return this.facade.add(layer);
    }

    @Override
    public void remove(LayerInfo layer) {
        this.facade.remove(layer);
    }

    @Override
    public void save(LayerInfo layer) {
        this.facade.save(layer);
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return this.facade.detach(layer);
    }

    @Override
    public LayerInfo getLayer(String id) {
        return this.enforceLayerIsolation(this.facade.getLayer(id));
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        return this.enforceLayerIsolation(this.facade.getLayerByName(name));
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        return this.filterIsolated(this.facade.getLayers(resource), LayerInfo.class, this::enforceLayerIsolation);
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        return this.filterIsolated(this.facade.getLayers(style), LayerInfo.class, this::enforceLayerIsolation);
    }

    @Override
    public List<LayerInfo> getLayers() {
        return this.filterIsolated(this.facade.getLayers(), LayerInfo.class, this::enforceLayerIsolation);
    }

    @Override
    public MapInfo add(MapInfo map) {
        return this.facade.add(map);
    }

    @Override
    public void remove(MapInfo map) {
        this.facade.remove(map);
    }

    @Override
    public void save(MapInfo map) {
        this.facade.save(map);
    }

    @Override
    public MapInfo detach(MapInfo map) {
        return this.facade.detach(map);
    }

    @Override
    public MapInfo getMap(String id) {
        return this.facade.getMap(id);
    }

    @Override
    public MapInfo getMapByName(String name) {
        return this.facade.getMapByName(name);
    }

    @Override
    public List<MapInfo> getMaps() {
        return this.facade.getMaps();
    }

    @Override
    public LayerGroupInfo add(LayerGroupInfo layerGroup) {
        return this.facade.add(layerGroup);
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        this.facade.remove(layerGroup);
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        this.facade.save(layerGroup);
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return this.facade.detach(layerGroup);
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        return this.enforceLayerGroupIsolation(this.facade.getLayerGroup(id));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        return this.enforceLayerGroupIsolation(this.facade.getLayerGroupByName(name));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo workspace, String name) {
        return this.enforceLayerGroupIsolation(this.facade.getLayerGroupByName(workspace, name));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return this.filterIsolated(this.facade.getLayerGroups(), LayerGroupInfo.class, this::enforceLayerGroupIsolation);
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo workspace) {
        return this.filterIsolated(this.facade.getLayerGroupsByWorkspace(workspace), LayerGroupInfo.class, this::enforceLayerGroupIsolation);
    }

    @Override
    public NamespaceInfo add(NamespaceInfo namespace) {
        return this.facade.add(namespace);
    }

    @Override
    public void remove(NamespaceInfo namespace) {
        this.facade.remove(namespace);
    }

    @Override
    public void save(NamespaceInfo namespace) {
        this.facade.save(namespace);
    }

    @Override
    public NamespaceInfo detach(NamespaceInfo namespace) {
        return this.facade.detach(namespace);
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return this.facade.getDefaultNamespace();
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        this.facade.setDefaultNamespace(defaultNamespace);
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        return this.facade.getNamespace(id);
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        return this.facade.getNamespaceByPrefix(prefix);
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        NamespaceInfo localNamespace = this.getLocalNamespace();
        if (localNamespace != null && Objects.equals(localNamespace.getURI(), uri)) {
            return localNamespace;
        }
        for (NamespaceInfo namespace : this.facade.getNamespacesByURI(uri)) {
            if (namespace.isIsolated()) continue;
            return namespace;
        }
        return null;
    }

    @Override
    public List<NamespaceInfo> getNamespacesByURI(String uri) {
        return this.facade.getNamespacesByURI(uri);
    }

    @Override
    public List<NamespaceInfo> getNamespaces() {
        return this.facade.getNamespaces();
    }

    @Override
    public WorkspaceInfo add(WorkspaceInfo workspace) {
        return this.facade.add(workspace);
    }

    @Override
    public void remove(WorkspaceInfo workspace) {
        this.facade.remove(workspace);
    }

    @Override
    public void save(WorkspaceInfo workspace) {
        this.facade.save(workspace);
    }

    @Override
    public WorkspaceInfo detach(WorkspaceInfo workspace) {
        return this.facade.detach(workspace);
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return this.facade.getDefaultWorkspace();
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        this.facade.setDefaultWorkspace(workspace);
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        return this.facade.getWorkspace(id);
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        return this.facade.getWorkspaceByName(name);
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        return this.facade.getWorkspaces();
    }

    @Override
    public StyleInfo add(StyleInfo style) {
        return this.facade.add(style);
    }

    @Override
    public void remove(StyleInfo style) {
        this.facade.remove(style);
    }

    @Override
    public void save(StyleInfo style) {
        this.facade.save(style);
    }

    @Override
    public StyleInfo detach(StyleInfo style) {
        return this.facade.detach(style);
    }

    @Override
    public StyleInfo getStyle(String id) {
        return this.enforceStyleIsolation(this.facade.getStyle(id));
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        return this.enforceStyleIsolation(this.facade.getStyleByName(name));
    }

    @Override
    public StyleInfo getStyleByName(WorkspaceInfo workspace, String name) {
        return this.enforceStyleIsolation(this.facade.getStyleByName(workspace, name));
    }

    @Override
    public List<StyleInfo> getStyles() {
        return this.filterIsolated(this.facade.getStyles(), StyleInfo.class, this::enforceStyleIsolation);
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo workspace) {
        return this.filterIsolated(this.facade.getStylesByWorkspace(workspace), StyleInfo.class, this::enforceStyleIsolation);
    }

    @Override
    public void dispose() {
        this.facade.dispose();
    }

    @Override
    public void resolve() {
        this.facade.resolve();
    }

    @Override
    public void syncTo(CatalogFacade other) {
        this.facade.syncTo(other);
    }

    @Override
    public <T extends CatalogInfo> int count(Class<T> of, Filter filter) {
        if (this.isOwsRequest()) {
            CloseableIterator<T> found = this.facade.list(of, filter, null, null, new SortBy[0]);
            try (CloseableIterator<T> filtered = this.filterIsolated(of, found);){
                int n = Iterators.size(filtered);
                return n;
            }
        }
        return this.facade.count(of, filter);
    }

    @Override
    public boolean canSort(Class<? extends CatalogInfo> type, String propertyName) {
        return this.facade.canSort(type, propertyName);
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, @Nullable Integer offset, @Nullable Integer count, SortBy ... sortOrder) {
        return this.filterIsolated(of, this.facade.list(of, filter, offset, count, sortOrder));
    }

    @Override
    public CatalogCapabilities getCatalogCapabilities() {
        CatalogCapabilities capabilities = this.facade.getCatalogCapabilities();
        capabilities.setIsolatedWorkspacesSupport(true);
        return capabilities;
    }

    public static <T extends CatalogInfo> T any(Class<T> clazz) {
        return CatalogFacade.any(clazz);
    }

    private WorkspaceInfo getLocalWorkspace() {
        return LocalWorkspace.get();
    }

    private <T extends StoreInfo> T enforceStoreIsolation(T store) {
        if (store == null) {
            return null;
        }
        WorkspaceInfo workspace = store.getWorkspace();
        return (T)(this.canSeeWorkspace(workspace) ? store : null);
    }

    private <T extends ResourceInfo> T enforceResourceIsolation(T resource) {
        if (resource == null) {
            return null;
        }
        StoreInfo store = resource.getStore();
        if (store == null) {
            return resource;
        }
        WorkspaceInfo workspace = store.getWorkspace();
        return (T)(this.canSeeWorkspace(workspace) ? resource : null);
    }

    private <T extends LayerInfo> T enforceLayerIsolation(T layer) {
        if (layer == null) {
            return null;
        }
        ResourceInfo resource = layer.getResource();
        if (resource == null) {
            return layer;
        }
        StoreInfo store = resource.getStore();
        if (store == null) {
            return layer;
        }
        WorkspaceInfo workspace = store.getWorkspace();
        return (T)(this.canSeeWorkspace(workspace) ? layer : null);
    }

    private <T extends StyleInfo> T enforceStyleIsolation(T style) {
        if (style == null) {
            return null;
        }
        WorkspaceInfo workspace = style.getWorkspace();
        return (T)(this.canSeeWorkspace(workspace) ? style : null);
    }

    private <T extends LayerGroupInfo> T enforceLayerGroupIsolation(T layerGroup) {
        if (layerGroup == null) {
            return null;
        }
        WorkspaceInfo workspace = layerGroup.getWorkspace();
        return (T)(this.canSeeWorkspace(workspace) ? layerGroup : null);
    }

    private boolean canSeeWorkspace(WorkspaceInfo workspace) {
        if (workspace == CatalogFacade.NO_WORKSPACE || workspace == CatalogFacade.ANY_WORKSPACE || workspace == null || !workspace.isIsolated() || !this.isOwsRequest()) {
            return true;
        }
        WorkspaceInfo localWorkspace = this.getLocalWorkspace();
        return localWorkspace != null && Objects.equals(localWorkspace.getName(), workspace.getName());
    }

    private boolean isOwsRequest() {
        return Dispatcher.REQUEST.get() != null;
    }

    private <T extends CatalogInfo> List<T> filterIsolated(List<T> objects, Class<T> type, Function<T, T> filter) {
        if (this.isOwsRequest()) {
            List<T> unwrapped = ModificationProxy.unwrap(objects);
            return ModificationProxy.createList(unwrapped.stream().filter(store -> filter.apply(store) != null).collect(Collectors.toList()), type);
        }
        return objects;
    }

    private <T extends CatalogInfo> CloseableIterator<T> filterIsolated(CloseableIterator<T> objects, Function<T, T> filter) {
        if (this.isOwsRequest()) {
            Predicate predicate = t -> filter.apply(t) != null;
            objects = CloseableIteratorAdapter.filter(objects, predicate);
        }
        return objects;
    }

    private NamespaceInfo tryMatchLocalNamespace(NamespaceInfo namespace) {
        NamespaceInfo localNamespace;
        WorkspaceInfo localWorkspace = this.getLocalWorkspace();
        if (localWorkspace != null && (localNamespace = this.facade.getNamespaceByPrefix(localWorkspace.getName())) != null && Objects.equals(localNamespace.getURI(), namespace.getURI())) {
            return localNamespace;
        }
        return null;
    }

    private NamespaceInfo getLocalNamespace() {
        WorkspaceInfo localWorkspace = this.getLocalWorkspace();
        if (localWorkspace != null) {
            return this.facade.getNamespaceByPrefix(localWorkspace.getName());
        }
        return null;
    }

    private <T extends CatalogInfo> CloseableIterator<T> filterIsolated(Class<T> type, CloseableIterator<T> objects) {
        if (StoreInfo.class.isAssignableFrom(type)) {
            return this.filterIsolated(objects, this::enforceStoreIsolation);
        }
        if (ResourceInfo.class.isAssignableFrom(type)) {
            return this.filterIsolated(objects, this::enforceResourceIsolation);
        }
        if (LayerInfo.class.isAssignableFrom(type)) {
            return this.filterIsolated(objects, this::enforceLayerIsolation);
        }
        if (LayerGroupInfo.class.isAssignableFrom(type)) {
            return this.filterIsolated(objects, this::enforceLayerGroupIsolation);
        }
        if (StyleInfo.class.isAssignableFrom(type)) {
            return this.filterIsolated(objects, this::enforceStyleIsolation);
        }
        return objects;
    }
}

