/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogCapabilities;
import org.geoserver.catalog.CatalogFacade;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MapInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.ValidationResult;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WMTSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.catalog.util.CloseableIteratorAdapter;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.util.decorate.AbstractDecorator;

public abstract class AbstractFilteredCatalog
extends AbstractDecorator<Catalog>
implements Catalog {
    public AbstractFilteredCatalog(Catalog catalog) {
        super((Object)catalog);
    }

    @Override
    public String getId() {
        return ((Catalog)this.delegate).getId();
    }

    @Override
    public CoverageInfo getCoverage(String id) {
        return this.checkAccess(((Catalog)this.delegate).getCoverage(id));
    }

    @Override
    public CoverageInfo getCoverageByName(String ns, String name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageByName(ns, name));
    }

    @Override
    public CoverageInfo getCoverageByName(NamespaceInfo ns, String name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageByName(ns, name));
    }

    @Override
    public CoverageInfo getCoverageByName(Name name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageByName(name));
    }

    @Override
    public CoverageInfo getCoverageByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageByName(name));
    }

    @Override
    public List<CoverageInfo> getCoverages() {
        return this.filterResources(((Catalog)this.delegate).getCoverages());
    }

    @Override
    public List<CoverageInfo> getCoveragesByNamespace(NamespaceInfo namespace) {
        return this.filterResources(((Catalog)this.delegate).getCoveragesByNamespace(namespace));
    }

    @Override
    public List<CoverageInfo> getCoveragesByCoverageStore(CoverageStoreInfo store) {
        return this.filterResources(((Catalog)this.delegate).getCoveragesByCoverageStore(store));
    }

    @Override
    public CoverageInfo getCoverageByCoverageStore(CoverageStoreInfo coverageStore, String name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageByCoverageStore(coverageStore, name));
    }

    @Override
    public List<CoverageInfo> getCoveragesByStore(CoverageStoreInfo store) {
        return this.filterResources(((Catalog)this.delegate).getCoveragesByStore(store));
    }

    @Override
    public CoverageStoreInfo getCoverageStore(String id) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageStore(id));
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageStoreByName(name));
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(String workspaceName, String name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageStoreByName(workspaceName, name));
    }

    @Override
    public CoverageStoreInfo getCoverageStoreByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(((Catalog)this.delegate).getCoverageStoreByName(workspace, name));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(String workspaceName) {
        return this.filterStores(((Catalog)this.delegate).getCoverageStoresByWorkspace(workspaceName));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStoresByWorkspace(WorkspaceInfo workspace) {
        return this.filterStores(((Catalog)this.delegate).getCoverageStoresByWorkspace(workspace));
    }

    @Override
    public List<CoverageStoreInfo> getCoverageStores() {
        return this.filterStores(((Catalog)this.delegate).getCoverageStores());
    }

    @Override
    public WMSStoreInfo getWMSStore(String id) {
        return this.checkAccess(((Catalog)this.delegate).getWMSStore(id));
    }

    @Override
    public WMSStoreInfo getWMSStoreByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getWMSStoreByName(name));
    }

    @Override
    public WMTSStoreInfo getWMTSStore(String id) {
        return this.checkAccess(((Catalog)this.delegate).getWMTSStore(id));
    }

    @Override
    public WMTSStoreInfo getWMTSStoreByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getWMTSStoreByName(name));
    }

    @Override
    public DataStoreInfo getDataStore(String id) {
        return this.checkAccess(((Catalog)this.delegate).getDataStore(id));
    }

    @Override
    public DataStoreInfo getDataStoreByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getDataStoreByName(name));
    }

    @Override
    public DataStoreInfo getDataStoreByName(String workspaceName, String name) {
        return this.checkAccess(((Catalog)this.delegate).getDataStoreByName(workspaceName, name));
    }

    @Override
    public DataStoreInfo getDataStoreByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(((Catalog)this.delegate).getDataStoreByName(workspace, name));
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(String workspaceName) {
        return this.filterStores(((Catalog)this.delegate).getDataStoresByWorkspace(workspaceName));
    }

    @Override
    public List<DataStoreInfo> getDataStoresByWorkspace(WorkspaceInfo workspace) {
        return this.filterStores(((Catalog)this.delegate).getDataStoresByWorkspace(workspace));
    }

    @Override
    public List<DataStoreInfo> getDataStores() {
        return this.filterStores(((Catalog)this.delegate).getDataStores());
    }

    @Override
    public NamespaceInfo getDefaultNamespace() {
        return ((Catalog)this.delegate).getDefaultNamespace();
    }

    @Override
    public WorkspaceInfo getDefaultWorkspace() {
        return ((Catalog)this.delegate).getDefaultWorkspace();
    }

    @Override
    public FeatureTypeInfo getFeatureType(String id) {
        return this.checkAccess(((Catalog)this.delegate).getFeatureType(id));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String ns, String name) {
        return this.checkAccess(((Catalog)this.delegate).getFeatureTypeByName(ns, name));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(NamespaceInfo ns, String name) {
        return this.checkAccess(((Catalog)this.delegate).getFeatureTypeByName(ns, name));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(Name name) {
        return this.checkAccess(((Catalog)this.delegate).getFeatureTypeByName(name));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getFeatureTypeByName(name));
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypes() {
        return this.filterResources(((Catalog)this.delegate).getFeatureTypes());
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByNamespace(NamespaceInfo namespace) {
        return this.filterResources(((Catalog)this.delegate).getFeatureTypesByNamespace(namespace));
    }

    @Override
    public FeatureTypeInfo getFeatureTypeByDataStore(DataStoreInfo dataStore, String name) {
        return this.checkAccess(((Catalog)this.delegate).getFeatureTypeByDataStore(dataStore, name));
    }

    @Override
    public List<FeatureTypeInfo> getFeatureTypesByDataStore(DataStoreInfo store) {
        return this.filterResources(((Catalog)this.delegate).getFeatureTypesByDataStore(store));
    }

    @Override
    public LayerInfo getLayer(String id) {
        return this.checkAccess(((Catalog)this.delegate).getLayer(id));
    }

    @Override
    public LayerInfo getLayerByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getLayerByName(name));
    }

    @Override
    public LayerInfo getLayerByName(Name name) {
        return this.checkAccess(((Catalog)this.delegate).getLayerByName(name));
    }

    @Override
    public LayerGroupInfo getLayerGroup(String id) {
        return this.checkAccess(((Catalog)this.delegate).getLayerGroup(id));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getLayerGroupByName(name));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(String workspaceName, String name) {
        return this.checkAccess(((Catalog)this.delegate).getLayerGroupByName(workspaceName, name));
    }

    @Override
    public LayerGroupInfo getLayerGroupByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(((Catalog)this.delegate).getLayerGroupByName(workspace, name));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroups() {
        return this.filterGroups(((Catalog)this.delegate).getLayerGroups());
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(String workspaceName) {
        return this.filterGroups(((Catalog)this.delegate).getLayerGroupsByWorkspace(workspaceName));
    }

    @Override
    public List<LayerGroupInfo> getLayerGroupsByWorkspace(WorkspaceInfo workspace) {
        return this.filterGroups(((Catalog)this.delegate).getLayerGroupsByWorkspace(workspace));
    }

    @Override
    public List<LayerInfo> getLayers() {
        return this.filterLayers(((Catalog)this.delegate).getLayers());
    }

    @Override
    public List<LayerInfo> getLayers(ResourceInfo resource) {
        return this.filterLayers(((Catalog)this.delegate).getLayers(resource));
    }

    @Override
    public List<LayerInfo> getLayers(StyleInfo style) {
        return this.filterLayers(((Catalog)this.delegate).getLayers(style));
    }

    @Override
    public NamespaceInfo getNamespace(String id) {
        return this.checkAccess(((Catalog)this.delegate).getNamespace(id));
    }

    @Override
    public NamespaceInfo getNamespaceByPrefix(String prefix) {
        return this.checkAccess(((Catalog)this.delegate).getNamespaceByPrefix(prefix));
    }

    @Override
    public NamespaceInfo getNamespaceByURI(String uri) {
        return this.checkAccess(((Catalog)this.delegate).getNamespaceByURI(uri));
    }

    @Override
    public List<NamespaceInfo> getNamespaces() {
        return this.filterNamespaces(((Catalog)this.delegate).getNamespaces());
    }

    @Override
    public <T extends ResourceInfo> T getResource(String id, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getResource(id, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(Name name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getResourceByName(name, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getResourceByName(name, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(NamespaceInfo ns, String name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getResourceByName(ns, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByName(String ns, String name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getResourceByName(ns, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResources(Class<T> clazz) {
        return this.filterResources(((Catalog)this.delegate).getResources(clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(NamespaceInfo namespace, Class<T> clazz) {
        return this.filterResources(((Catalog)this.delegate).getResourcesByNamespace(namespace, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByNamespace(String namespace, Class<T> clazz) {
        return this.filterResources(((Catalog)this.delegate).getResourcesByNamespace(namespace, clazz));
    }

    @Override
    public <T extends ResourceInfo> T getResourceByStore(StoreInfo store, String name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getResourceByStore(store, name, clazz));
    }

    @Override
    public <T extends ResourceInfo> List<T> getResourcesByStore(StoreInfo store, Class<T> clazz) {
        return this.filterResources(((Catalog)this.delegate).getResourcesByStore(store, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStore(String id, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getStore(id, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getStoreByName(name, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(String workspaceName, String name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getStoreByName(workspaceName, name, clazz));
    }

    @Override
    public <T extends StoreInfo> T getStoreByName(WorkspaceInfo workspace, String name, Class<T> clazz) {
        return this.checkAccess(((Catalog)this.delegate).getStoreByName(workspace, name, clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStores(Class<T> clazz) {
        return this.filterStores(((Catalog)this.delegate).getStores(clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(String workspaceName, Class<T> clazz) {
        return this.filterStores(((Catalog)this.delegate).getStoresByWorkspace(workspaceName, clazz));
    }

    @Override
    public <T extends StoreInfo> List<T> getStoresByWorkspace(WorkspaceInfo workspace, Class<T> clazz) {
        return this.filterStores(((Catalog)this.delegate).getStoresByWorkspace(workspace, clazz));
    }

    @Override
    public WorkspaceInfo getWorkspace(String id) {
        return this.checkAccess(((Catalog)this.delegate).getWorkspace(id));
    }

    @Override
    public WorkspaceInfo getWorkspaceByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getWorkspaceByName(name));
    }

    @Override
    public List<WorkspaceInfo> getWorkspaces() {
        return this.filterWorkspaces(((Catalog)this.delegate).getWorkspaces());
    }

    protected <T extends CatalogInfo> T checkAccess(T info) {
        if (info instanceof WorkspaceInfo) {
            return (T)this.checkAccess((WorkspaceInfo)info);
        }
        if (info instanceof NamespaceInfo) {
            return (T)this.checkAccess((NamespaceInfo)info);
        }
        if (info instanceof StoreInfo) {
            return (T)this.checkAccess((StoreInfo)info);
        }
        if (info instanceof ResourceInfo) {
            return (T)this.checkAccess((ResourceInfo)info);
        }
        if (info instanceof LayerInfo) {
            return (T)this.checkAccess((LayerInfo)info);
        }
        if (info instanceof LayerGroupInfo) {
            return (T)this.checkAccess((LayerGroupInfo)info);
        }
        return info;
    }

    protected abstract <T extends ResourceInfo> T checkAccess(T var1);

    protected abstract StyleInfo checkAccess(StyleInfo var1);

    protected abstract <T extends StoreInfo> T checkAccess(T var1);

    protected abstract LayerInfo checkAccess(LayerInfo var1);

    protected abstract LayerGroupInfo checkAccess(LayerGroupInfo var1);

    protected abstract <T extends NamespaceInfo> T checkAccess(T var1);

    protected abstract <T extends WorkspaceInfo> T checkAccess(T var1);

    protected abstract <T extends ResourceInfo> List<T> filterResources(List<T> var1);

    protected abstract <T extends StoreInfo> List<T> filterStores(List<T> var1);

    protected abstract List<LayerGroupInfo> filterGroups(List<LayerGroupInfo> var1);

    protected abstract List<LayerInfo> filterLayers(List<LayerInfo> var1);

    protected abstract List<StyleInfo> filterStyles(List<StyleInfo> var1);

    protected abstract <T extends NamespaceInfo> List<T> filterNamespaces(List<T> var1);

    protected abstract <T extends WorkspaceInfo> List<T> filterWorkspaces(List<T> var1);

    @Override
    public MapInfo getMap(String id) {
        return ((Catalog)this.delegate).getMap(id);
    }

    @Override
    public MapInfo getMapByName(String name) {
        return ((Catalog)this.delegate).getMapByName(name);
    }

    @Override
    public List<MapInfo> getMaps() {
        return ((Catalog)this.delegate).getMaps();
    }

    @Override
    public void add(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).add(layerGroup);
    }

    @Override
    public ValidationResult validate(LayerGroupInfo layerGroup, boolean isNew) {
        return ((Catalog)this.delegate).validate(layerGroup, isNew);
    }

    @Override
    public LayerGroupInfo detach(LayerGroupInfo layerGroup) {
        return ((Catalog)this.delegate).detach(layerGroup);
    }

    @Override
    public void add(LayerInfo layer) {
        ((Catalog)this.delegate).add(layer);
    }

    @Override
    public LayerInfo detach(LayerInfo layer) {
        return ((Catalog)this.delegate).detach(layer);
    }

    @Override
    public ValidationResult validate(LayerInfo layer, boolean isNew) {
        return ((Catalog)this.delegate).validate(layer, isNew);
    }

    @Override
    public void add(MapInfo map) {
        ((Catalog)this.delegate).add(map);
    }

    @Override
    public MapInfo detach(MapInfo map) {
        return ((Catalog)this.delegate).detach(map);
    }

    @Override
    public void add(NamespaceInfo namespace) {
        ((Catalog)this.delegate).add(namespace);
    }

    @Override
    public ValidationResult validate(NamespaceInfo namespace, boolean isNew) {
        return ((Catalog)this.delegate).validate(namespace, isNew);
    }

    @Override
    public NamespaceInfo detach(NamespaceInfo namespace) {
        return ((Catalog)this.delegate).detach(namespace);
    }

    @Override
    public void add(ResourceInfo resource) {
        ((Catalog)this.delegate).add(resource);
    }

    @Override
    public ValidationResult validate(ResourceInfo resource, boolean isNew) {
        return ((Catalog)this.delegate).validate(resource, isNew);
    }

    @Override
    public <T extends ResourceInfo> T detach(T resource) {
        return ((Catalog)this.delegate).detach(resource);
    }

    @Override
    public void add(StoreInfo store) {
        ((Catalog)this.delegate).add(store);
    }

    @Override
    public ValidationResult validate(StoreInfo store, boolean isNew) {
        return ((Catalog)this.delegate).validate(store, isNew);
    }

    @Override
    public <T extends StoreInfo> T detach(T store) {
        return ((Catalog)this.delegate).detach(store);
    }

    @Override
    public void add(StyleInfo style) {
        ((Catalog)this.delegate).add(style);
    }

    @Override
    public ValidationResult validate(StyleInfo style, boolean isNew) {
        return ((Catalog)this.delegate).validate(style, isNew);
    }

    @Override
    public StyleInfo detach(StyleInfo style) {
        return ((Catalog)this.delegate).detach(style);
    }

    @Override
    public void add(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).add(workspace);
    }

    @Override
    public ValidationResult validate(WorkspaceInfo workspace, boolean isNew) {
        return ((Catalog)this.delegate).validate(workspace, isNew);
    }

    @Override
    public WorkspaceInfo detach(WorkspaceInfo workspace) {
        return ((Catalog)this.delegate).detach(workspace);
    }

    @Override
    public void addListener(CatalogListener listener) {
        ((Catalog)this.delegate).addListener(listener);
    }

    @Override
    public void dispose() {
        ((Catalog)this.delegate).dispose();
    }

    @Override
    public CatalogFacade getFacade() {
        return ((Catalog)this.delegate).getFacade();
    }

    @Override
    public CatalogFactory getFactory() {
        return ((Catalog)this.delegate).getFactory();
    }

    @Override
    public Collection<CatalogListener> getListeners() {
        return ((Catalog)this.delegate).getListeners();
    }

    @Override
    public void fireAdded(CatalogInfo object) {
        ((Catalog)this.delegate).fireAdded(object);
    }

    @Override
    public void fireModified(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        ((Catalog)this.delegate).fireModified(object, propertyNames, oldValues, newValues);
    }

    @Override
    public void firePostModified(CatalogInfo object, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
        ((Catalog)this.delegate).firePostModified(object, propertyNames, oldValues, newValues);
    }

    @Override
    public void fireRemoved(CatalogInfo object) {
        ((Catalog)this.delegate).fireRemoved(object);
    }

    @Override
    public ResourcePool getResourcePool() {
        return ((Catalog)this.delegate).getResourcePool();
    }

    @Override
    public StyleInfo getStyle(String id) {
        return ((Catalog)this.delegate).getStyle(id);
    }

    @Override
    public StyleInfo getStyleByName(String name) {
        return this.checkAccess(((Catalog)this.delegate).getStyleByName(name));
    }

    @Override
    public StyleInfo getStyleByName(String workspaceName, String name) {
        return this.checkAccess(((Catalog)this.delegate).getStyleByName(workspaceName, name));
    }

    @Override
    public StyleInfo getStyleByName(WorkspaceInfo workspace, String name) {
        return this.checkAccess(((Catalog)this.delegate).getStyleByName(workspace, name));
    }

    @Override
    public List<StyleInfo> getStyles() {
        return this.filterStyles(((Catalog)this.delegate).getStyles());
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(String workspaceName) {
        return this.filterStyles(((Catalog)this.delegate).getStylesByWorkspace(workspaceName));
    }

    @Override
    public List<StyleInfo> getStylesByWorkspace(WorkspaceInfo workspace) {
        return this.filterStyles(((Catalog)this.delegate).getStylesByWorkspace(workspace));
    }

    @Override
    public void remove(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).remove(layerGroup);
    }

    @Override
    public void remove(LayerInfo layer) {
        ((Catalog)this.delegate).remove(layer);
    }

    @Override
    public void remove(MapInfo map) {
        ((Catalog)this.delegate).remove(map);
    }

    @Override
    public void remove(NamespaceInfo namespace) {
        ((Catalog)this.delegate).remove(namespace);
    }

    @Override
    public void remove(ResourceInfo resource) {
        ((Catalog)this.delegate).remove(resource);
    }

    @Override
    public void remove(StoreInfo store) {
        ((Catalog)this.delegate).remove(store);
    }

    @Override
    public void remove(StyleInfo style) {
        ((Catalog)this.delegate).remove(style);
    }

    @Override
    public void remove(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).remove(workspace);
    }

    @Override
    public void removeListener(CatalogListener listener) {
        ((Catalog)this.delegate).removeListener(listener);
    }

    @Override
    public void save(LayerGroupInfo layerGroup) {
        ((Catalog)this.delegate).save(layerGroup);
    }

    @Override
    public void save(LayerInfo layer) {
        ((Catalog)this.delegate).save(layer);
    }

    @Override
    public void save(MapInfo map) {
        ((Catalog)this.delegate).save(map);
    }

    @Override
    public void save(NamespaceInfo namespace) {
        ((Catalog)this.delegate).save(namespace);
    }

    @Override
    public void save(ResourceInfo resource) {
        ((Catalog)this.delegate).save(resource);
    }

    @Override
    public void save(StoreInfo store) {
        ((Catalog)this.delegate).save(store);
    }

    @Override
    public void save(StyleInfo style) {
        ((Catalog)this.delegate).save(style);
    }

    @Override
    public void save(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).save(workspace);
    }

    @Override
    public void setDefaultNamespace(NamespaceInfo defaultNamespace) {
        ((Catalog)this.delegate).setDefaultNamespace(defaultNamespace);
    }

    @Override
    public void setDefaultWorkspace(WorkspaceInfo workspace) {
        ((Catalog)this.delegate).setDefaultWorkspace(workspace);
    }

    @Override
    public void setResourcePool(ResourcePool resourcePool) {
        ((Catalog)this.delegate).setResourcePool(resourcePool);
    }

    @Override
    public GeoServerResourceLoader getResourceLoader() {
        return ((Catalog)this.delegate).getResourceLoader();
    }

    @Override
    public void setResourceLoader(GeoServerResourceLoader resourceLoader) {
        ((Catalog)this.delegate).setResourceLoader(resourceLoader);
    }

    @Override
    public void accept(CatalogVisitor visitor) {
        ((Catalog)this.delegate).accept(visitor);
    }

    @Override
    public DataStoreInfo getDefaultDataStore(WorkspaceInfo workspace) {
        return this.checkAccess(((Catalog)this.delegate).getDefaultDataStore(workspace));
    }

    @Override
    public void setDefaultDataStore(WorkspaceInfo workspace, DataStoreInfo defaultStore) {
        ((Catalog)this.delegate).setDefaultDataStore(workspace, defaultStore);
    }

    @Override
    public <T extends CatalogInfo> int count(Class<T> of, Filter filter) {
        Filter securityFilter = this.securityFilter(of, filter);
        int count = ((Catalog)this.delegate).count(of, securityFilter);
        return count;
    }

    @Override
    public <T extends CatalogInfo> T get(Class<T> type, Filter filter) throws IllegalArgumentException {
        Filter securityFilter = this.securityFilter(type, filter);
        T result = ((Catalog)this.delegate).get(type, securityFilter);
        return result;
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter) {
        return this.list(of, filter, null, null, null);
    }

    @Override
    public <T extends CatalogInfo> CloseableIterator<T> list(Class<T> of, Filter filter, Integer offset, Integer count, SortBy sortBy) {
        Filter securityFilter = this.securityFilter(of, filter);
        CloseableIterator<T> filtered = ((Catalog)this.delegate).list(of, securityFilter, offset, count, sortBy);
        Function<T, T> securityWrapper = this.securityWrapper(of);
        CloseableIterator<T> filteredWrapped = CloseableIteratorAdapter.transform(filtered, securityWrapper);
        return filteredWrapped;
    }

    private <T extends CatalogInfo> Function<T, T> securityWrapper(Class<T> forClass) {
        return input -> {
            CatalogInfo checked = this.checkAccess(input);
            return checked;
        };
    }

    protected abstract <T extends CatalogInfo> Filter securityFilter(Class<T> var1, Filter var2);

    @Override
    public void removeListeners(Class<? extends CatalogListener> listenerClass) {
        ((Catalog)this.delegate).removeListeners(listenerClass);
    }

    @Override
    public CatalogCapabilities getCatalogCapabilities() {
        return ((Catalog)this.delegate).getCatalogCapabilities();
    }
}

