/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ServiceResourceVoter;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServiceResourceProvider
implements ApplicationContextAware {
    private ApplicationContext context;
    private GeoServer geoServer;

    public ServiceResourceProvider(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public List<String> getServicesForResource(ResourceInfo resource) {
        List<String> services = this.servicesList();
        List voters = GeoServerExtensions.extensions(ServiceResourceVoter.class, (ApplicationContext)this.context);
        return services.stream().filter(s -> !this.isServiceHidden(resource, (String)s, voters)).collect(Collectors.toCollection(ArrayList::new));
    }

    public List<String> getServicesForLayerName(String layerName) {
        ResourceInfo resource = this.geoServer.getCatalog().getLayerByName(layerName).getResource();
        return this.getServicesForResource(resource);
    }

    private boolean isServiceHidden(ResourceInfo resource, String serviceType, List<ServiceResourceVoter> voters) {
        return voters.stream().anyMatch(v -> v.hideService(serviceType, resource));
    }

    private List<String> servicesList() {
        return this.geoServer.getServices().stream().map(si -> si.getType()).collect(Collectors.toList());
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

