/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.util.List;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.config.GeoServerReinitializer;
import org.geoserver.util.EntityResolverProvider;

public class ResourcePoolInitializer
implements GeoServerReinitializer {
    GeoServer gs;
    EntityResolverProvider resolverProvider;

    public ResourcePoolInitializer(EntityResolverProvider resolverProvider) {
        this.resolverProvider = resolverProvider;
    }

    @Override
    public void initialize(GeoServer geoServer) throws Exception {
        this.gs = geoServer;
        GeoServerInfo global = geoServer.getGlobal();
        int cacheSize = global.getFeatureTypeCacheSize();
        if (cacheSize > 0) {
            this.gs.getCatalog().getResourcePool().setFeatureTypeCacheSize(cacheSize);
        }
        geoServer.addListener(new ConfigurationListenerAdapter(){

            @Override
            public void handleGlobalChange(GeoServerInfo global, List<String> propertyNames, List<Object> oldValues, List<Object> newValues) {
                int i = propertyNames.indexOf("featureTypeCacheSize");
                if (i > -1) {
                    Number featureTypeCacheSize = (Number)newValues.get(i);
                    ResourcePoolInitializer.this.gs.getCatalog().getResourcePool().setFeatureTypeCacheSize(featureTypeCacheSize.intValue());
                }
                ResourcePoolInitializer.this.gs.getCatalog().getResourcePool().setCoverageExecutor(global.getCoverageAccess().getThreadPoolExecutor());
            }
        });
        this.gs.getCatalog().getResourcePool().setEntityResolverProvider(this.resolverProvider);
    }
}

