/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geotools.util.logging.Logging;

public class GeoServerConfigurationLock {
    static final String TRYLOCK_TIMEOUT_SYSTEM_PROPERTY = "CONFIGURATION_TRYLOCK_TIMEOUT";
    public static long DEFAULT_TRY_LOCK_TIMEOUT_MS = 30000L;
    private static final Level LEVEL = Level.FINE;
    private static final Logger LOGGER = Logging.getLogger(GeoServerConfigurationLock.class);
    private static final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private static final ThreadLocal<LockType> currentLock = new ThreadLocal();
    private boolean enabled;

    public GeoServerConfigurationLock() {
        String pvalue = System.getProperty("GeoServerConfigurationLock.enabled");
        this.enabled = pvalue != null ? Boolean.parseBoolean(pvalue) : true;
        LOGGER.config("GeoServer configuration lock is " + (this.enabled ? "enabled" : "disabled"));
    }

    private long getLockTimeoutMillis() {
        String configValue = GeoServerExtensions.getProperty((String)TRYLOCK_TIMEOUT_SYSTEM_PROPERTY);
        return configValue == null || configValue.isEmpty() ? DEFAULT_TRY_LOCK_TIMEOUT_MS : Long.valueOf(configValue);
    }

    public boolean isWriteLocked() {
        return readWriteLock.isWriteLocked();
    }

    public void lock(LockType type) {
        if (!this.enabled) {
            return;
        }
        if (LockType.READ == type && readWriteLock.isWriteLockedByCurrentThread()) {
            return;
        }
        Lock lock = this.getLock(type);
        lock.lock();
        currentLock.set(type);
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " got the lock in mode " + type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryLock(LockType type) {
        if (!this.enabled) {
            return true;
        }
        if (LockType.READ == type && readWriteLock.isWriteLockedByCurrentThread()) {
            return true;
        }
        Lock lock = this.getLock(type);
        boolean res = false;
        try {
            res = lock.tryLock(this.getLockTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARNING, "Thread " + Thread.currentThread().getId() + " thrown an InterruptedException on GeoServerConfigurationLock TryLock.", e);
            res = false;
        }
        finally {
            if (res) {
                currentLock.set(type);
            }
        }
        if (LOGGER.isLoggable(LEVEL)) {
            if (res) {
                LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " got the lock in mode " + type);
            } else {
                LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " could not get the lock in mode " + type);
            }
        }
        return res;
    }

    public void tryUpgradeLock() {
        LockType lock = currentLock.get();
        if (lock == null) {
            throw new IllegalStateException("No lock currently held");
        }
        if (lock == LockType.WRITE) {
            throw new IllegalStateException("Already owning a write lock");
        }
        this.unlock();
        if (!this.tryLock(LockType.WRITE)) {
            currentLock.set(null);
            throw new RuntimeException("Failed to upgrade lock from read to write state, please re-try the configuration operation");
        }
        currentLock.set(LockType.WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        boolean canUnset;
        if (!this.enabled) {
            return;
        }
        LockType type = this.getCurrentLock();
        if (type == null) {
            return;
        }
        try {
            Lock lock = this.getLock(type);
            if (LOGGER.isLoggable(LEVEL)) {
                LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " releasing the lock in mode " + type);
            }
            lock.unlock();
            int currThreadReentrantReadLockCount = readWriteLock.getReadHoldCount();
            int currThreadReentrantWriteLockCount = readWriteLock.getWriteHoldCount();
            boolean bl = canUnset = LockType.READ == type && currThreadReentrantReadLockCount == 0 || LockType.WRITE == type && currThreadReentrantWriteLockCount == 0;
        }
        catch (Throwable throwable) {
            boolean canUnset2;
            int currThreadReentrantReadLockCount = readWriteLock.getReadHoldCount();
            int currThreadReentrantWriteLockCount = readWriteLock.getWriteHoldCount();
            boolean bl = canUnset2 = LockType.READ == type && currThreadReentrantReadLockCount == 0 || LockType.WRITE == type && currThreadReentrantWriteLockCount == 0;
            if (canUnset2) {
                currentLock.set(null);
            }
            throw throwable;
        }
        if (canUnset) {
            currentLock.set(null);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    private Lock getLock(LockType type) {
        Lock lock = type == LockType.WRITE ? readWriteLock.writeLock() : readWriteLock.readLock();
        if (LOGGER.isLoggable(LEVEL)) {
            LOGGER.log(LEVEL, "Thread " + Thread.currentThread().getId() + " locking in mode " + type);
        }
        return lock;
    }

    public LockType getCurrentLock() {
        return currentLock.get();
    }

    public static enum LockType {
        READ,
        WRITE;

    }
}

