/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wcs.bindings;

import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.GeneralPosition;
import org.geotools.gml3.GML;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.wcs.WCS;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LonLatEnvelopeBaseTypeBinding
extends AbstractComplexBinding {
    @Override
    public QName getTarget() {
        return WCS.LonLatEnvelopeBaseType;
    }

    public Class<GeneralBounds> getType() {
        return GeneralBounds.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        List<Node> positions = node.getChildren("pos");
        if (!positions.isEmpty() && positions.size() == 2) {
            Node n1 = positions.get(0);
            Node n2 = positions.get(1);
            GeneralPosition p1 = (GeneralPosition)n1.getValue();
            GeneralPosition p2 = (GeneralPosition)n2.getValue();
            GeneralBounds envelope = new GeneralBounds(p1, p2);
            if (p1.getDimension() == 2 && p2.getDimension() == 2) {
                envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                return envelope;
            }
            if (p1.getDimension() > 2 && p2.getDimension() > 2) {
                envelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84_3D);
                return envelope;
            }
        }
        if (!positions.isEmpty()) {
            throw new RuntimeException("Envelope can have only two coordinates");
        }
        throw new RuntimeException("Could not find coordinates for envelope");
    }

    @Override
    public int getExecutionMode() {
        return 2;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        GeneralBounds envelope = (GeneralBounds)object;
        if (envelope == null) {
            value.appendChild(document.createElementNS("http://www.opengis.net/gml", GML.Null.getLocalPart()));
        }
        return null;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        GeneralBounds envelope = (GeneralBounds)object;
        if (envelope == null) {
            return null;
        }
        if (name.getLocalPart().equals("srsName")) {
            return "WGS84(DD)";
        }
        if (name.getLocalPart().equals("pos")) {
            CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
            GeographicCRS spatialCRS = null;
            if (crs instanceof CompoundCRS) {
                List CRSs = ((DefaultCompoundCRS)crs).getCoordinateReferenceSystems();
                for (Object item : CRSs) {
                    if (!(item instanceof GeographicCRS)) continue;
                    spatialCRS = (GeographicCRS)item;
                }
            } else {
                spatialCRS = (GeographicCRS)envelope.getCoordinateReferenceSystem();
            }
            if (spatialCRS != null) {
                LinkedList<GeneralPosition> envelopePositions = new LinkedList<GeneralPosition>();
                GeneralPosition lowerCorner = new GeneralPosition(envelope.getCoordinateReferenceSystem());
                GeneralPosition upperCorner = new GeneralPosition(envelope.getCoordinateReferenceSystem());
                for (int i = 0; i < spatialCRS.getCoordinateSystem().getDimension(); ++i) {
                    lowerCorner.setOrdinate(i, envelope.getLowerCorner().getOrdinate(i));
                    upperCorner.setOrdinate(i, envelope.getUpperCorner().getOrdinate(i));
                }
                envelopePositions.add(lowerCorner);
                envelopePositions.add(upperCorner);
                return envelopePositions;
            }
        }
        return null;
    }
}

