/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import java.io.IOException;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.FilterToSqlHelper;
import org.geotools.data.postgis.PostGISPSDialect;
import org.geotools.filter.FilterCapabilities;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.SQLDialect;
import org.geotools.util.Version;
import org.locationtech.jts.geom.Geometry;

public class PostgisPSFilterToSql
extends PreparedFilterToSQL {
    FilterToSqlHelper helper;
    boolean functionEncodingEnabled;

    public PostgisPSFilterToSql(PostGISPSDialect dialect) {
        super((PreparedStatementSQLDialect)dialect);
        this.helper = new FilterToSqlHelper((FilterToSQL)this);
    }

    public PostgisPSFilterToSql(PostGISPSDialect dialect, Version pgVersion) {
        super((PreparedStatementSQLDialect)dialect);
        this.helper = new FilterToSqlHelper((FilterToSQL)this, pgVersion);
    }

    public boolean isLooseBBOXEnabled() {
        return this.helper.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.helper.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        return this.helper.encodeBBOXFilterAsEnvelope;
    }

    public void setEncodeBBOXFilterAsEnvelope(boolean encodeBBOXFilterAsEnvelope) {
        this.helper.encodeBBOXFilterAsEnvelope = encodeBBOXFilterAsEnvelope;
    }

    protected FilterCapabilities createFilterCapabilities() {
        return FilterToSqlHelper.createFilterCapabilities(this.functionEncodingEnabled);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Expression e1, Expression e2, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, e1, e2, extraData);
    }

    GeometryDescriptor getCurrentGeometry() {
        return this.currentGeometry;
    }

    public void setFunctionEncodingEnabled(boolean functionEncodingEnabled) {
        this.functionEncodingEnabled = functionEncodingEnabled;
    }

    protected String getFunctionName(Function function) {
        return this.helper.getFunctionName(function);
    }

    public double getDistanceInNativeUnits(DistanceBufferOperator operator) {
        return super.getDistanceInNativeUnits(operator);
    }

    public Object visit(Function function, Object extraData) throws RuntimeException {
        this.helper.out = this.out;
        try {
            this.encodingFunction = true;
            boolean encoded = this.helper.visitFunction(function, extraData);
            this.encodingFunction = false;
            if (encoded) {
                return extraData;
            }
            return super.visit(function, extraData);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void visitBinaryComparisonOperator(BinaryComparisonOperator filter, Object extraData) throws RuntimeException {
        Expression left = filter.getExpression1();
        Expression right = filter.getExpression2();
        Class rightContext = super.getExpressionType(left);
        Class leftContext = super.getExpressionType(right);
        String type = (String)extraData;
        if ((this.helper.isArray(rightContext) || this.helper.isArray(leftContext)) && (left instanceof PropertyName || right instanceof PropertyName)) {
            this.helper.out = this.out;
            this.helper.visitArrayComparison(filter, left, right, rightContext, leftContext, type);
        } else {
            super.visitBinaryComparisonOperator(filter, extraData);
        }
    }

    public Object visit(PropertyIsBetween filter, Object extraData) throws RuntimeException {
        LOGGER.finer("exporting PropertyIsBetween");
        Expression expr = filter.getExpression();
        Class context = super.getExpressionType(expr);
        if (this.helper.isArray(context)) {
            this.helper.out = this.out;
            this.helper.visitArrayBetween(filter, context.getComponentType(), extraData);
            return extraData;
        }
        return super.visit(filter, extraData);
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        this.helper.out = this.out;
        if (this.helper.isSupportedEqualFunction(filter)) {
            return this.helper.visitSupportedEqualFunction(filter, (SQLDialect)this.dialect, (a, b) -> {
                try {
                    ((PostGISPSDialect)this.dialect).encodeGeometryValue((Geometry)a, this.helper.getFeatureTypeGeometryDimension(), this.helper.getFeatureTypeGeometrySRID(), (StringBuffer)b);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, extraData);
        }
        return super.visit(filter, extraData);
    }
}

