/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.png;

import it.geosolutions.imageio.plugins.png.AbstractScanlineProvider;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;

public final class RasterByteRepackSingleBandProvider
extends AbstractScanlineProvider {
    final byte[] bytes;

    public RasterByteRepackSingleBandProvider(Raster raster, int bitDepth, int scanlineLength) {
        super(raster, bitDepth, scanlineLength, 8 / bitDepth);
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
    }

    public RasterByteRepackSingleBandProvider(Raster raster, int bitDepth, int scanlineLength, IndexColorModel palette) {
        super(raster, bitDepth, scanlineLength, 8 / bitDepth, palette);
        this.bytes = ((DataBufferByte)raster.getDataBuffer()).getData();
    }

    @Override
    public void next(byte[] row, int offset, int length) {
        if (this.currentRow == this.height) {
            throw new IllegalStateException("All scanlines have been read already");
        }
        int pxIdx = this.cursor.next();
        int pxLimit = pxIdx + this.width;
        int i = offset;
        int max = offset + length;
        if (this.bitDepth == 4) {
            while (i < max) {
                byte low = this.bytes[pxIdx++];
                byte high = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                row[i++] = (byte)(low << 4 | high);
            }
        } else if (this.bitDepth == 2) {
            while (i < max) {
                byte b1 = this.bytes[pxIdx++];
                byte b2 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b3 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b4 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                row[i++] = (byte)(b4 | b3 << 2 | b2 << 4 | b1 << 6);
            }
        } else {
            while (i < max) {
                byte b1 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b2 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b3 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b4 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b5 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b6 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b7 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                byte b8 = pxIdx < pxLimit ? this.bytes[pxIdx++] : (byte)0;
                row[i++] = (byte)(b8 | b7 << 1 | b6 << 2 | b5 << 3 | b4 << 4 | b3 << 5 | b2 << 6 | b1 << 7);
            }
        }
        ++this.currentRow;
    }
}

