/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.marlin.stats;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import sun.java2d.marlin.stats.ArraySortData;

public final class ArraySortDataCollection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ArrayList<ArraySortData> data = new ArrayList(1000);
    private transient String filePath = null;

    public synchronized void addData(int[] x, int fromIndex, int toIndex, int sortedIndex) {
        this.data.add(new ArraySortData(Arrays.copyOf(x, toIndex), fromIndex, toIndex, sortedIndex));
    }

    public synchronized ArrayList<ArraySortData> getData() {
        return this.data;
    }

    public synchronized void clear() {
        this.data.clear();
    }

    public String toString() {
        return "ArraySortDataCollection[" + (this.data != null ? this.data.size() : 0) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArraySortDataCollection load(String absFilePath) {
        ObjectInputStream ois = null;
        try {
            File inputFile = new File(absFilePath);
            ois = new ObjectInputStream(new FileInputStream(inputFile));
            ArraySortDataCollection dc = (ArraySortDataCollection)ois.readObject();
            dc.filePath = inputFile.getAbsolutePath();
            System.out.println("Loaded: " + dc);
            ArraySortDataCollection arraySortDataCollection = dc;
            return arraySortDataCollection;
        }
        catch (Exception e) {
            System.out.println("error while loading data");
            e.printStackTrace(System.out);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(String absFilePath, ArraySortDataCollection dc) {
        File outputFile = new File(absFilePath);
        dc.filePath = outputFile.getAbsolutePath();
        ObjectOutputStream oos = null;
        try {
            System.out.println("Writing " + dc + " to: " + dc.filePath);
            oos = new ObjectOutputStream(new FileOutputStream(outputFile));
            oos.writeObject(dc);
        }
        catch (IOException ioe) {
            System.out.println("error while writing data");
            ioe.printStackTrace(System.out);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            dc.clear();
        }
    }
}

