/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.gwc.web.layer.AbstractParameterFilterSubform;
import org.geowebcache.filter.parameters.FloatParameterFilter;

public class FloatParameterFilterSubform
extends AbstractParameterFilterSubform<FloatParameterFilter> {
    private static final long serialVersionUID = -1715100884515717529L;
    private static final IConverter<Float> FLOAT = new IConverter<Float>(){
        private static final long serialVersionUID = 5393727015187736272L;

        public Float convertToObject(String value, Locale locale) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException ex) {
                throw new ConversionException((Throwable)ex).setConverter((IConverter)this).setLocale(locale).setTargetType(Float.class).setSourceValue((Object)value).setResourceKey("notAValidNumber");
            }
        }

        public String convertToString(Float value, Locale locale) {
            return Float.toString(value.floatValue());
        }
    };
    private static final IConverter<List<Float>> CONVERT = new IConverter<List<Float>>(){
        private static final long serialVersionUID = 6972092160668131862L;

        public List<Float> convertToObject(String value, Locale locale) {
            if (value == null) {
                return null;
            }
            String[] strings = StringUtils.split((String)value, (String)"\r\n");
            ArrayList<Float> floats = new ArrayList<Float>(strings.length);
            for (String s : strings) {
                floats.add((Float)FLOAT.convertToObject(s, locale));
            }
            return floats;
        }

        public String convertToString(List<Float> value, Locale locale) {
            Iterator<Float> i = value.iterator();
            StringBuilder sb = new StringBuilder();
            if (i.hasNext()) {
                sb.append(FLOAT.convertToString((Object)i.next(), locale));
            }
            while (i.hasNext()) {
                sb.append("\r\n");
                sb.append(FLOAT.convertToString((Object)i.next(), locale));
            }
            return sb.toString();
        }
    };

    public FloatParameterFilterSubform(String id, IModel<FloatParameterFilter> model) {
        super(id, model);
        TextField defaultValue = new TextField("defaultValue", (IModel)new PropertyModel(model, "defaultValue"));
        this.add(new Component[]{defaultValue});
        TextArea<List<Float>> values = new TextArea<List<Float>>("values", (IModel)new PropertyModel(model, "values")){
            private static final long serialVersionUID = 1L;

            public <S> IConverter<S> getConverter(Class<S> type) {
                if (List.class.isAssignableFrom(type)) {
                    return CONVERT;
                }
                return super.getConverter(type);
            }
        };
        values.setConvertEmptyInputStringToNull(false);
        this.add(new Component[]{values});
        TextField<Float> threshold = new TextField<Float>("threshold", (IModel)new PropertyModel(model, "threshold")){
            private static final long serialVersionUID = 1L;

            public <S> IConverter<S> getConverter(Class<S> type) {
                if (Float.class.isAssignableFrom(type)) {
                    return FLOAT;
                }
                return super.getConverter(type);
            }
        };
        this.add(new Component[]{threshold});
    }
}

