/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.io.IOException;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.sort.SortedFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;

public class SortedSimpleFeatureCollection
extends DecoratingSimpleFeatureCollection {
    private SortBy[] sort;
    private int maxMemoryFeatures = -1;

    public SortedSimpleFeatureCollection(SimpleFeatureCollection delegate, SortBy ... sort) {
        super(delegate);
        this.sort = sort;
    }

    public SortedSimpleFeatureCollection(SimpleFeatureCollection delegate, SortBy[] sort, int maxMemoryFeatures) {
        super(delegate);
        this.sort = sort;
        this.maxMemoryFeatures = maxMemoryFeatures;
    }

    @Override
    public SimpleFeatureIterator features() {
        try {
            SimpleFeatureIterator features = this.delegate.features();
            if (this.sort != null) {
                features = new SortedFeatureIterator(features, this.getSchema(), this.sort, this.maxMemoryFeatures);
            }
            return features;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

