/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.media.jai.ROI;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.referencing.CRS;
import org.jaitools.media.jai.zonalstats.Result;
import org.jaitools.media.jai.zonalstats.ZonalStats;
import org.jaitools.media.jai.zonalstats.ZonalStatsOpImage;
import org.jaitools.numeric.Range;
import org.jaitools.numeric.Statistic;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

@DescribeProcess(title="Raster Zonal Statistics", description="Computes statistics for the distribution of a certain quantity in a set of polygonal zones.")
public class RasterZonalStatistics
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="statistics", description="A feature collection with the attributes of the zone layer (prefixed by 'z_') and the statistics fields count,min,max,sum,avg,stddev")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input raster to compute statistics for") GridCoverage2D coverage, @DescribeParameter(name="band", description="Source band used to compute statistics (default is 0)", min=0, defaultValue="0") Integer band, @DescribeParameter(name="zones", description="Zone polygon features for which to compute statistics") SimpleFeatureCollection zones, @DescribeParameter(name="classification", description="Raster whose values will be used as classes for the statistical analysis. Each zone reports statistics partitioned by classes according to the values of the raster. Must be a single band raster with integer values.", min=0) GridCoverage2D classification) {
        int iband = 0;
        if (band != null) {
            iband = band;
        }
        return new RasterZonalStatisticsCollection(coverage, iband, zones, classification);
    }

    static class RasterZonalStatisticsIterator
    implements SimpleFeatureIterator {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeatureIterator zones;
        SimpleFeatureBuilder builder;
        GridCoverage2D dataCoverage;
        int band;
        RenderedImage classificationRaster;
        List<SimpleFeature> features = new ArrayList<SimpleFeature>();

        public RasterZonalStatisticsIterator(SimpleFeatureIterator zones, GridCoverage2D coverage, int band, SimpleFeatureType targetSchema, GridCoverage2D classification) {
            this.zones = zones;
            this.builder = new SimpleFeatureBuilder(targetSchema);
            this.dataCoverage = coverage;
            this.band = band;
            if (classification != null) {
                double[] dArray;
                GridSampleDimension sampleDimension = classification.getSampleDimension(0);
                double[] nodataarr = sampleDimension.getNoDataValues();
                if (nodataarr != null) {
                    dArray = nodataarr;
                } else {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = Double.NaN;
                }
                double[] nodata = dArray;
                this.classificationRaster = GridCoverage2DRIA.create((GridCoverage2D)classification, (GridCoverage2D)this.dataCoverage, (double[])nodata);
            }
        }

        @Override
        public void close() {
            this.zones.close();
        }

        @Override
        public boolean hasNext() {
            return !this.features.isEmpty() || this.zones.hasNext();
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (this.features.isEmpty()) {
                SimpleFeature zone = (SimpleFeature)this.zones.next();
                try {
                    ZonalStats stats;
                    Geometry zoneGeom = (Geometry)zone.getDefaultGeometry();
                    CoordinateReferenceSystem dataCrs = this.dataCoverage.getCoordinateReferenceSystem();
                    CoordinateReferenceSystem zonesCrs = this.builder.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem();
                    if (!CRS.equalsIgnoreMetadata((Object)zonesCrs, (Object)dataCrs)) {
                        zoneGeom = JTS.transform(zoneGeom, CRS.findMathTransform((CoordinateReferenceSystem)zonesCrs, (CoordinateReferenceSystem)dataCrs, (boolean)true));
                    }
                    if ((stats = this.processStatistics(zoneGeom)) != null) {
                        if (this.classificationRaster != null) {
                            for (Integer classZoneId : stats.getZones()) {
                                this.builder.addAll(zone.getAttributes());
                                this.builder.add(classZoneId);
                                this.addStatsToFeature(stats.zone(classZoneId.intValue()));
                                this.features.add(this.builder.buildFeature(zone.getID()));
                            }
                        } else {
                            this.builder.addAll(zone.getAttributes());
                            this.addStatsToFeature(stats);
                            this.features.add(this.builder.buildFeature(zone.getID()));
                        }
                    } else {
                        this.builder.addAll(zone.getAttributes());
                        this.features.add(this.builder.buildFeature(zone.getID()));
                    }
                }
                catch (Exception e) {
                    throw new ProcessException("Failed to compute statistics on feature " + zone, e);
                }
            }
            SimpleFeature f = this.features.remove(0);
            return f;
        }

        void addStatsToFeature(ZonalStats stats) {
            double sum = ((Result)stats.statistic(Statistic.SUM).results().get(0)).getValue();
            double avg = ((Result)stats.statistic(Statistic.MEAN).results().get(0)).getValue();
            double count = ((Result)stats.statistic(Statistic.MEAN).results().get(0)).getNumAccepted();
            this.builder.add(count);
            this.builder.add(((Result)stats.statistic(Statistic.MIN).results().get(0)).getValue());
            this.builder.add(((Result)stats.statistic(Statistic.MAX).results().get(0)).getValue());
            this.builder.add(sum);
            this.builder.add(avg);
            this.builder.add(((Result)stats.statistic(Statistic.SDEV).results().get(0)).getValue());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ZonalStats processStatistics(Geometry geometry) throws TransformException {
            GridCoverage2D cropped = null;
            try {
                ReferencedEnvelope coverageEnvelope = new ReferencedEnvelope(this.dataCoverage.getEnvelope2D());
                ReferencedEnvelope geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), this.dataCoverage.getCoordinateReferenceSystem());
                if (!coverageEnvelope.intersects(geometryEnvelope)) {
                    ZonalStats zonalStats = null;
                    return zonalStats;
                }
                if (!coverageEnvelope.contains(geometryEnvelope)) {
                    geometry = JTS.toGeometry((Envelope)coverageEnvelope).intersection(geometry);
                    geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), this.dataCoverage.getCoordinateReferenceSystem());
                }
                List<Range<Double>> noDataValueRangeList = CoverageUtilities.getNoDataAsList(this.dataCoverage);
                cropped = CoverageUtilities.crop(this.dataCoverage, geometryEnvelope);
                ROI roi = CoverageUtilities.getSimplifiedRoiGeometry(this.dataCoverage, geometry);
                Statistic[] reqStatsArr = new Statistic[]{Statistic.MAX, Statistic.MIN, Statistic.RANGE, Statistic.MEAN, Statistic.SDEV, Statistic.SUM};
                ZonalStatsOpImage zsOp = new ZonalStatsOpImage(cropped.getRenderedImage(), this.classificationRaster, null, null, reqStatsArr, new Integer[]{this.band}, roi, null, null, null, false, noDataValueRangeList);
                ZonalStats zonalStats = (ZonalStats)zsOp.getProperty("ZonalStatsProperty");
                return zonalStats;
            }
            finally {
                if (cropped != null) {
                    cropped.dispose(true);
                }
            }
        }
    }

    static class RasterZonalStatisticsCollection
    extends DecoratingSimpleFeatureCollection {
        GridCoverage2D coverage;
        SimpleFeatureType targetSchema;
        int band;
        GridCoverage2D classification;

        public RasterZonalStatisticsCollection(GridCoverage2D coverage, int band, SimpleFeatureCollection zones, GridCoverage2D classification) {
            super(zones);
            this.coverage = coverage;
            this.band = band;
            this.classification = classification;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor att : ((SimpleFeatureType)zones.getSchema()).getAttributeDescriptors()) {
                tb.minOccurs(att.getMinOccurs());
                tb.maxOccurs(att.getMaxOccurs());
                tb.restrictions(att.getType().getRestrictions());
                if (att instanceof GeometryDescriptor) {
                    GeometryDescriptor gatt = (GeometryDescriptor)att;
                    tb.crs(gatt.getCoordinateReferenceSystem());
                }
                tb.add("z_" + att.getLocalName(), att.getType().getBinding());
            }
            if (classification != null) {
                tb.add("classification", Integer.class);
            }
            tb.add("count", Long.class);
            tb.add("min", Double.class);
            tb.add("max", Double.class);
            tb.add("sum", Double.class);
            tb.add("avg", Double.class);
            tb.add("stddev", Double.class);
            tb.setName(((SimpleFeatureType)zones.getSchema()).getName());
            this.targetSchema = tb.buildFeatureType();
        }

        @Override
        public SimpleFeatureType getSchema() {
            return this.targetSchema;
        }

        @Override
        public SimpleFeatureIterator features() {
            return new RasterZonalStatisticsIterator(this.delegate.features(), this.coverage, this.band, this.targetSchema, this.classification);
        }
    }
}

