/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.util.ArrayList;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.BaseCoverageAlgebraProcess;
import org.geotools.process.raster.RasterProcess;

@DescribeProcess(title="Multiply Coverages", description="Returns a raster generated by pixel-by-pixel multiplication of two source rasters.  Source rasters must have the same bounding box and resolution.")
public class MultiplyCoveragesProcess
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="result", description="Computed raster")
    public GridCoverage2D execute(@DescribeParameter(name="coverageA", description="First input raster") GridCoverage2D coverageA, @DescribeParameter(name="coverageB", description="Second input raster") GridCoverage2D coverageB, ProgressListener progressListener) throws ProcessException {
        BaseCoverageAlgebraProcess.checkCompatibleCoverages(coverageA, coverageB);
        ParameterValueGroup param = PROCESSOR.getOperation("Multiply").getParameters();
        ArrayList<GridCoverage2D> sources = new ArrayList<GridCoverage2D>();
        sources.add(coverageA);
        sources.add(coverageB);
        param.parameter("Sources").setValue(sources);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }
}

