/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.GeodeticCalculator;

final class GridConvergenceAngleCalc {
    private final CoordinateReferenceSystem crs;
    private GeodeticCalculator geoCalc;
    private final int upAxisDimension;

    public GridConvergenceAngleCalc(CoordinateReferenceSystem crs) throws Exception {
        this.crs = crs;
        this.geoCalc = new GeodeticCalculator(this.crs);
        this.upAxisDimension = this.determineUpAxisDimension();
        if (this.upAxisDimension < 0) {
            throw new Exception("Up Axis can not be determined.");
        }
    }

    public double getConvergenceAngle(Position2D position) throws Exception {
        CoordinateReferenceSystem positionCRS = position.getCoordinateReferenceSystem();
        if (!positionCRS.equals(this.crs)) {
            throw new Exception("Position CRS does not match Calculator CRS");
        }
        CoordinateSystemAxis upAxis = this.crs.getCoordinateSystem().getAxis(this.upAxisDimension);
        double upAxisMax = upAxis.getMaximumValue();
        double startValueUp = position.getOrdinate(this.upAxisDimension);
        if (startValueUp + 1.0 > upAxisMax) {
            position.setOrdinate(this.upAxisDimension, position.getOrdinate(this.upAxisDimension) - 1.0);
        }
        this.geoCalc.setStartingPosition((Position)position);
        Position2D endingPosition = new Position2D((Position)position);
        endingPosition.setOrdinate(this.upAxisDimension, position.getOrdinate(this.upAxisDimension) + 1.0);
        this.geoCalc.setDestinationPosition((Position)endingPosition);
        return this.geoCalc.getAzimuth();
    }

    private int determineUpAxisDimension() {
        CoordinateSystemAxis axis;
        int i;
        int numDimensions = this.crs.getCoordinateSystem().getDimension();
        if (numDimensions > 2) {
            return -1;
        }
        for (i = 0; i < numDimensions; ++i) {
            axis = this.crs.getCoordinateSystem().getAxis(i);
            AxisDirection axisDirection = axis.getDirection();
            if (!axisDirection.equals((Object)AxisDirection.DISPLAY_UP) && !axisDirection.equals((Object)AxisDirection.EAST_NORTH_EAST) && !axisDirection.equals((Object)AxisDirection.NORTH) && !axisDirection.equals((Object)AxisDirection.NORTH_EAST) && !axisDirection.equals((Object)AxisDirection.NORTH_NORTH_EAST) && !axisDirection.equals((Object)AxisDirection.NORTH_NORTH_WEST) && !axisDirection.equals((Object)AxisDirection.NORTH_WEST) && !axisDirection.equals((Object)AxisDirection.ROW_POSITIVE) && !axisDirection.equals((Object)AxisDirection.UP) && !axisDirection.equals((Object)AxisDirection.WEST_NORTH_WEST)) continue;
            return i;
        }
        for (i = 0; i < numDimensions; ++i) {
            axis = this.crs.getCoordinateSystem().getAxis(i);
            String axisName = axis.getName().toString().toUpperCase();
            if (!axisName.equals("Y") && !axisName.equals("NORTHING") && !axisName.contains("NORTHING")) continue;
            return i;
        }
        return -1;
    }
}

