/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.RenderingHints;
import java.io.IOException;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

@DescribeProcess(title="Crop Coverage", description="Returns the portion of a raster bounded by a given geometry.")
public class CropCoverage
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="result", description="Cropped raster")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="cropShape", description="Geometry used to crop the raster") Geometry cropShape, ProgressListener progressListener) throws IOException {
        CoordinateReferenceSystem crs = cropShape.getUserData() instanceof CoordinateReferenceSystem ? (CoordinateReferenceSystem)cropShape.getUserData() : coverage.getCoordinateReferenceSystem();
        GeneralBounds bounds = new GeneralBounds((Bounds)new ReferencedEnvelope(cropShape.getEnvelopeInternal(), crs));
        GeometryCollection roi = !(cropShape instanceof GeometryCollection) ? cropShape.getFactory().createGeometryCollection(new Geometry[]{cropShape}) : (GeometryCollection)cropShape;
        ParameterValueGroup param = PROCESSOR.getOperation("CoverageCrop").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("Envelope").setValue((Object)bounds);
        param.parameter("ROI").setValue((Object)roi);
        Hints hints = null;
        if (new ImageWorker(coverage.getRenderedImage()).getNoData() == null) {
            hints = new Hints((RenderingHints.Key)ImageWorker.FORCE_MOSAIC_ROI_PROPERTY, (Object)true);
        }
        return (GridCoverage2D)PROCESSOR.doOperation(param, hints);
    }
}

