/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.client;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPResponse;
import org.geotools.image.io.ImageIOExt;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wmts.WMTSHelper;
import org.geotools.ows.wmts.WMTSSpecification;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.client.TileURLBuilder;
import org.geotools.ows.wmts.client.WMTSTile;
import org.geotools.ows.wmts.client.WMTSTileFactory;
import org.geotools.ows.wmts.client.WMTSTileIdentifier;
import org.geotools.ows.wmts.client.WMTSZoomLevel;
import org.geotools.ows.wmts.model.TileMatrix;
import org.geotools.ows.wmts.model.TileMatrixLimits;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.ows.wmts.response.GetTileResponse;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.tile.Tile;
import org.geotools.tile.TileFactory;
import org.geotools.tile.TileIdentifier;
import org.geotools.tile.TileService;
import org.geotools.tile.impl.ScaleZoomLevelMatcher;
import org.geotools.tile.impl.ZoomLevel;
import org.geotools.util.logging.Logging;

public class WMTSTileService
extends TileService {
    protected static final Logger LOGGER = Logging.getLogger(WMTSTileService.class);
    public static final String EXTRA_HEADERS = "HEADERS";
    private static final TileFactory tileFactory = new WMTSTileFactory();
    private final TileURLBuilder urlBuilder;
    private final WebMapTileServer tileServer;
    private double[] scaleList;
    private TileMatrixSet matrixSet;
    private final WMTSLayer layer;
    private ReferencedEnvelope envelope;
    private final String format;
    private Map<String, Object> extrainfo = new HashMap<String, Object>();

    public WMTSTileService(String templateURL, WMTSServiceType type, WMTSLayer layer, String styleName, TileMatrixSet tileMatrixSet) {
        this(templateURL, type, layer, styleName, tileMatrixSet, HTTPClientFinder.createClient());
    }

    public WMTSTileService(String templateURL, WMTSServiceType type, WMTSLayer layer, String styleName, TileMatrixSet tileMatrixSet, HTTPClient client) {
        this(WMTSTileService.prepareWithLayerStyleTileMatrixSet(templateURL, type, layer.getName(), styleName, tileMatrixSet.getIdentifier()), layer, tileMatrixSet, client);
    }

    private static String prepareWithLayerStyleTileMatrixSet(String templateURL, WMTSServiceType type, String layerName, String styleName, String tileMatrixSet) {
        switch (type) {
            case KVP: {
                return WMTSHelper.appendQueryString(templateURL, WMTSSpecification.GetMultiTileRequest.getKVPparams(layerName, styleName, tileMatrixSet, "image/png"));
            }
            case REST: {
                templateURL = WMTSHelper.replaceToken(templateURL, "layer", layerName);
                templateURL = WMTSHelper.replaceToken(templateURL, "style", styleName);
                templateURL = WMTSHelper.replaceToken(templateURL, "tilematrixset", tileMatrixSet);
                return templateURL;
            }
        }
        throw new IllegalArgumentException("Unexpected WMTS Service type " + type);
    }

    public WMTSTileService(String templateURL, WMTSLayer layer, TileMatrixSet tileMatrixSet) {
        this(templateURL, layer, tileMatrixSet, HTTPClientFinder.createClient());
    }

    public WMTSTileService(String templateURL, WMTSLayer layer, TileMatrixSet tileMatrixSet, HTTPClient client) {
        super("wmts", templateURL, client);
        if (layer == null) {
            throw new IllegalArgumentException("Layer must be non-null.");
        }
        this.layer = layer;
        if (layer.getLatLonBoundingBox() == null) {
            throw new IllegalArgumentException("Layer must have a BoundingBox.");
        }
        this.envelope = new ReferencedEnvelope((Bounds)layer.getLatLonBoundingBox());
        this.urlBuilder = new TileURLBuilder(templateURL);
        this.tileServer = null;
        this.format = null;
        this.setMatrixSet(tileMatrixSet);
    }

    public WMTSTileService(WebMapTileServer wmtsServer, WMTSLayer layer, TileMatrixSet tileMatrixSet) {
        this(wmtsServer, layer, tileMatrixSet, null);
    }

    public WMTSTileService(WebMapTileServer wmtsServer, WMTSLayer layer, TileMatrixSet tileMatrixSet, String format) {
        super("wmts");
        this.tileServer = wmtsServer;
        if (layer == null) {
            throw new IllegalArgumentException("Layer must be non-null.");
        }
        this.layer = layer;
        if (layer.getLatLonBoundingBox() == null) {
            throw new IllegalArgumentException("Layer must have a non-null boundingBox");
        }
        this.format = format == null && !layer.getFormats().isEmpty() ? layer.getFormats().get(0) : format;
        this.envelope = new ReferencedEnvelope((Bounds)layer.getLatLonBoundingBox());
        this.urlBuilder = null;
        this.setMatrixSet(tileMatrixSet);
    }

    protected ReferencedEnvelope getReqExtentInTileCrs(ReferencedEnvelope requestedExtent) {
        boolean sameCRS;
        CoordinateReferenceSystem tileCrs;
        CoordinateReferenceSystem reqCrs = requestedExtent.getCoordinateReferenceSystem();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("orig request bbox :" + requestedExtent + " " + reqCrs.getCoordinateSystem().getAxis(0).getDirection() + " (" + reqCrs.getName() + ")");
        }
        ReferencedEnvelope reqExtentInTileCrs = null;
        for (CRSEnvelope layerEnv : this.layer.getLayerBoundingBoxes()) {
            if (CRS.equalsIgnoreMetadata(reqCrs, layerEnv.getCoordinateReferenceSystem())) {
                requestedExtent = requestedExtent.intersection(new ReferencedEnvelope((Bounds)layerEnv));
                if (!LOGGER.isLoggable(Level.FINE)) break;
                LOGGER.fine("Layer CRS match: cropping request bbox :" + requestedExtent);
                break;
            }
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Layer CRS not matching: req:" + reqCrs.getName() + " cov:" + layerEnv.getCoordinateReferenceSystem().getName());
        }
        if (!CRS.equalsIgnoreMetadata(tileCrs = this.matrixSet.getCoordinateReferenceSystem(), requestedExtent.getCoordinateReferenceSystem())) {
            try {
                reqExtentInTileCrs = requestedExtent.transform(tileCrs, true);
            }
            catch (FactoryException | TransformException ex) {
                LOGGER.log(Level.WARNING, "Requested extent can't be projected to tile CRS (" + reqCrs.getCoordinateSystem().getName() + " -> " + tileCrs.getCoordinateSystem().getName() + ") :" + ex.getMessage());
                try {
                    ReferencedEnvelope covExtentInReqCrs = this.envelope.transform(reqCrs, true);
                    requestedExtent = requestedExtent.intersection(covExtentInReqCrs);
                }
                catch (FactoryException | TransformException ex2) {
                    LOGGER.log(Level.WARNING, "Incompatible CRS: " + ex2.getMessage());
                    return null;
                }
            }
        } else {
            reqExtentInTileCrs = requestedExtent;
        }
        if (reqExtentInTileCrs == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Requested extent not in tile CRS range");
            }
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "tile crs req bbox :" + reqExtentInTileCrs + " " + reqExtentInTileCrs.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection() + " (" + reqExtentInTileCrs.getCoordinateReferenceSystem().getName() + ")");
        }
        ReferencedEnvelope coverageEnvelope = this.getBounds();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "coverage bbox :" + coverageEnvelope + " " + coverageEnvelope.getCoordinateReferenceSystem().getCoordinateSystem().getAxis(0).getDirection() + " (" + coverageEnvelope.getCoordinateReferenceSystem().getName() + ")");
        }
        if (sameCRS = CRS.equalsIgnoreMetadata(coverageEnvelope.getCoordinateReferenceSystem(), reqExtentInTileCrs.getCoordinateReferenceSystem())) {
            if (!coverageEnvelope.intersects(reqExtentInTileCrs)) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Extents do not intersect (sameCRS))");
                }
                return null;
            }
        } else {
            try {
                ReferencedEnvelope dataEnvelopeWGS84 = coverageEnvelope.transform(DefaultGeographicCRS.WGS84, true);
                ReferencedEnvelope requestEnvelopeWGS84 = requestedExtent.transform(DefaultGeographicCRS.WGS84, true);
                if (!dataEnvelopeWGS84.intersects(requestEnvelopeWGS84)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Extents do not intersect");
                    }
                    return null;
                }
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException(e);
            }
        }
        return reqExtentInTileCrs;
    }

    /*
     * Unable to fully structure code
     */
    public Set<Tile> findTilesInExtent(ReferencedEnvelope requestedExtent, double scaleFactor, boolean recommendedZoomLevel, int maxNumberOfTiles) {
        ret = Collections.emptySet();
        reqExtentInTileCrs = this.getReqExtentInTileCrs(requestedExtent);
        if (reqExtentInTileCrs == null) {
            if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                WMTSTileService.LOGGER.log(Level.FINE, "No valid extents, no Tiles will be returned.");
            }
            return ret;
        }
        tileFactory = (WMTSTileFactory)this.getTileFactory();
        zoomLevelMatcher = null;
        try {
            zoomLevelMatcher = this.getZoomLevelMatcher(reqExtentInTileCrs, this.matrixSet.getCoordinateReferenceSystem(), scaleFactor);
        }
        catch (FactoryException | TransformException e) {
            throw new RuntimeException(e);
        }
        zl = this.getZoomLevelFromMapScale(zoomLevelMatcher, scaleFactor);
        zoomLevel = tileFactory.getZoomLevel(zl, this);
        maxNumberOfTilesForZoomLevel = zoomLevel.getMaxTileNumber();
        if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
            WMTSTileService.LOGGER.log(Level.FINE, "Zoom level:" + zl + "[" + zoomLevel.getMaxTilePerColNumber() + " x " + zoomLevel.getMaxTilePerRowNumber() + "]");
        }
        tileList = new HashSet<Tile>((int)Math.min((long)maxNumberOfTiles, maxNumberOfTilesForZoomLevel));
        aorder = CRS.getAxisOrder(reqExtentInTileCrs.getCoordinateReferenceSystem());
        switch (2.$SwitchMap$org$geotools$referencing$CRS$AxisOrder[aorder.ordinal()]) {
            case 1: {
                ulLon = reqExtentInTileCrs.getMinX();
                ulLat = reqExtentInTileCrs.getMaxY();
                break;
            }
            case 2: {
                if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                    WMTSTileService.LOGGER.log(Level.FINE, "Inverted tile coords!");
                }
                ulLon = reqExtentInTileCrs.getMinY();
                ulLat = reqExtentInTileCrs.getMaxX();
                break;
            }
            default: {
                WMTSTileService.LOGGER.log(Level.WARNING, "unexpected axis order " + aorder);
                return ret;
            }
        }
        limits = WMTSTileFactory.getLimits(this.getMatrixSetLink(), this.getMatrixSet(), zl);
        upperLeft = this.identifyUpperLeftTile(ulLon, ulLat, zoomLevel);
        if (upperLeft == null) {
            if (WMTSTileService.LOGGER.isLoggable(Level.INFO)) {
                WMTSTileService.LOGGER.log(Level.INFO, "First tile not available at x:" + reqExtentInTileCrs.getMinX() + " y:" + reqExtentInTileCrs.getMaxY() + " at " + zoomLevel);
            }
            return ret;
        }
        firstTile = this.obtainTile(upperLeft);
        if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
            WMTSTileService.LOGGER.log(Level.FINE, "Adding first tile " + firstTile.getId() + " " + firstTile.getExtent() + " (" + firstTile.getExtent().getCoordinateReferenceSystem().getName() + ")");
        }
        tileList.add(firstTile);
        firstTileOfRow = firstTile;
        movingTile = firstTile;
        do lbl-1000:
        // 3 sources

        {
            block23: {
                block24: {
                    block22: {
                        if ((rightIdentifier = movingTile.getTileIdentifier().getRightNeighbour()) != null && (long)rightIdentifier.getX() <= limits.getMaxcol()) break block22;
                        if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                            WMTSTileService.LOGGER.log(Level.FINE, "No tiles on the right of " + movingTile.getId());
                        }
                        break block23;
                    }
                    rightNeighbour = this.obtainTile(rightIdentifier);
                    intersects = reqExtentInTileCrs.intersects(rightNeighbour.getExtent());
                    if (intersects) break block24;
                    if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                        WMTSTileService.LOGGER.log(Level.FINE, "Right neighbour out of extents " + rightNeighbour.getId());
                    }
                    break block23;
                }
                if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                    WMTSTileService.LOGGER.log(Level.FINE, "Adding right neighbour " + rightNeighbour.getId());
                }
                tileList.add(rightNeighbour);
                movingTile = rightNeighbour;
                if (tileList.size() > maxNumberOfTiles) {
                    WMTSTileService.LOGGER.warning("Reached tile limit of " + maxNumberOfTiles + ". Returning the tiles collected so far.");
                    return tileList;
                }
                if ((long)tileList.size() < maxNumberOfTilesForZoomLevel) ** GOTO lbl-1000
            }
            if ((lowerIdentifier = firstTileOfRow.getTileIdentifier().getLowerNeighbour()) == null || (long)lowerIdentifier.getY() > limits.getMaxrow()) {
                if (!WMTSTileService.LOGGER.isLoggable(Level.FINE)) break;
                WMTSTileService.LOGGER.log(Level.FINE, "No more tiles below " + firstTileOfRow.getId());
                break;
            }
            lowerNeighbour = this.obtainTile(lowerIdentifier);
            intersects = reqExtentInTileCrs.intersects(lowerNeighbour.getExtent());
            if (intersects) {
                if (WMTSTileService.LOGGER.isLoggable(Level.FINE)) {
                    WMTSTileService.LOGGER.log(Level.FINE, "Adding lower neighbour " + lowerNeighbour.getId());
                }
            } else {
                if (!WMTSTileService.LOGGER.isLoggable(Level.FINE)) break;
                WMTSTileService.LOGGER.log(Level.FINE, "Lower neighbour out of extents" + lowerNeighbour.getId());
                break;
            }
            tileList.add(lowerNeighbour);
            firstTileOfRow = movingTile = lowerNeighbour;
        } while ((long)tileList.size() < maxNumberOfTilesForZoomLevel);
        return tileList;
    }

    TileIdentifier identifyUpperLeftTile(double lon, double lat, WMTSZoomLevel zoomLevel) {
        TileIdentifier coordTile = this.identifyTileAtCoordinate(lon, lat, zoomLevel);
        return this.constrainToUpperLeftTile(coordTile, zoomLevel);
    }

    TileIdentifier constrainToUpperLeftTile(TileIdentifier coordTile, WMTSZoomLevel zl) {
        TileMatrixLimits limits = WMTSTileFactory.getLimits(this.getMatrixSetLink(), this.getMatrixSet(), zl.getZoomLevel());
        long origxTile = coordTile.getX();
        long origyTile = coordTile.getY();
        long xTile = origxTile;
        long yTile = origyTile;
        if (xTile >= limits.getMaxcol()) {
            xTile = limits.getMaxcol() - 1L;
        }
        if (yTile >= limits.getMaxrow()) {
            yTile = limits.getMaxrow() - 1L;
        }
        if (xTile < limits.getMincol()) {
            xTile = limits.getMincol();
        }
        if (yTile < limits.getMinrow()) {
            yTile = limits.getMinrow();
        }
        if ((origxTile != xTile || origyTile != yTile) && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("findUpperLeftTile: constraining tile within limits: (" + origxTile + "," + origyTile + ") -> (" + xTile + "," + yTile + ")");
        }
        return new WMTSTileIdentifier((int)xTile, (int)yTile, zl, this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage loadImageTileImage(Tile tile) throws IOException {
        if (this.tileServer == null) {
            if (!this.getExtrainfo().containsKey(EXTRA_HEADERS)) {
                return super.loadImageTileImage(tile);
            }
            Map headers = (Map)this.getExtrainfo().get(EXTRA_HEADERS);
            HTTPResponse http = this.getHttpClient().get(tile.getUrl(), headers);
            try {
                BufferedImage bufferedImage = ImageIOExt.readBufferedImage((Object)http.getResponseStream());
                return bufferedImage;
            }
            finally {
                http.dispose();
            }
        }
        TileIdentifier tileIdentifier = tile.getTileIdentifier();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Requesting tile " + tileIdentifier.getCode());
        }
        String tileMatrix = this.getTileMatrix(tileIdentifier.getZ()).getIdentifier();
        int tileCol = tileIdentifier.getX();
        int tileRow = tileIdentifier.getY();
        WMTSSpecification.GetSingleTileRequest request = this.createGetTileRequest(tileMatrix, tileCol, tileRow);
        try {
            GetTileResponse response = this.tileServer.issueRequest(request);
            return response.getTileImage();
        }
        catch (ServiceException e) {
            LOGGER.log(Level.SEVERE, "WMTS server returned exception", e);
            throw new IOException("WMTS server returned exception", e);
        }
    }

    public double[] getScaleList() {
        return this.scaleList;
    }

    public ReferencedEnvelope getBounds() {
        return this.envelope;
    }

    public CoordinateReferenceSystem getProjectedTileCrs() {
        return this.matrixSet.getCoordinateReferenceSystem();
    }

    public TileFactory getTileFactory() {
        return tileFactory;
    }

    public TileMatrixSetLink getMatrixSetLink() {
        String tileMatrixSetName = this.getMatrixSet().getIdentifier();
        return this.layer.getTileMatrixLinks().get(tileMatrixSetName);
    }

    private WMTSSpecification.GetSingleTileRequest createGetTileRequest(String tileMatrix, int tileCol, int tileRow) {
        WMTSSpecification.GetSingleTileRequest request = (WMTSSpecification.GetSingleTileRequest)this.tileServer.createGetTileRequest(false);
        request.setLayer(this.layer);
        request.setFormat(this.format);
        request.setTileMatrixSet(this.getMatrixSet().getIdentifier());
        request.setTileMatrix(tileMatrix);
        request.setTileCol(tileCol);
        request.setTileRow(tileRow);
        return request;
    }

    URL createURL(WMTSTile tile) {
        TileIdentifier tileIdentifier = tile.getTileIdentifier();
        String tileMatrix = this.getTileMatrix(tileIdentifier.getZ()).getIdentifier();
        int tileCol = tileIdentifier.getX();
        int tileRow = tileIdentifier.getY();
        if (this.tileServer == null) {
            try {
                return new URL(this.urlBuilder.createURL(tileMatrix, tileCol, tileRow));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Couldn't creat url from templateUrl");
            }
        }
        WMTSSpecification.GetSingleTileRequest request = this.createGetTileRequest(tileMatrix, tileCol, tileRow);
        return request.getFinalURL();
    }

    public TileMatrix getTileMatrix(int zoomLevel) {
        if (this.matrixSet == null) {
            throw new RuntimeException("TileMatrix is not set in WMTSService");
        }
        return this.matrixSet.getMatrices().get(zoomLevel);
    }

    public TileMatrixSet getMatrixSet() {
        return this.matrixSet;
    }

    public void setMatrixSet(TileMatrixSet matrixSet) {
        if (matrixSet == null) {
            throw new IllegalArgumentException("MatrixSet cannot be null");
        }
        this.matrixSet = matrixSet;
        this.scaleList = this.buildScaleList(matrixSet);
    }

    private double[] buildScaleList(TileMatrixSet tileMatrixSet) {
        double[] scaleList = new double[tileMatrixSet.size()];
        int j = 0;
        for (TileMatrix tm : tileMatrixSet.getMatrices()) {
            scaleList[j++] = tm.getDenominator();
        }
        return scaleList;
    }

    public WMTSZoomLevel getZoomLevel(int zoom) {
        return new WMTSZoomLevel(zoom, this);
    }

    public Map<String, Object> getExtrainfo() {
        return this.extrainfo;
    }

    private ScaleZoomLevelMatcher getZoomLevelMatcher(ReferencedEnvelope requestExtent, CoordinateReferenceSystem crsTiles, double scale) throws FactoryException, TransformException {
        CoordinateReferenceSystem crsMap = requestExtent.getCoordinateReferenceSystem();
        MathTransform transformMapToTile = CRS.findMathTransform(crsMap, crsTiles);
        MathTransform transformTileToMap = CRS.findMathTransform(crsTiles, crsMap);
        ReferencedEnvelope mapExtentTileCrs = ScaleZoomLevelMatcher.getProjectedEnvelope((ReferencedEnvelope)requestExtent, (CoordinateReferenceSystem)crsTiles, (MathTransform)transformMapToTile);
        return new ScaleZoomLevelMatcher(crsMap, crsTiles, transformMapToTile, transformTileToMap, mapExtentTileCrs, requestExtent, scale){

            public int getZoomLevelFromScale(TileService service, double[] tempScaleList) {
                double min = Double.MAX_VALUE;
                double scaleFactor = this.getScale();
                int zoomLevel = 0;
                for (int i = WMTSTileService.this.scaleList.length - 1; i >= 0; --i) {
                    double v = WMTSTileService.this.scaleList[i];
                    double diff = Math.abs(v - scaleFactor);
                    if (!(diff < min)) continue;
                    min = diff;
                    zoomLevel = i;
                }
                return zoomLevel;
            }
        };
    }

    public TileIdentifier identifyTileAtCoordinate(double lon, double lat, ZoomLevel zoomLevel) {
        double tileMatrixMaxY;
        double tileMatrixMinX;
        WMTSZoomLevel zl = (WMTSZoomLevel)zoomLevel;
        TileMatrix tileMatrix = this.getMatrixSet().getMatrices().get(zl.getZoomLevel());
        double pixelSpan = WMTSTileFactory.getPixelSpan(tileMatrix);
        double tileSpanY = (double)tileMatrix.getTileHeight() * pixelSpan;
        double tileSpanX = (double)tileMatrix.getTileWidth() * pixelSpan;
        if (tileMatrix.getCrs().getCoordinateSystem().getAxis(0).getDirection().equals((Object)AxisDirection.EAST)) {
            tileMatrixMinX = tileMatrix.getTopLeft().getX();
            tileMatrixMaxY = tileMatrix.getTopLeft().getY();
        } else {
            tileMatrixMaxY = tileMatrix.getTopLeft().getX();
            tileMatrixMinX = tileMatrix.getTopLeft().getY();
        }
        double epsilon = 1.0E-6;
        long xTile = (int)Math.floor((lon - tileMatrixMinX) / tileSpanX + epsilon);
        long yTile = (int)Math.floor((tileMatrixMaxY - lat) / tileSpanY + epsilon);
        xTile = Math.max(0L, xTile);
        yTile = Math.max(0L, yTile);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("identifyTile: (lon,lat)=(" + lon + "," + lat + ")  (col,row)=" + xTile + ", " + yTile + " zoom:" + zoomLevel.getZoomLevel());
        }
        return new WMTSTileIdentifier((int)xTile, (int)yTile, zoomLevel, this.getName());
    }

    static {
        String size = System.getProperty("wmts.tile.cache.size");
        if (size != null) {
            try {
                cacheSize = Integer.parseUnsignedInt(size);
            }
            catch (NumberFormatException ex) {
                LOGGER.info("Bad wmts.tile.cache.size property '" + size + "'");
            }
        } else {
            cacheSize = 150;
        }
    }
}

