/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.styling;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ChannelSelection;
import org.geotools.api.style.ColorMap;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.FeatureTypeConstraint;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Halo;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.NamedStyle;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.RemoteOWS;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.UserLayer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.NamedLayerImpl;
import org.geotools.styling.NamedStyleImpl;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.styling.UserLayerImpl;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.filter.FilterComplexTypes;
import org.geotools.xml.filter.FilterOpsComplexTypes;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.ElementValue;
import org.geotools.xml.schema.impl.AttributeGT;
import org.geotools.xml.schema.impl.ChoiceGT;
import org.geotools.xml.schema.impl.SequenceGT;
import org.geotools.xml.styling.sldComplexType;
import org.geotools.xml.styling.sldComplexTypes;
import org.geotools.xml.styling.sldElement;
import org.geotools.xml.styling.sldSchema;
import org.geotools.xml.styling.sldSimpleTypes;
import org.geotools.xml.xLink.XLinkSchema;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class sldComplexTypes2 {

    static class SymbolizerType
    extends sldComplexType {
        private static ComplexType instance = new SymbolizerType();
        private static Attribute[] attrs = null;
        private static Element[] elems = null;
        private static ElementGrouping child = new SequenceGT(null);

        public static ComplexType getInstance() {
            return instance;
        }

        private SymbolizerType() {
            super("SymbolizerType", child, attrs, elems, null, true, false);
        }

        @Override
        public Class getInstanceType() {
            return Symbolizer.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class SelectedChannelType
    extends sldComplexType {
        private static ComplexType instance = new SelectedChannelType();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("SourceChannelName", XSISimpleTypes.String.getInstance(), null, 1, 1), new sldElement("ContrastEnhancement", sldComplexTypes._ContrastEnhancement.getInstance(), null, 0, 1)};
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("SourceChannelName", XSISimpleTypes.String.getInstance(), null, 1, 1), new sldElement("ContrastEnhancement", sldComplexTypes._ContrastEnhancement.getInstance(), null, 0, 1)}, 1, 1);
        private static int SOURCECHANNELNAME = 0;
        private static int CONTRASTENHANCEMENT = 1;

        public static ComplexType getInstance() {
            return instance;
        }

        private SelectedChannelType() {
            super("SelectedChannelType", child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return SelectedChannelType.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) {
            SelectedChannelTypeImpl symbol = new SelectedChannelTypeImpl();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[SOURCECHANNELNAME].getName().equals(e.getName())) {
                    symbol.setChannelName((String)elementValue.getValue());
                }
                if (!elems[CONTRASTENHANCEMENT].getName().equals(e.getName())) continue;
                FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
                symbol.setContrastEnhancement(new ContrastEnhancementImpl(ff, (Expression)elementValue.getValue(), null));
            }
            return symbol;
        }
    }

    static class ParameterValueType
    extends sldComplexType {
        private static ComplexType instance = new ParameterValueType();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("expression", FilterComplexTypes.ExpressionType.getInstance(), null, 1, 1)};
        private static int EXPRESSION = 0;
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("expression", FilterComplexTypes.ExpressionType.getInstance(), null, 1, 1)}, 0, Integer.MAX_VALUE);

        public static ComplexType getInstance() {
            return instance;
        }

        private ParameterValueType() {
            super("ParameterValueType", child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return elems[EXPRESSION].getType().getInstanceType();
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) {
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (!elems[EXPRESSION].getName().equals(e.getName())) continue;
                return elementValue.getValue();
            }
            return null;
        }
    }

    static class _UserStyle
    extends sldComplexType {
        private static ComplexType instance = new _UserStyle();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Name", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Title", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Abstract", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("IsDefault", XSISimpleTypes.Boolean.getInstance(), null, 0, 1), new sldElement("FeatureTypeStyle", sldComplexTypes._FeatureTypeStyle.getInstance(), null, 1, Integer.MAX_VALUE)};
        private static ElementGrouping child = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        private _UserStyle() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _UserLayer
    extends sldComplexType {
        private static ComplexType instance = new _UserLayer();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Name", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("RemoteOWS", _RemoteOWS.getInstance(), null, 0, 1), new sldElement("LayerFeatureConstraints", _LayerFeatureConstraints.getInstance(), null, 1, 1), new sldElement("UserStyle", _UserStyle.getInstance(), null, 1, Integer.MAX_VALUE)};
        private static int NAME = 0;
        private static int REMOTEOWS = 1;
        private static int LAYERFEATURECONSTRAINTS = 2;
        private static int USERSTYLE = 3;
        private static ElementGrouping child = new SequenceGT(null, elems, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _UserLayer() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return UserLayer.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            UserLayerImpl sld = new UserLayerImpl();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[NAME].getName().equals(e.getName())) {
                    sld.setName((String)elementValue.getValue());
                }
                if (elems[REMOTEOWS].getName().equals(e.getName())) {
                    sld.setRemoteOWS((RemoteOWS)elementValue.getValue());
                }
                if (elems[LAYERFEATURECONSTRAINTS].getName().equals(e.getName())) {
                    sld.setLayerFeatureConstraints((FeatureTypeConstraint[])elementValue.getValue());
                }
                if (!elems[USERSTYLE].getName().equals(e.getName())) continue;
                sld.addUserStyle((Style)elementValue.getValue());
            }
            return sld;
        }
    }

    static class _TextSymbolizer
    extends sldComplexType {
        private static ComplexType instance = new _TextSymbolizer();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Geometry", sldComplexTypes._Geometry.getInstance(), null, 0, 1), new sldElement("Label", ParameterValueType.getInstance(), null, 0, 1), new sldElement("Font", sldComplexTypes._Font.getInstance(), null, 0, 1), new sldElement("LabelPlacement", sldComplexTypes._LabelPlacement.getInstance(), null, 0, 1), new sldElement("Halo", sldComplexTypes._Halo.getInstance(), null, 0, 1), new sldElement("Fill", sldComplexTypes._Fill.getInstance(), null, 0, 1)};
        private static int GEOMETRY = 0;
        private static int LABEL = 1;
        private static int FONT = 2;
        private static int LABELPLACEMENT = 3;
        private static int HALO = 4;
        private static int FILL = 5;
        private static ElementGrouping child = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        private _TextSymbolizer() {
            super(null, child, attrs, elems, SymbolizerType.getInstance(), false, false);
        }

        @Override
        public Class getInstanceType() {
            return TextSymbolizer.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException {
            TextSymbolizer symbol = CommonFactoryFinder.getStyleFactory().createTextSymbolizer();
            symbol.setFill(null);
            ArrayList<Font> fonts = new ArrayList<Font>();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[GEOMETRY].getName().equals(e.getName())) {
                    symbol.setGeometryPropertyName((String)elementValue.getValue());
                }
                if (elems[FILL].getName().equals(e.getName())) {
                    symbol.setFill((Fill)elementValue.getValue());
                }
                if (elems[LABEL].getName().equals(e.getName())) {
                    symbol.setLabel((Expression)elementValue.getValue());
                }
                if (elems[FONT].getName().equals(e.getName())) {
                    fonts.add((Font)elementValue.getValue());
                }
                if (elems[LABELPLACEMENT].getName().equals(e.getName())) {
                    symbol.setFill((Fill)elementValue.getValue());
                }
                if (elems[LABELPLACEMENT].getName().equals(e.getName())) {
                    symbol.setLabelPlacement((LabelPlacement)elementValue.getValue());
                }
                if (!elems[HALO].getName().equals(e.getName())) continue;
                symbol.setHalo((Halo)elementValue.getValue());
            }
            symbol.fonts().addAll(fonts);
            return symbol;
        }
    }

    static class _StyledLayerDescriptor
    extends sldComplexType {
        private static ComplexType instance = new _StyledLayerDescriptor();
        private static Attribute[] attrs = new Attribute[]{new AttributeGT(null, "version", sldSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false)};
        private static Element[] elems = new Element[]{new sldElement("Name", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Title", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Abstract", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("NamedLayer", _NamedLayer.getInstance(), null, 0, Integer.MAX_VALUE), new sldElement("UserLayer", _UserLayer.getInstance(), null, 0, Integer.MAX_VALUE)};
        private static int NAME = 0;
        private static int TITLE = 1;
        private static int ABSTRACT = 2;
        private static int NAMEDLAYER = 3;
        private static int USERLAYER = 4;
        private static ElementGrouping child = new SequenceGT(new ElementGrouping[]{elems[0], elems[1], elems[2], new ChoiceGT(null, 0, Integer.MAX_VALUE, new ElementGrouping[]{elems[3], elems[4]})});

        public static ComplexType getInstance() {
            return instance;
        }

        private _StyledLayerDescriptor() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return StyledLayerDescriptor.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            StyledLayerDescriptor sld = CommonFactoryFinder.getStyleFactory().createStyledLayerDescriptor();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[NAME].getName().equals(e.getName())) {
                    sld.setName((String)elementValue.getValue());
                }
                if (elems[TITLE].getName().equals(e.getName())) {
                    sld.setTitle((String)elementValue.getValue());
                }
                if (elems[ABSTRACT].getName().equals(e.getName())) {
                    sld.setAbstract((String)elementValue.getValue());
                }
                if (elems[NAMEDLAYER].getName().equals(e.getName())) {
                    sld.addStyledLayer((StyledLayer)((StyledLayerImpl)elementValue.getValue()));
                }
                if (!elems[USERLAYER].getName().equals(e.getName())) continue;
                sld.addStyledLayer((StyledLayer)((StyledLayerImpl)elementValue.getValue()));
            }
            return sld;
        }
    }

    static class _Stroke
    extends sldComplexType {
        private static ComplexType instance = new _Stroke();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("GraphicFill", null, null, 1, 1), new sldElement("GraphicStroke", sldComplexTypes._GraphicStroke.getInstance(), null, 1, 1), new sldElement("CssParameter", sldComplexTypes._CssParameter.getInstance(), null, 0, Integer.MAX_VALUE)};
        private static int GRAPHICFILL = 0;
        private static int GRAPHICSTROKE = 1;
        private static ElementGrouping child = new SequenceGT(new ElementGrouping[]{new ChoiceGT(null, 0, 1, new ElementGrouping[]{elems[0], elems[1]}), elems[2]});

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Class getInstanceType() {
            return Stroke.class;
        }

        private _Stroke() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException {
            Stroke symbol = CommonFactoryFinder.getStyleFactory().getDefaultStroke();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[GRAPHICFILL].getName().equals(e.getName())) {
                    symbol.setGraphicFill((Graphic)elementValue.getValue());
                }
                if (!elems[GRAPHICSTROKE].getName().equals(e.getName())) continue;
                symbol.setGraphicStroke((Graphic)elementValue.getValue());
            }
            return symbol;
        }
    }

    static class _ShadedRelief
    extends sldComplexType {
        private static ComplexType instance = new _ShadedRelief();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("BrightnessOnly", XSISimpleTypes.Boolean.getInstance(), null, 0, 1), new sldElement("ReliefFactor", XSISimpleTypes.Double.getInstance(), null, 0, 1)};
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("BrightnessOnly", XSISimpleTypes.Boolean.getInstance(), null, 0, 1), new sldElement("ReliefFactor", XSISimpleTypes.Double.getInstance(), null, 0, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _ShadedRelief() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _Rule
    extends sldComplexType {
        private static ComplexType instance = new _Rule();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Name", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Title", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Abstract", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("LegendGraphic", _LegendGraphic.getInstance(), null, 0, 1), new sldElement("Filter", FilterOpsComplexTypes.FilterType.getInstance(), null, 1, 1), new sldElement("ElseFilter", sldComplexTypes._ElseFilter.getInstance(), null, 1, 1), new sldElement("MinScaleDenominator", XSISimpleTypes.Double.getInstance(), null, 0, 1), new sldElement("MaxScaleDenominator", XSISimpleTypes.Double.getInstance(), null, 0, 1), new sldElement("Symbolizer", SymbolizerType.getInstance(), null, 1, Integer.MAX_VALUE)};
        private static ElementGrouping child = new SequenceGT(new ElementGrouping[]{elems[0], elems[1], elems[2], elems[3], new ChoiceGT(new ElementGrouping[]{elems[4], elems[5]}), elems[6], elems[7], elems[8]});

        public static ComplexType getInstance() {
            return instance;
        }

        private _Rule() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _RemoteOWS
    extends sldComplexType {
        private static ComplexType instance = new _RemoteOWS();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Service", sldSimpleTypes._Service.getInstance(), null, 1, 1), new sldElement("OnlineResource", _OnlineResource.getInstance(), null, 1, 1)};
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("Service", sldSimpleTypes._Service.getInstance(), null, 1, 1), new sldElement("OnlineResource", _OnlineResource.getInstance(), null, 1, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _RemoteOWS() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _RasterSymbolizer
    extends sldComplexType {
        private static ComplexType instance = new _RasterSymbolizer();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Geometry", sldComplexTypes._Geometry.getInstance(), null, 0, 1), new sldElement("Opacity", ParameterValueType.getInstance(), null, 0, 1), new sldElement("ChannelSelection", sldComplexTypes._ChannelSelection.getInstance(), null, 0, 1), new sldElement("OverlapBehavior", _OverlapBehavior.getInstance(), null, 0, 1), new sldElement("ColorMap", sldComplexTypes._ColorMap.getInstance(), null, 0, 1), new sldElement("ContrastEnhancement", sldComplexTypes._ContrastEnhancement.getInstance(), null, 0, 1), new sldElement("ShadedRelief", _ShadedRelief.getInstance(), null, 0, 1), new sldElement("ImageOutline", sldComplexTypes._ImageOutline.getInstance(), null, 0, 1)};
        private static int GEOMETRY = 0;
        private static int OPACITY = 1;
        private static int CHANNELSELECTION = 2;
        private static int OVERLAPBEHAVIOR = 3;
        private static int COLORMAP = 4;
        private static int CONTRASTENHANCEMENT = 5;
        private static int SHADEDRELIEF = 6;
        private static int IMAGEOUTLINE = 7;
        private static ElementGrouping child = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        @Override
        public Class getInstanceType() {
            return RasterSymbolizer.class;
        }

        private _RasterSymbolizer() {
            super(null, child, attrs, elems, SymbolizerType.getInstance(), false, false);
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException {
            RasterSymbolizer symbol = CommonFactoryFinder.getStyleFactory().getDefaultRasterSymbolizer();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[GEOMETRY].getName().equals(e.getName())) {
                    symbol.setGeometryPropertyName((String)elementValue.getValue());
                }
                if (elems[OPACITY].getName().equals(e.getName())) {
                    symbol.setOpacity((Expression)elementValue.getValue());
                }
                if (elems[CHANNELSELECTION].getName().equals(e.getName())) {
                    symbol.setChannelSelection((ChannelSelection)elementValue.getValue());
                }
                if (elems[OVERLAPBEHAVIOR].getName().equals(e.getName())) {
                    symbol.setOverlap((Expression)elementValue.getValue());
                }
                if (elems[COLORMAP].getName().equals(e.getName())) {
                    symbol.setColorMap((ColorMap)elementValue.getValue());
                }
                if (elems[CONTRASTENHANCEMENT].getName().equals(e.getName())) {
                    symbol.setContrastEnhancement((ContrastEnhancement)elementValue.getValue());
                }
                if (elems[SHADEDRELIEF].getName().equals(e.getName())) {
                    symbol.setShadedRelief((ShadedRelief)elementValue.getValue());
                }
                if (!elems[IMAGEOUTLINE].getName().equals(e.getName())) continue;
                symbol.setImageOutline((Symbolizer)elementValue.getValue());
            }
            return symbol;
        }
    }

    static class _RANDOM
    extends sldComplexType {
        private static ComplexType instance = new _RANDOM();
        private static Attribute[] attrs = null;
        private static Element[] elems = null;
        private static ElementGrouping child = new SequenceGT(null);

        public static ComplexType getInstance() {
            return instance;
        }

        private _RANDOM() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _PolygonSymbolizer
    extends sldComplexType {
        private static ComplexType instance = new _PolygonSymbolizer();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Geometry", sldComplexTypes._Geometry.getInstance(), null, 0, 1), new sldElement("Fill", sldComplexTypes._Fill.getInstance(), null, 0, 1), new sldElement("Stroke", _Stroke.getInstance(), null, 0, 1)};
        private static int GEOMETRY = 0;
        private static int FILL = 1;
        private static int STROKE = 2;
        private static ElementGrouping child = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        private _PolygonSymbolizer() {
            super(null, child, attrs, elems, SymbolizerType.getInstance(), false, false);
        }

        @Override
        public Class getInstanceType() {
            return PolygonSymbolizer.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException {
            PolygonSymbolizer symbol = CommonFactoryFinder.getStyleFactory().getDefaultPolygonSymbolizer();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[GEOMETRY].getName().equals(e.getName())) {
                    symbol.setGeometryPropertyName((String)elementValue.getValue());
                }
                if (elems[FILL].getName().equals(e.getName())) {
                    symbol.setFill((Fill)elementValue.getValue());
                }
                if (!elems[STROKE].getName().equals(e.getName())) continue;
                symbol.setStroke((Stroke)elementValue.getValue());
            }
            return symbol;
        }
    }

    static class _PointSymbolizer
    extends sldComplexType {
        private static ComplexType instance = new _PointSymbolizer();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Geometry", sldComplexTypes._Geometry.getInstance(), null, 0, 1), new sldElement("Graphic", sldComplexTypes._Graphic.getInstance(), null, 0, 1)};
        private static int GEOMETRY = 0;
        private static int GRAPHIC = 1;
        private static ElementGrouping child = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        private _PointSymbolizer() {
            super(null, child, attrs, elems, SymbolizerType.getInstance(), false, false);
        }

        @Override
        public Class getInstanceType() {
            return PointSymbolizer.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException {
            PointSymbolizer symbol = CommonFactoryFinder.getStyleFactory().getDefaultPointSymbolizer();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[GEOMETRY].getName().equals(e.getName())) {
                    symbol.setGeometryPropertyName((String)elementValue.getValue());
                }
                if (!elems[GRAPHIC].getName().equals(e.getName())) continue;
                symbol.setGraphic((Graphic)elementValue.getValue());
            }
            return symbol;
        }
    }

    static class _PointPlacement
    extends sldComplexType {
        private static ComplexType instance = new _PointPlacement();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("AnchorPoint", sldComplexTypes._AnchorPoint.getInstance(), null, 0, 1), new sldElement("Displacement", sldComplexTypes._Displacement.getInstance(), null, 0, 1), new sldElement("Rotation", ParameterValueType.getInstance(), null, 0, 1)};
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("AnchorPoint", sldComplexTypes._AnchorPoint.getInstance(), null, 0, 1), new sldElement("Displacement", sldComplexTypes._Displacement.getInstance(), null, 0, 1), new sldElement("Displacement", sldComplexTypes._Displacement.getInstance(), null, 0, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _PointPlacement() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _OverlapBehavior
    extends sldComplexType {
        private static ComplexType instance = new _OverlapBehavior();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("LATEST_ON_TOP", sldComplexTypes._LATEST_ON_TOP.getInstance(), null, 1, 1), new sldElement("EARLIEST_ON_TOP", sldComplexTypes._EARLIEST_ON_TOP.getInstance(), null, 1, 1), new sldElement("AVERAGE", sldComplexTypes._AVERAGE.getInstance(), null, 1, 1), new sldElement("RANDOM", _RANDOM.getInstance(), null, 1, 1)};
        private static ElementGrouping child = new ChoiceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        private _OverlapBehavior() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _OnlineResource
    extends sldComplexType {
        private static ComplexType instance = new _OnlineResource();
        private static Attribute[] attrs = XLinkSchema.SimpleLink.getInstance().getAttributes();
        private static Element[] elems = null;
        private static ElementGrouping child = new SequenceGT(null);

        public static ComplexType getInstance() {
            return instance;
        }

        private _OnlineResource() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return URL.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws SAXException {
            String href = attrs1.getValue("", attrs[0].getName());
            if (href == null || "".equals(href)) {
                href = attrs1.getValue(attrs[0].getNamespace().toString(), attrs[0].getName());
            }
            try {
                return new URL(href);
            }
            catch (MalformedURLException e) {
                SAXException ee = new SAXException(e.getMessage());
                ee.initCause(e);
                throw ee;
            }
        }
    }

    static class _Normalize
    extends sldComplexType {
        private static ComplexType instance = new _Normalize();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Algorithm", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Parameter", _Parameter.getInstance(), null, 0, Integer.MAX_VALUE)};
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("Algorithm", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Parameter", _Parameter.getInstance(), null, 0, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _Normalize() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }

    static class _Parameter
    extends sldComplexType {
        private static ComplexType instance = new _Parameter();
        private static Attribute[] attrs = new Attribute[]{new AttributeGT(null, "name", sldSchema.NAMESPACE, XSISimpleTypes.String.getInstance(), 2, null, null, false)};
        private static final ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("expression", FilterComplexTypes.ExpressionType.getInstance(), null, 1, 1)}, 0, Integer.MAX_VALUE);
        private static final Element[] elems = new Element[]{new sldElement("expression", FilterComplexTypes.ExpressionType.getInstance(), null, 1, 1)};

        public static ComplexType getInstance() {
            return instance;
        }

        public _Parameter(String name, ElementGrouping child, Attribute[] attrs, Element[] elems) {
            super(name, child, attrs, elems);
        }

        private _Parameter() {
            super("Parameter", child, attrs, elems, null, false, false);
        }
    }

    static class _NamedStyle
    extends sldComplexType {
        private static ComplexType instance = new _NamedStyle();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Name", XSISimpleTypes.String.getInstance(), null, 1, 1)};
        private static int NAME = 0;
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("Name", XSISimpleTypes.String.getInstance(), null, 1, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _NamedStyle() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) {
            NamedStyleImpl sld = new NamedStyleImpl();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (!elems[NAME].getName().equals(e.getName())) continue;
                sld.setName((String)elementValue.getValue());
            }
            return sld;
        }
    }

    static class _NamedLayer
    extends sldComplexType {
        private static ComplexType instance = new _NamedLayer();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Name", XSISimpleTypes.String.getInstance(), null, 1, 1), new sldElement("LayerFeatureConstraints", _LayerFeatureConstraints.getInstance(), null, 0, 1), new sldElement("NamedStyle", _NamedStyle.getInstance(), null, 1, 1), new sldElement("UserStyle", _UserStyle.getInstance(), null, 1, 1)};
        private static int NAME = 0;
        private static int LAYERFEATURECONSTRAINTS = 1;
        private static int NAMEDSTYLE = 2;
        private static int USERSTYLE = 3;
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{elems[0], elems[1], new ChoiceGT(null, 0, Integer.MAX_VALUE, new ElementGrouping[]{elems[2], elems[3]})}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _NamedLayer() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) {
            NamedLayerImpl sld = new NamedLayerImpl();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[NAME].getName().equals(e.getName())) {
                    sld.setName((String)elementValue.getValue());
                }
                if (elems[LAYERFEATURECONSTRAINTS].getName().equals(e.getName())) continue;
                if (elems[NAMEDSTYLE].getName().equals(e.getName())) {
                    sld.addStyle((Style)((NamedStyle)elementValue.getValue()));
                }
                if (!elems[USERSTYLE].getName().equals(e.getName())) continue;
                sld.addStyle((Style)elementValue.getValue());
            }
            return sld;
        }
    }

    static class _Mark
    extends sldComplexType {
        private static ComplexType instance = new _Mark();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("WellKnownName", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Fill", null, null, 0, 1), new sldElement("Stroke", _Stroke.getInstance(), null, 0, 1)};
        private static int WELLKNOWNNAME = 0;
        private static int FILL = 1;
        private static int STROKE = 2;
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("WellKnownName", XSISimpleTypes.String.getInstance(), null, 0, 1), new sldElement("Fill", null, null, 0, 1), new sldElement("Fill", null, null, 0, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _Mark() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return Mark.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) {
            Mark symbol = CommonFactoryFinder.getStyleFactory().getDefaultMark();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[WELLKNOWNNAME].getName().equals(e.getName())) {
                    symbol.setWellKnownName((Expression)elementValue.getValue());
                }
                if (elems[FILL].getName().equals(e.getName())) {
                    symbol.setFill((Fill)elementValue.getValue());
                }
                if (!elems[STROKE].getName().equals(e.getName())) continue;
                symbol.setStroke((Stroke)elementValue.getValue());
            }
            return symbol;
        }
    }

    static class _LineSymbolizer
    extends sldComplexType {
        private static ComplexType instance = new _LineSymbolizer();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Geometry", sldComplexTypes._Geometry.getInstance(), null, 0, 1), new sldElement("Stroke", _Stroke.getInstance(), null, 0, 1)};
        private static int GEOMETRY = 0;
        private static int STROKE = 1;
        private static ElementGrouping child = new SequenceGT(elems);

        public static ComplexType getInstance() {
            return instance;
        }

        private _LineSymbolizer() {
            super(null, child, attrs, elems, SymbolizerType.getInstance(), false, false);
        }

        @Override
        public Class getInstanceType() {
            return LineSymbolizer.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) {
            LineSymbolizer symbol = CommonFactoryFinder.getStyleFactory().getDefaultLineSymbolizer();
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (elems[GEOMETRY].getName().equals(e.getName())) {
                    symbol.setGeometryPropertyName((String)elementValue.getValue());
                }
                if (!elems[STROKE].getName().equals(e.getName())) continue;
                symbol.setStroke((Stroke)elementValue.getValue());
            }
            return symbol;
        }
    }

    static class _LinePlacement
    extends sldComplexType {
        private static ComplexType instance = new _LinePlacement();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("PerpendicularOffset", ParameterValueType.getInstance(), null, 0, 1)};
        private static int PERPENDICULAROFFSET = 0;
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("PerpendicularOffset", ParameterValueType.getInstance(), null, 0, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _LinePlacement() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return LinePlacement.class;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) {
            Expression offset = null;
            for (ElementValue elementValue : value) {
                if (elementValue == null || elementValue.getElement() == null) continue;
                Element e = elementValue.getElement();
                if (!elems[PERPENDICULAROFFSET].getName().equals(e.getName())) continue;
                offset = (Expression)elementValue.getValue();
            }
            LinePlacement dlp = CommonFactoryFinder.getStyleFactory().createLinePlacement(offset);
            return dlp;
        }
    }

    static class _LegendGraphic
    extends sldComplexType {
        private static ComplexType instance = new _LegendGraphic();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("Graphic", sldComplexTypes._Graphic.getInstance(), null, 1, 1)};
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("Graphic", sldComplexTypes._Graphic.getInstance(), null, 1, 1)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _LegendGraphic() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return sldComplexTypes._Graphic.getInstance().getInstanceType();
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return sldComplexTypes._Graphic.getInstance().getValue(element, value, attrs1, hints);
        }
    }

    static class _LayerFeatureConstraints
    extends sldComplexType {
        private static ComplexType instance = new _LayerFeatureConstraints();
        private static Attribute[] attrs = null;
        private static Element[] elems = new Element[]{new sldElement("FeatureTypeConstraint", sldComplexTypes._FeatureTypeConstraint.getInstance(), null, 1, Integer.MAX_VALUE)};
        private static ElementGrouping child = new SequenceGT(null, new ElementGrouping[]{new sldElement("FeatureTypeConstraint", sldComplexTypes._FeatureTypeConstraint.getInstance(), null, 1, Integer.MAX_VALUE)}, 1, 1);

        public static ComplexType getInstance() {
            return instance;
        }

        private _LayerFeatureConstraints() {
            super(null, child, attrs, elems, null, false, false);
        }

        @Override
        public Class getInstanceType() {
            return null;
        }

        @Override
        public boolean canEncode(Element element, Object value, Map<String, Object> hints) {
            return super.canEncode(element, value, hints);
        }

        @Override
        public void encode(Element element, Object value, PrintHandler output, Map<String, Object> hints) throws OperationNotSupportedException {
            super.encode(element, value, output, hints);
        }

        @Override
        public Object getValue(Element element, ElementValue[] value, Attributes attrs1, Map<String, Object> hints) throws OperationNotSupportedException, SAXException {
            return super.getValue(element, value, attrs1, hints);
        }
    }
}

