/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.extensions.markup.html.form.palette.theme.DefaultTheme;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.geoserver.web.wicket.SimpleChoiceRenderer;

public class OutputTypesFormComponent
extends FormComponentPanel<String> {
    protected Palette<String> palette;
    protected AjaxCheckBox allOutputTypesCheckBox;
    List<Behavior> toAdd = new ArrayList<Behavior>();

    public OutputTypesFormComponent(String id, IModel<List<String>> model, IModel<Collection<String>> choicesModel, boolean isOutputTypeCheckingEnabled) {
        super(id, (IModel)new Model());
        this.add(new Component[]{new AjaxCheckBox("outputTypeCheckingEnabled", (IModel)new Model((Serializable)Boolean.valueOf(isOutputTypeCheckingEnabled))){

            protected void onUpdate(AjaxRequestTarget target) {
                OutputTypesFormComponent.this.toggleVisibility((Boolean)this.getModelObject());
                target.add(new Component[]{OutputTypesFormComponent.this.palette});
            }
        }});
        Component[] componentArray = new Component[1];
        this.palette = new Palette<String>("palette", model, choicesModel, (IChoiceRenderer)new SimpleChoiceRenderer(), 10, false){
            private static final long serialVersionUID = 1L;

            protected Recorder<String> newRecorderComponent() {
                Recorder rec = super.newRecorderComponent();
                rec.add(OutputTypesFormComponent.this.toAdd.toArray(new Behavior[OutputTypesFormComponent.this.toAdd.size()]));
                OutputTypesFormComponent.this.toAdd.clear();
                return rec;
            }

            public Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel(OutputTypesFormComponent.this.getSelectedHeaderPropertyKey()));
            }

            public Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel(OutputTypesFormComponent.this.getAvaliableHeaderPropertyKey()));
            }
        };
        componentArray[0] = this.palette;
        this.add(componentArray);
        this.palette.add(new Behavior[]{new DefaultTheme()});
        this.palette.setOutputMarkupPlaceholderTag(true);
        this.toggleVisibility(isOutputTypeCheckingEnabled);
    }

    void toggleVisibility(boolean visible) {
        this.palette.setVisible(visible);
        if (!visible) {
            this.palette.getModelCollection().clear();
        }
    }

    public void setOutputTypeCheckingEnabled(boolean enabled) {
        this.get("outputTypeCheckingEnabled").setDefaultModelObject((Object)enabled);
        this.toggleVisibility(enabled);
    }

    public boolean isOutputTypeCheckingEnabled() {
        return (Boolean)this.get("outputTypeCheckingEnabled").getDefaultModelObject();
    }

    protected String getSelectedHeaderPropertyKey() {
        return "OutputTypesFormComponent.selectedHeader";
    }

    protected String getAvaliableHeaderPropertyKey() {
        return "OutputTypesFormComponent.availableHeader";
    }

    public Component add(Behavior ... behaviors) {
        if (this.palette.getRecorderComponent() == null) {
            this.toAdd.addAll(Arrays.asList(behaviors));
        } else {
            this.palette.getRecorderComponent().add(behaviors);
        }
        return this;
    }

    public Palette<String> getPalette() {
        return this.palette;
    }

    public IModel<Collection<String>> getPaletteModel() {
        return this.palette.getModel();
    }

    public void updateModel() {
        super.updateModel();
        if (this.palette.getRecorderComponent() != null) {
            this.palette.getRecorderComponent().updateModel();
        }
    }
}

