/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs;

import java.awt.Rectangle;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.Interpolation;
import net.opengis.gml.CodeType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.RectifiedGridType;
import net.opengis.gml.TimePositionType;
import net.opengis.gml.VectorType;
import net.opengis.wcs10.AxisSubsetType;
import net.opengis.wcs10.DescribeCoverageType;
import net.opengis.wcs10.DomainSubsetType;
import net.opengis.wcs10.GetCapabilitiesType;
import net.opengis.wcs10.GetCoverageType;
import net.opengis.wcs10.InterpolationMethodType;
import net.opengis.wcs10.IntervalType;
import net.opengis.wcs10.OutputType;
import net.opengis.wcs10.RangeSubsetType;
import net.opengis.wcs10.SpatialSubsetType;
import net.opengis.wcs10.TimePeriodType;
import net.opengis.wcs10.TimeSequenceType;
import net.opengis.wcs10.TypedLiteralType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.DimensionInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.util.ReaderDimensionsAccessor;
import org.geoserver.config.GeoServer;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.ows.util.RequestUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wcs.CoverageCleanerCallback;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.wcs.WebCoverageService100;
import org.geoserver.wcs.response.Wcs10CapsTransformer;
import org.geoserver.wcs.response.Wcs10DescribeCoverageTransformer;
import org.geoserver.wcs.responses.CoverageResponseDelegate;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.filter.Filter;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GeneralGridGeometry;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.vfny.geoserver.util.WCSUtils;
import org.vfny.geoserver.wcs.WcsException;

public class DefaultWebCoverageService100
implements WebCoverageService100 {
    private Catalog catalog;
    private GeoServer geoServer;
    private CoverageResponseDelegateFinder responseFactory;
    private static final Logger LOGGER = Logging.getLogger(DefaultWebCoverageService100.class);

    public DefaultWebCoverageService100(GeoServer geoServer, CoverageResponseDelegateFinder responseFactory) {
        this.geoServer = geoServer;
        this.catalog = geoServer.getCatalog();
        this.responseFactory = responseFactory;
    }

    @Override
    public WCSInfo getServiceInfo() {
        return (WCSInfo)this.geoServer.getService(WCSInfo.class);
    }

    @Override
    public Wcs10CapsTransformer getCapabilities(GetCapabilitiesType request) {
        String version;
        ArrayList<String> provided = new ArrayList<String>();
        provided.add("1.0.0");
        ArrayList<String> accepted = null;
        if (request.getVersion() != null) {
            accepted = new ArrayList<String>();
            accepted.add(request.getVersion());
        }
        if ("1.0.0".equals(version = RequestUtils.getVersionPreOws(provided, accepted))) {
            Wcs10CapsTransformer capsTransformer = new Wcs10CapsTransformer(this.geoServer);
            capsTransformer.setEncoding(Charset.forName(this.getServiceInfo().getGeoServer().getSettings().getCharset()));
            return capsTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public Wcs10DescribeCoverageTransformer describeCoverage(DescribeCoverageType request) {
        String version = request.getVersion();
        if ("1.0.0".equals(version)) {
            WCSInfo wcs = this.getServiceInfo();
            Wcs10DescribeCoverageTransformer describeTransformer = new Wcs10DescribeCoverageTransformer(wcs, this.catalog);
            describeTransformer.setEncoding(Charset.forName(wcs.getGeoServer().getSettings().getCharset()));
            return describeTransformer;
        }
        throw new WcsException("Could not understand version:" + version);
    }

    @Override
    public GridCoverage[] getCoverage(GetCoverageType request) {
        WCSInfo wcs = this.getServiceInfo();
        CoverageInfo meta = null;
        GridCoverage2D coverage = null;
        ArrayList<GridCoverage2D> coverageResults = new ArrayList<GridCoverage2D>();
        try {
            GeneralBounds destinationEnvelope;
            Filter filter;
            DimensionInfo elevationDimension;
            Rectangle destinationSize;
            AffineTransform2D destinationG2W;
            CoordinateReferenceSystem targetCRS;
            meta = this.catalog.getCoverageByName(request.getSourceCoverage());
            if (meta == null) {
                throw new WcsException("Cannot find sourceCoverage " + request.getSourceCoverage() + " in the catalog!");
            }
            DefaultWebCoverageService100.checkRangeSubset(meta, request.getRangeSubset());
            DefaultWebCoverageService100.checkInterpolationMethod(meta, request.getInterpolationMethod());
            this.checkOutput(meta, request.getOutput());
            DomainSubsetType domainSubset = request.getDomainSubset();
            TimeSequenceType temporalSubset = domainSubset.getTemporalSubset();
            SpatialSubsetType spatialSubset = domainSubset.getSpatialSubset();
            EList grids = spatialSubset.getGrid();
            if (grids.isEmpty()) {
                throw new IllegalArgumentException("Invalid number of Grid for spatial subsetting was set:" + grids.size());
            }
            RectifiedGridType grid = (RectifiedGridType)grids.get(0);
            EList envelopes = spatialSubset.getEnvelope();
            if (envelopes.isEmpty()) {
                throw new IllegalArgumentException("Invalid number of Envelope for spatial subsetting was set:" + envelopes.size());
            }
            GeneralBounds requestedEnvelope = (GeneralBounds)envelopes.get(0);
            OutputType output = request.getOutput();
            if (output == null) {
                throw new IllegalArgumentException("Output type was null");
            }
            CodeType outputCRS = output.getCrs();
            int dimension = grid.getDimension().intValue();
            if (dimension == 3) {
                throw new WcsException("We support a third dimension only via a specifica Axis in Range", WcsException.WcsExceptionCode.InvalidParameterValue, null);
            }
            GridCoverage2DReader reader = (GridCoverage2DReader)meta.getGridCoverageReader(null, WCSUtils.getReaderHints((WCSInfo)wcs));
            if (reader == null) {
                return (GridCoverage[])coverageResults.toArray(new GridCoverage2D[0]);
            }
            GeneralBounds nativeEnvelope = reader.getOriginalEnvelope();
            CoordinateReferenceSystem nativeCRS = nativeEnvelope.getCoordinateReferenceSystem();
            String requestedCRS = null;
            if (outputCRS != null) {
                requestedCRS = outputCRS.getValue();
            }
            if (requestedCRS == null) {
                targetCRS = reader.getOriginalEnvelope().getCoordinateReferenceSystem();
                requestedCRS = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)targetCRS, (boolean)true);
            } else {
                targetCRS = CRS.decode((String)requestedCRS, (boolean)true);
            }
            GridEnvelope limits = grid.getLimits();
            if (limits != null) {
                int[] lowers = limits.getLow().getCoordinateValues();
                destinationG2W = null;
                destinationSize = new Rectangle(lowers[0], lowers[1], limits.getSpan(0), limits.getSpan(1));
            } else if (grid.getOffsetVector() != null && !grid.getOffsetVector().isEmpty()) {
                VectorType offsetVector = (VectorType)grid.getOffsetVector().get(0);
                List offsetValues = offsetVector.getValue();
                double resX = (Double)offsetValues.get(0);
                double resY = (Double)offsetValues.get(1);
                DirectPositionType origin_ = grid.getOrigin().getPos();
                destinationSize = null;
                destinationG2W = new AffineTransform2D(resX, 0.0, 0.0, resY, ((Double)origin_.getValue().get(0)).doubleValue(), ((Double)origin_.getValue().get(1)).doubleValue());
            } else {
                throw new WcsException("Invalid Grid value:" + grid.toString(), WcsException.WcsExceptionCode.InvalidParameterValue, null);
            }
            ParameterValueGroup readParametersDescriptor = reader.getFormat().getReadParameters();
            GeneralParameterValue[] readParameters = CoverageUtils.getParameters((ParameterValueGroup)readParametersDescriptor, (Map)meta.getParameters());
            readParameters = readParameters != null ? readParameters : new GeneralParameterValue[]{};
            GridGeometry2D requestedGridGeometry = this.getGridGeometry(destinationSize, destinationG2W, DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope));
            ParameterValue requestedGridGeometryParam = new DefaultParameterDescriptor(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), GeneralGridGeometry.class, null, (Object)requestedGridGeometry).createValue();
            GeneralParameterValue[] tmpArray = new GeneralParameterValue[readParameters.length + 1];
            System.arraycopy(readParameters, 0, tmpArray, 0, readParameters.length);
            tmpArray[tmpArray.length - 1] = requestedGridGeometryParam;
            readParameters = tmpArray;
            ArrayList<GeneralParameterDescriptor> parameterDescriptors = new ArrayList<GeneralParameterDescriptor>(readParametersDescriptor.getDescriptor().descriptors());
            Set dynamicParameters = reader.getDynamicParameters();
            parameterDescriptors.addAll(dynamicParameters);
            ReaderDimensionsAccessor dimensions = new ReaderDimensionsAccessor(reader);
            DimensionInfo timeDimension = (DimensionInfo)meta.getMetadata().get("time", DimensionInfo.class);
            if (timeDimension != null && timeDimension.isEnabled() && dimensions.hasTime()) {
                readParameters = this.addTimeReadParam(temporalSubset, readParameters, parameterDescriptors, dimensions);
            }
            if ((elevationDimension = (DimensionInfo)meta.getMetadata().get("elevation", DimensionInfo.class)) != null && elevationDimension.isEnabled() && dimensions.hasElevation()) {
                readParameters = this.addElevationReadParam(request, readParameters, parameterDescriptors, dimensions);
            }
            if (request.getRangeSubset() != null) {
                EList axisSubset = request.getRangeSubset().getAxisSubset();
                int asCount = axisSubset == null ? 0 : axisSubset.size();
                for (int i = 0; i < asCount; ++i) {
                    AxisSubsetType axis = (AxisSubsetType)axisSubset.get(i);
                    String axisName = axis.getName();
                    String key = "custom_dimension_" + axisName;
                    Object dimInfo = meta.getMetadata().entrySet().stream().filter(e -> ((String)e.getKey()).equalsIgnoreCase(key)).findFirst().map(e -> (Serializable)e.getValue()).orElse(null);
                    axisName = axisName.toUpperCase();
                    if (!(dimInfo instanceof DimensionInfo) || !dimensions.hasDomain(axisName)) continue;
                    readParameters = this.addCustomDimensionReadParam(readParameters, parameterDescriptors, dimensions, axis, axisName);
                }
            }
            if ((filter = WCSUtils.getRequestFilter()) != null) {
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)filter, (String[])new String[]{"FILTER", "Filter"});
            }
            WCSUtils.checkInputLimits((WCSInfo)wcs, (CoverageInfo)meta, (GridCoverage2DReader)reader, (GridGeometry2D)requestedGridGeometry);
            Interpolation interpolation = Interpolation.getInstance((int)0);
            String interpolationType = null;
            if (request.getInterpolationMethod() != null && (interpolationType = request.getInterpolationMethod().getLiteral()) != null) {
                interpolation = this.parseInterpolation(interpolationType);
                readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, (Object)interpolation, (String[])new String[]{"interpolation"});
                if (meta.getStore().getFormat() instanceof ImageMosaicFormat) {
                    GeneralParameterValue[] temp = new GeneralParameterValue[readParameters.length + 1];
                    System.arraycopy(readParameters, 0, temp, 0, readParameters.length);
                    temp[temp.length - 1] = ImageMosaicFormat.INTERPOLATION.createValue();
                    ((ParameterValue)temp[temp.length - 1]).setValue((Object)interpolation);
                    readParameters = temp;
                }
            }
            if ((coverage = reader.read(readParameters = WCSUtils.replaceParameter((GeneralParameterValue[])readParameters, (Object)Boolean.TRUE, (ParameterDescriptor)AbstractGridFormat.USE_JAI_IMAGEREAD))) == null || !(coverage instanceof GridCoverage2D)) {
                throw new IOException("No raster data found in the request (it may be that the request bbox is outside of the coverage area, or that the filters used match no portions of it.");
            }
            GeneralBounds destinationEnvelopeNativeCRS = destinationEnvelope = this.getDestinationEnvelope(requestedEnvelope, nativeEnvelope, targetCRS);
            if (!CRS.isEquivalent((CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)targetCRS)) {
                destinationEnvelopeNativeCRS = CRS.transform((Bounds)destinationEnvelope, (CoordinateReferenceSystem)nativeCRS);
            }
            if (WCSUtils.isDeferredLoaded((GridCoverage2D)coverage)) {
                coverage = WCSUtils.crop((GridCoverage2D)coverage, (Bounds)destinationEnvelopeNativeCRS);
                WCSUtils.checkInputLimits((WCSInfo)wcs, (GridCoverage2D)coverage);
            } else {
                WCSUtils.checkInputLimits((WCSInfo)wcs, (GridCoverage2D)coverage);
                coverage = WCSUtils.crop((GridCoverage2D)coverage, (Bounds)destinationEnvelopeNativeCRS);
            }
            WCSUtils.checkInputLimits((WCSInfo)wcs, (GridCoverage2D)coverage);
            GridCoverage2D bandSelectedCoverage = coverage;
            if (request.getRangeSubset() != null) {
                bandSelectedCoverage = this.bandSelection(request, coverage);
            }
            GridGeometry2D destinationGridGeometry = this.getGridGeometry(destinationSize, destinationG2W, (Bounds)destinationEnvelope);
            WCSUtils.checkOutputLimits((WCSInfo)wcs, (GridEnvelope2D)destinationGridGeometry.getGridRange2D(), (SampleModel)bandSelectedCoverage.getRenderedImage().getSampleModel());
            GridCoverage2D finalCoverage = WCSUtils.resample((GridCoverage2D)bandSelectedCoverage, (CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)targetCRS, (GridGeometry2D)destinationGridGeometry, (Interpolation)interpolation);
            coverageResults.add(finalCoverage);
            return (GridCoverage[])coverageResults.toArray(new GridCoverage2D[0]);
        }
        catch (Exception e2) {
            if (coverage != null) {
                CoverageCleanerCallback.addCoverages((GridCoverage[])new GridCoverage[]{coverage});
            }
            if (e2 instanceof WcsException) {
                throw (WcsException)e2;
            }
            throw new WcsException((Throwable)e2);
        }
    }

    private GeneralBounds getDestinationEnvelope(GeneralBounds requestedEnvelope, GeneralBounds nativeEnvelope, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        GeneralBounds destinationEnvelope = DefaultWebCoverageService100.computeIntersectionEnvelope(requestedEnvelope, nativeEnvelope);
        if (destinationEnvelope == null) {
            throw new WcsException("The request bbox is outside of the coverage area", WcsException.WcsExceptionCode.InvalidParameterValue, "bbox");
        }
        destinationEnvelope = (GeneralBounds)DefaultWebCoverageService100.getHorizontalEnvelope(destinationEnvelope);
        if (targetCRS != null) {
            destinationEnvelope = CRS.transform((Bounds)destinationEnvelope, (CoordinateReferenceSystem)targetCRS);
            destinationEnvelope.setCoordinateReferenceSystem(targetCRS);
        }
        return destinationEnvelope;
    }

    private GridCoverage2D bandSelection(GetCoverageType request, GridCoverage2D coverage) {
        EList axisSubset = request.getRangeSubset().getAxisSubset();
        if (!axisSubset.isEmpty()) {
            for (Object o : axisSubset) {
                AxisSubsetType axis = (AxisSubsetType)o;
                try {
                    String axisName = axis.getName();
                    if (!axisName.equalsIgnoreCase("Band")) continue;
                    int[] bands = null;
                    if (!axis.getSingleValue().isEmpty()) {
                        bands = new int[axis.getSingleValue().size()];
                        for (int s = 0; s < axis.getSingleValue().size(); ++s) {
                            bands[s] = this.getBandFromAxis(axis, s);
                        }
                    } else if (!axis.getInterval().isEmpty()) {
                        IntervalType interval = (IntervalType)axis.getInterval().get(0);
                        int min = Integer.parseInt(interval.getMin().getValue());
                        int max = Integer.parseInt(interval.getMax().getValue());
                        int res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                        bands = new int[(int)(Math.floor(max - min) / (double)res + 1.0)];
                        for (int b = 0; b < bands.length; ++b) {
                            bands[b] = min + b * res - 1;
                        }
                    }
                    return (GridCoverage2D)WCSUtils.bandSelect((GridCoverage)coverage, (int[])bands);
                }
                catch (Exception e) {
                    throw new WcsException("Band Select Operation: " + e.getLocalizedMessage());
                }
            }
        }
        return coverage;
    }

    private int getBandFromAxis(AxisSubsetType axis, int s) {
        return Integer.parseInt(((TypedLiteralType)axis.getSingleValue().get(s)).getValue()) - 1;
    }

    private Interpolation parseInterpolation(String interpolationType) {
        if (interpolationType.equalsIgnoreCase("bilinear")) {
            return Interpolation.getInstance((int)1);
        }
        if (interpolationType.equalsIgnoreCase("bicubic")) {
            return Interpolation.getInstance((int)2);
        }
        return Interpolation.getInstance((int)0);
    }

    private GeneralParameterValue[] addCustomDimensionReadParam(GeneralParameterValue[] readParameters, List<GeneralParameterDescriptor> parameterDescriptors, ReaderDimensionsAccessor dimensions, AxisSubsetType axis, String axisName) {
        int valueCount = axis.getSingleValue().size();
        if (valueCount > 0) {
            ArrayList dimValues = new ArrayList(valueCount);
            for (int s = 0; s < valueCount; ++s) {
                dimValues.addAll(dimensions.convertDimensionValue(axisName, ((TypedLiteralType)axis.getSingleValue().get(s)).getValue()));
            }
            readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, dimValues, (String[])new String[]{axisName});
        }
        return readParameters;
    }

    private GeneralParameterValue[] addElevationReadParam(GetCoverageType request, GeneralParameterValue[] readParameters, List<GeneralParameterDescriptor> parameterDescriptors, ReaderDimensionsAccessor dimensions) throws IOException {
        ArrayList<Double> elevations = new ArrayList<Double>();
        EList axisSubset = null;
        if (request.getRangeSubset() != null && !(axisSubset = request.getRangeSubset().getAxisSubset()).isEmpty()) {
            for (Object o : axisSubset) {
                AxisSubsetType axis = (AxisSubsetType)o;
                String axisName = axis.getName();
                if (!axisName.equalsIgnoreCase("ELEVATION")) continue;
                for (Object object : axis.getSingleValue()) {
                    TypedLiteralType value = (TypedLiteralType)object;
                    elevations.add(Double.parseDouble(value.getValue()));
                }
                for (Object object : axis.getInterval()) {
                    IntervalType interval = (IntervalType)object;
                    double min = Double.parseDouble(interval.getMin().getValue());
                    double max = Double.parseDouble(interval.getMax().getValue());
                    elevations.add((Double)NumberRange.create((double)min, (double)max));
                }
            }
        }
        if (elevations.isEmpty()) {
            elevations.add(dimensions.getMinElevation());
        }
        readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, elevations, (String[])new String[]{"ELEVATION", "Elevation"});
        return readParameters;
    }

    private GeneralParameterValue[] addTimeReadParam(TimeSequenceType temporalSubset, GeneralParameterValue[] readParameters, List<GeneralParameterDescriptor> parameterDescriptors, ReaderDimensionsAccessor dimensions) throws IOException {
        WCSInfo info;
        int maxValues;
        ArrayList<Date> timeValues = new ArrayList<Date>();
        if (temporalSubset != null && temporalSubset.getTimePosition() != null) {
            EList timePosition = temporalSubset.getTimePosition();
            for (Object o : timePosition) {
                TimePositionType tp = (TimePositionType)o;
                Date date = (Date)tp.getValue();
                if (date == null) {
                    date = dimensions.getMaxTime();
                }
                timeValues.add(date);
            }
            EList timePeriods = temporalSubset.getTimePeriod();
            for (Object timePeriod : timePeriods) {
                TimePeriodType tp = (TimePeriodType)timePeriod;
                Date begin = (Date)tp.getBeginPosition().getValue();
                Date end = (Date)tp.getEndPosition().getValue();
                timeValues.add((Date)new DateRange(begin, end));
            }
        }
        if (timeValues.isEmpty()) {
            Date date = dimensions.getMaxTime();
            timeValues.add(date);
        }
        if ((maxValues = (info = (WCSInfo)this.geoServer.getService(WCSInfo.class)).getMaxRequestedDimensionValues()) > 0 && maxValues < timeValues.size()) {
            throw new ServiceException("More than " + maxValues + " times specified in the request, bailing out.", "InvalidParameterValue", "time");
        }
        readParameters = CoverageUtils.mergeParameter(parameterDescriptors, (GeneralParameterValue[])readParameters, timeValues, (String[])new String[]{"TIME", "Time"});
        return readParameters;
    }

    private GridGeometry2D getGridGeometry(Rectangle destinationSize, AffineTransform2D destinationG2W, Bounds horizontalEnvelope) {
        GridGeometry2D requestedGridGeometry = destinationSize != null ? new GridGeometry2D((GridEnvelope)new GridEnvelope2D(destinationSize), horizontalEnvelope) : new GridGeometry2D(PixelInCell.CELL_CENTER, (MathTransform)destinationG2W, horizontalEnvelope, null);
        return requestedGridGeometry;
    }

    private static Bounds getHorizontalEnvelope(GeneralBounds originalEnvelope) throws FactoryException, TransformException {
        SingleCRS horizontalCRS;
        CoordinateReferenceSystem originalCRS = originalEnvelope.getCoordinateReferenceSystem();
        if (CRS.equalsIgnoreMetadata((Object)originalCRS, (Object)(horizontalCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)originalEnvelope.getCoordinateReferenceSystem())))) {
            return originalEnvelope;
        }
        MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)originalCRS, (CoordinateReferenceSystem)horizontalCRS);
        if (transform.isIdentity()) {
            return originalEnvelope;
        }
        return CRS.transform((MathTransform)transform, (Bounds)originalEnvelope);
    }

    private static GeneralBounds computeIntersectionEnvelope(GeneralBounds requestedEnvelope, GeneralBounds nativeEnvelope) {
        SingleCRS requestCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)requestedEnvelope.getCoordinateReferenceSystem());
        SingleCRS nativeCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)nativeEnvelope.getCoordinateReferenceSystem());
        try {
            GeneralBounds retVal;
            if (!CRS.equalsIgnoreMetadata((Object)requestCRS, (Object)nativeCRS)) {
                retVal = CRS.transform((Bounds)DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope), (CoordinateReferenceSystem)nativeCRS);
                retVal.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeCRS);
            } else {
                retVal = new GeneralBounds(DefaultWebCoverageService100.getHorizontalEnvelope(requestedEnvelope));
            }
            if (!retVal.intersects((Bounds)nativeEnvelope, true)) {
                return null;
            }
            retVal.intersect((Bounds)nativeEnvelope);
            retVal.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeCRS);
            return retVal;
        }
        catch (FactoryException | TransformException te) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, te.getLocalizedMessage(), te);
            }
            try {
                GeographicCRS nativeGeoCRS = CRSUtilities.getStandardGeographicCRS2D((CoordinateReferenceSystem)nativeCRS);
                GeneralBounds nativeGeoEnvelope = CRS.transform((Bounds)nativeEnvelope, (CoordinateReferenceSystem)nativeGeoCRS);
                nativeGeoEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
                GeneralBounds requestedBBOXInNativeGeographicCRS = null;
                if (!CRS.equalsIgnoreMetadata((Object)nativeCRS, (Object)requestCRS)) {
                    requestedBBOXInNativeGeographicCRS = CRS.transform((Bounds)requestedEnvelope, (CoordinateReferenceSystem)nativeGeoCRS);
                    requestedBBOXInNativeGeographicCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
                }
                if (requestedBBOXInNativeGeographicCRS == null) {
                    requestedBBOXInNativeGeographicCRS = new GeneralBounds((CoordinateReferenceSystem)requestCRS);
                }
                if (!requestedBBOXInNativeGeographicCRS.intersects((Bounds)nativeEnvelope, true)) {
                    return null;
                }
                requestedBBOXInNativeGeographicCRS.intersect((Bounds)nativeGeoEnvelope);
                requestedBBOXInNativeGeographicCRS.setCoordinateReferenceSystem((CoordinateReferenceSystem)nativeGeoCRS);
                GeneralBounds approximateRequestedBBox = CRS.transform((Bounds)requestedBBOXInNativeGeographicCRS, (CoordinateReferenceSystem)requestCRS);
                approximateRequestedBBox.setCoordinateReferenceSystem((CoordinateReferenceSystem)requestCRS);
                return approximateRequestedBBox;
            }
            catch (TransformException te2) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, te2.getLocalizedMessage(), te2);
                }
                LOGGER.log(Level.INFO, "We did not manage to crop the requested envelope, we fall back onto loading the whole coverage.");
                return null;
            }
        }
    }

    private static void checkInterpolationMethod(CoverageInfo info, InterpolationMethodType interpolationMethod) {
        String interpolation = interpolationMethod.getLiteral();
        if (interpolation != null) {
            boolean interpolationSupported = false;
            if (interpolation.startsWith("nearest")) {
                interpolation = "nearest neighbor";
            }
            if (interpolation.equals("nearest neighbor") || info.getDefaultInterpolationMethod() != null && info.getDefaultInterpolationMethod().equalsIgnoreCase(interpolation)) {
                interpolationSupported = true;
            }
            for (String method : info.getInterpolationMethods()) {
                if (!interpolation.equalsIgnoreCase(method)) continue;
                interpolationSupported = true;
            }
            if (!interpolationSupported) {
                throw new WcsException("The requested Interpolation method is not supported by this Coverage.", WcsException.WcsExceptionCode.InvalidParameterValue, "RangeSubset");
            }
        }
    }

    private void checkOutput(CoverageInfo meta, OutputType output) {
        if (output == null) {
            return;
        }
        String format = output.getFormat().getValue();
        String declaredFormat = this.getDeclaredFormat(meta.getSupportedFormats(), format);
        if (declaredFormat == null) {
            throw new WcsException("format " + format + " is not supported for this coverage", WcsException.WcsExceptionCode.InvalidParameterValue, "format");
        }
    }

    private String getDeclaredFormat(List<String> supportedFormats, String format) {
        for (String sf : supportedFormats) {
            if (sf.equalsIgnoreCase(format.trim())) {
                return sf;
            }
            CoverageResponseDelegate delegate = this.responseFactory.encoderFor(sf);
            if (delegate == null || !delegate.canProduce(format)) continue;
            return sf;
        }
        return null;
    }

    private static void checkRangeSubset(CoverageInfo info, RangeSubsetType rangeSubset) {
        if (rangeSubset == null) {
            return;
        }
        for (int a = 0; a < rangeSubset.getAxisSubset().size(); ++a) {
            AxisSubsetType axisSubset = (AxisSubsetType)rangeSubset.getAxisSubset().get(a);
            if (!axisSubset.getName().equalsIgnoreCase("Band")) continue;
            int[] bands = null;
            if (!axisSubset.getSingleValue().isEmpty()) {
                bands = new int[]{Integer.parseInt(((TypedLiteralType)axisSubset.getSingleValue().get(0)).getValue())};
            } else if (!axisSubset.getInterval().isEmpty()) {
                IntervalType interval = (IntervalType)axisSubset.getInterval().get(0);
                int min = Integer.parseInt(interval.getMin().getValue());
                int max = Integer.parseInt(interval.getMax().getValue());
                int res = interval.getRes() != null ? Integer.parseInt(interval.getRes().getValue()) : 1;
                bands = new int[(max - min) / res];
                for (int b = 0; b < bands.length; ++b) {
                    bands[b] = min + b * res;
                }
            }
            if (bands != null) continue;
            throw new WcsException("Invalid values for axis " + axisSubset.getName(), WcsException.WcsExceptionCode.InvalidParameterValue, "AxisSubset");
        }
    }
}

