/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.wmts;

import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.gwc.wmts.WMTSInfoImpl;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geotools.util.Version;

public class WMTSXStreamLoader
extends XStreamServiceLoader<WMTSInfo> {
    public WMTSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "wmts");
    }

    public Class<WMTSInfo> getServiceClass() {
        return WMTSInfo.class;
    }

    protected WMTSInfo createServiceFromScratch(GeoServer gs) {
        WMTSInfoImpl wmts = new WMTSInfoImpl();
        wmts.setName("WMTS");
        return wmts;
    }

    public void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        xp.getXStream().alias("wmts", WMTSInfo.class, WMTSInfoImpl.class);
    }

    protected WMTSInfo initialize(WMTSInfo service) {
        if ((service = (WMTSInfo)super.initialize((ServiceInfo)service)).getMaintainer() == null) {
            service.setMaintainer("GeoServer");
        }
        if (service.getOnlineResource() == null) {
            service.setOnlineResource("https://geoserver.org");
        }
        if (service.getTitle() == null) {
            service.setTitle("GeoServer Web Map Tile Service");
        }
        if (service.getAbstract() == null) {
            service.setAbstract("Predefined map tiles generated from vector data, raster data, and imagery.");
        }
        if (service.getFees() == null) {
            service.setFees("NONE");
        }
        if (service.getAccessConstraints() == null) {
            service.setAccessConstraints("NONE");
        }
        if (service.getVersions() == null || service.getVersions().isEmpty()) {
            service.getVersions().add(new Version("1.0.0"));
        }
        return service;
    }
}

