/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.geoserver.platform.ServiceException;

class TimeoutReadWriteLock {
    ReadWriteLock lock = new ReentrantReadWriteLock();
    int timeoutMs;
    String name;

    public TimeoutReadWriteLock(int timeoutMs, String name) {
        this.timeoutMs = timeoutMs;
        this.name = name;
    }

    public void acquireReadLock() {
        boolean acquired = false;
        try {
            acquired = this.lock.readLock().tryLock(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new ServiceException("Failed to acquire read lock on '" + this.name + "' due to interruption", (Throwable)e);
        }
        if (!acquired) {
            throw new ServiceException("Failed to acquire read lock on '" + this.name + "' in less than " + this.timeoutMs + " ms");
        }
    }

    public void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    public void acquireWriteLock() {
        boolean acquired = false;
        try {
            acquired = this.lock.writeLock().tryLock(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new ServiceException("Failed to acquire write lock on '" + this.name + "' due to interruption", (Throwable)e);
        }
        if (!acquired) {
            throw new ServiceException("Failed to acquire write lock on '" + this.name + "' in less than " + this.timeoutMs + " ms");
        }
    }

    public void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    public void downgradeToReadLock() {
        this.lock.readLock().lock();
        this.lock.writeLock().unlock();
    }
}

