/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.layer;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerCatalog;
import org.geoserver.gwc.layer.TileLayerCatalogListener;
import org.geoserver.gwc.layer.TimeoutReadWriteLock;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.wms.WMS;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.TileLayerConfiguration;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class CatalogConfiguration
implements TileLayerConfiguration {
    static final int GWC_CONFIGURATION_LOCK_TIMEOUT = Integer.getInteger("gwc.configuration.lock.timeout", 60);
    private static final Logger LOGGER = Logging.getLogger(CatalogConfiguration.class);
    private TileLayerCatalog tileLayerCatalog;
    private Catalog geoServerCatalog;
    private GridSetBroker gridSetBroker;
    private final Map<String, GeoServerTileLayerInfo> pendingModications = Maps.newConcurrentMap();
    private final LoadingCache<String, GeoServerTileLayer> layerCache;
    private final Set<String> pendingDeletes = new CopyOnWriteArraySet<String>();
    private final TimeoutReadWriteLock lock = new TimeoutReadWriteLock(GWC_CONFIGURATION_LOCK_TIMEOUT * 1000, "GWC Configuration");

    public CatalogConfiguration(Catalog catalog, TileLayerCatalog tileLayerCatalog, GridSetBroker gridSetBroker) {
        Preconditions.checkNotNull((Object)catalog);
        Preconditions.checkNotNull((Object)tileLayerCatalog);
        Preconditions.checkNotNull((Object)gridSetBroker);
        this.tileLayerCatalog = tileLayerCatalog;
        this.geoServerCatalog = catalog;
        this.gridSetBroker = gridSetBroker;
        this.layerCache = CacheBuilder.newBuilder().concurrencyLevel(10).expireAfterAccess(10L, TimeUnit.MINUTES).initialCapacity(10).maximumSize(100L).build((CacheLoader)new TileLayerLoader(tileLayerCatalog));
        tileLayerCatalog.addListener((layerId, type) -> {
            if (type == TileLayerCatalogListener.Type.MODIFY || type == TileLayerCatalogListener.Type.DELETE) {
                this.layerCache.invalidate((Object)layerId);
            }
        });
    }

    public String getIdentifier() {
        return "GeoServer Catalog Configuration";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TileLayer> getLayers() {
        this.lock.acquireReadLock();
        try {
            Set<String> layerNames = this.tileLayerCatalog.getLayerNames();
            Function<String, Optional> lazyLayerFetch = this::getLayer;
            Collection collection = layerNames.stream().map(lazyLayerFetch).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return collection;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getLayerNames() {
        this.lock.acquireReadLock();
        try {
            GeoServerTileLayerInfo old;
            Set<String> storedNames = this.tileLayerCatalog.getLayerNames();
            HashSet<String> names = null;
            if (!this.pendingDeletes.isEmpty()) {
                names = new HashSet<String>(storedNames);
                for (String string : this.pendingDeletes) {
                    old = this.tileLayerCatalog.getLayerById(string);
                    names.remove(old.getName());
                }
            }
            if (!this.pendingModications.isEmpty()) {
                for (Map.Entry entry : this.pendingModications.entrySet()) {
                    String newName;
                    String oldName;
                    old = this.tileLayerCatalog.getLayerById((String)entry.getKey());
                    if (old == null || Objects.equal((Object)(oldName = old.getName()), (Object)(newName = ((GeoServerTileLayerInfo)entry.getValue()).getName()))) continue;
                    if (names == null) {
                        names = new HashSet<String>(storedNames);
                    }
                    names.remove(oldName);
                    names.add(newName);
                }
            }
            Set<String> set = names == null ? storedNames : Collections.unmodifiableSet(names);
            return set;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsLayer(String layerName) {
        Preconditions.checkNotNull((Object)layerName, (Object)"layer id is null");
        this.lock.acquireReadLock();
        try {
            if (this.pendingDeletes.contains(layerName)) {
                boolean bl = false;
                return bl;
            }
            String layerId = this.tileLayerCatalog.getLayerId(layerName);
            boolean bl = layerId != null;
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    private GeoServerTileLayer getTileLayerById(String layerId) {
        GeoServerTileLayer layer;
        Preconditions.checkNotNull((Object)layerId, (Object)"layer id is null");
        this.lock.acquireReadLock();
        try {
            layer = (GeoServerTileLayer)((Object)this.layerCache.get((Object)layerId));
            WorkspaceInfo localWorkspace = LocalWorkspace.get();
            PublishedInfo localPublished = LocalPublished.get();
            if (localWorkspace != null) {
                PublishedInfo publishedInfo2 = layer.getPublishedInfo();
                WorkspaceInfo layerWorkspace = publishedInfo2 instanceof LayerInfo ? ((LayerInfo)publishedInfo2).getResource().getStore().getWorkspace() : ((LayerGroupInfo)publishedInfo2).getWorkspace();
                if (layerWorkspace == null) {
                    GeoServerTileLayer geoServerTileLayer = null;
                    return geoServerTileLayer;
                }
                if (!localWorkspace.getName().equals(layerWorkspace.getName())) {
                    GeoServerTileLayer geoServerTileLayer = null;
                    return geoServerTileLayer;
                }
                if (localPublished != null && !localPublished.getName().equals(publishedInfo2.getName())) {
                    GeoServerTileLayer geoServerTileLayer = null;
                    return geoServerTileLayer;
                }
            } else if (localPublished != null) {
                PublishedInfo publishedInfo = layer.getPublishedInfo();
                if (!(publishedInfo instanceof LayerGroupInfo)) {
                    GeoServerTileLayer publishedInfo2 = null;
                    return publishedInfo2;
                }
                LayerGroupInfo lg = (LayerGroupInfo)publishedInfo;
                if (lg.getWorkspace() != null || !lg.getName().equals(localPublished.getName())) {
                    GeoServerTileLayer geoServerTileLayer = null;
                    return geoServerTileLayer;
                }
            }
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw e;
        }
        finally {
            this.lock.releaseReadLock();
        }
        return layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<TileLayer> getLayer(String layerName) {
        String layerId;
        Preconditions.checkNotNull((Object)layerName, (Object)"layer name is null");
        this.lock.acquireReadLock();
        try {
            layerId = this.getLayerId(layerName);
            if (layerId == null) {
                Optional<Object> optional = Optional.ofNullable(null);
                return optional;
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return Optional.ofNullable(this.getTileLayerById(layerId));
    }

    private String getLayerId(String layerName) {
        String layerId;
        String storedName = layerName;
        if (!this.pendingModications.isEmpty()) {
            for (GeoServerTileLayerInfo info : this.pendingModications.values()) {
                String name = info.getName();
                if (!name.equals(layerName)) continue;
                storedName = info.getName();
                break;
            }
        }
        if ((layerId = this.tileLayerCatalog.getLayerId(storedName)) == null || this.pendingDeletes.contains(layerId)) {
            return null;
        }
        GeoServerTileLayerInfo modifiedState = this.pendingModications.get(layerId);
        if (modifiedState != null && !layerName.equals(modifiedState.getName())) {
            return null;
        }
        return layerId;
    }

    private GeoServerTileLayerInfo getTileLayerInfoByName(String layerName) {
        GeoServerTileLayerInfo tileLayerInfo = null;
        if (!this.pendingModications.isEmpty()) {
            for (GeoServerTileLayerInfo info : this.pendingModications.values()) {
                String name = info.getName();
                if (!name.equals(layerName)) continue;
                tileLayerInfo = info;
                break;
            }
        }
        if (null == tileLayerInfo) {
            tileLayerInfo = this.tileLayerCatalog.getLayerByName(layerName);
            if (null == tileLayerInfo) {
                return null;
            }
            if (this.pendingDeletes.contains(tileLayerInfo.getId())) {
                return null;
            }
            if (this.pendingModications.containsKey(tileLayerInfo.getId())) {
                return null;
            }
        }
        return tileLayerInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLayerCount() {
        int count = 0;
        this.lock.acquireReadLock();
        try {
            Set<String> layerIds = this.tileLayerCatalog.getLayerIds();
            if (this.pendingDeletes.isEmpty()) {
                count = layerIds.size();
            } else {
                for (String layerId : layerIds) {
                    if (this.pendingDeletes.contains(layerId)) continue;
                    ++count;
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return count;
    }

    public void afterPropertiesSet() {
        this.lock.acquireWriteLock();
        try {
            LOGGER.config("Initializing GWC configuration based on GeoServer's Catalog");
            this.layerCache.invalidateAll();
            this.tileLayerCatalog.initialize();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public boolean canSave(TileLayer tl) {
        return tl instanceof GeoServerTileLayer && !tl.isTransientLayer();
    }

    public static boolean isLayerExposable(LayerInfo layer) {
        assert (layer != null);
        return WMS.isWmsExposable((LayerInfo)layer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addLayer(TileLayer tl) {
        Preconditions.checkNotNull((Object)tl);
        Preconditions.checkArgument((boolean)this.canSave(tl), (String)"Can't save TileLayer of type %s", tl.getClass());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)tl;
        Preconditions.checkNotNull((Object)tileLayer.getInfo(), (Object)"GeoServerTileLayerInfo is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getId(), (Object)"id is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getName(), (Object)"name is null");
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        PublishedInfo publishedInfo = tileLayer.getPublishedInfo();
        if (publishedInfo instanceof LayerInfo && !CatalogConfiguration.isLayerExposable((LayerInfo)publishedInfo)) {
            LOGGER.warning("Requested layer " + publishedInfo.getName() + " has no geometry. Won't create TileLayer");
            return;
        }
        this.lock.acquireWriteLock();
        try {
            boolean pending = this.pendingModications.containsKey(info.getId());
            boolean exists = null != this.tileLayerCatalog.getLayerById(info.getId());
            boolean notExists = !pending && !exists;
            Preconditions.checkArgument((boolean)notExists, (Object)("A GeoServerTileLayer named '" + info.getName() + "' already exists"));
            if (this.pendingDeletes.remove(info.getId())) {
                LOGGER.finer("Adding a new layer " + info.getName() + " before saving the deleted one with the same id");
            }
            this.pendingModications.put(info.getId(), info);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void modifyLayer(TileLayer tl) throws NoSuchElementException {
        Preconditions.checkNotNull((Object)tl, (Object)"TileLayer is null");
        Preconditions.checkArgument((boolean)this.canSave(tl), (String)"Can't save TileLayer of type: %s ", tl.getClass());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)tl;
        Preconditions.checkNotNull((Object)tileLayer.getInfo(), (Object)"GeoServerTileLayerInfo is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getId(), (Object)"id is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getName(), (Object)"name is null");
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        this.lock.acquireWriteLock();
        try {
            boolean exists;
            String layerId = info.getId();
            boolean bl = exists = this.pendingModications.containsKey(layerId) || this.tileLayerCatalog.exists(layerId);
            if (!exists) {
                throw new NoSuchElementException("No GeoServerTileLayer named '" + info.getName() + "' exists");
            }
            this.pendingModications.put(layerId, info);
            this.layerCache.invalidate((Object)layerId);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void renameLayer(String oldName, String newName) throws NoSuchElementException {
        TileLayer tl = this.getLayer(oldName).orElseThrow(() -> new NullPointerException("TileLayer " + oldName + " not found"));
        Preconditions.checkArgument((boolean)this.canSave(tl), (String)"Can't rename TileLayer of type %s", tl.getClass());
        GeoServerTileLayer tileLayer = (GeoServerTileLayer)tl;
        Preconditions.checkNotNull((Object)tileLayer.getInfo(), (Object)"GeoServerTileLayerInfo is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getId(), (Object)"id is null");
        Preconditions.checkNotNull((Object)tileLayer.getInfo().getName(), (Object)"name is null");
        GeoServerTileLayerInfo info = tileLayer.getInfo();
        this.lock.acquireWriteLock();
        try {
            String layerId = info.getId();
            info.setName(newName);
            boolean exists = this.pendingModications.containsKey(layerId) || this.tileLayerCatalog.exists(layerId);
            Preconditions.checkArgument((boolean)exists, (Object)("No GeoServerTileLayer named '" + info.getName() + "' exists"));
            this.pendingModications.put(layerId, info);
            this.layerCache.invalidate((Object)layerId);
        }
        finally {
            this.lock.releaseWriteLock();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLayer(String layerName) throws NoSuchElementException {
        block6: {
            Preconditions.checkNotNull((Object)layerName);
            this.lock.acquireWriteLock();
            try {
                GeoServerTileLayerInfo tileLayerInfo = this.getTileLayerInfoByName(layerName);
                if (tileLayerInfo != null) {
                    String layerId = tileLayerInfo.getId();
                    this.pendingModications.remove(layerId);
                    try {
                        GWC.get().layerRemoved(tileLayerInfo.getName());
                    }
                    catch (RuntimeException e) {
                        LOGGER.log(Level.SEVERE, "Error deleting tile layer '" + tileLayerInfo.getName() + "' from cache", e);
                    }
                    this.pendingDeletes.add(layerId);
                    this.layerCache.invalidate((Object)layerId);
                    break block6;
                }
                throw new NoSuchElementException("Tile layer " + layerName + " does not exist");
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void save() {
        GeoServerTileLayerInfo old;
        GWC mediator = GWC.get();
        LinkedList modifications = Lists.newLinkedList();
        this.lock.acquireWriteLock();
        try {
            for (String deletedId : this.pendingDeletes) {
                try {
                    this.tileLayerCatalog.delete(deletedId);
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Error deleting tile layer '" + deletedId + "' from catalog", e);
                }
            }
            for (GeoServerTileLayerInfo modified : this.pendingModications.values()) {
                try {
                    old = this.tileLayerCatalog.save(modified);
                    modifications.add(new GeoServerTileLayerInfo[]{old, modified});
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.SEVERE, "Error saving tile layer '" + modified.getName() + "'", e);
                }
            }
            this.pendingModications.clear();
            this.pendingDeletes.clear();
        }
        finally {
            this.lock.downgradeToReadLock();
            try {
                for (GeoServerTileLayerInfo[] oldNew : modifications) {
                    old = oldNew[0];
                    GeoServerTileLayerInfo modified = oldNew[1];
                    try {
                        if (old == null) {
                            String layerName = modified.getName();
                            mediator.layerAdded(layerName);
                            continue;
                        }
                        this.issueTileLayerInfoChangeNotifications(old, modified);
                    }
                    catch (RuntimeException e) {
                        LOGGER.log(Level.SEVERE, "Error issuing change events for tile layer " + modified + ".  This may result in leaked tiles that will not be truncated.", e);
                    }
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
    }

    private void issueTileLayerInfoChangeNotifications(GeoServerTileLayerInfo oldInfo, GeoServerTileLayerInfo newInfo) {
        HashSet<String> newFormats;
        boolean isRename;
        Preconditions.checkNotNull((Object)oldInfo);
        Preconditions.checkNotNull((Object)newInfo);
        Preconditions.checkNotNull((Object)oldInfo.getName());
        Preconditions.checkNotNull((Object)newInfo.getName());
        Preconditions.checkNotNull((Object)oldInfo.getId());
        Preconditions.checkNotNull((Object)newInfo.getId());
        Preconditions.checkArgument((boolean)Objects.equal((Object)oldInfo.getId(), (Object)newInfo.getId()));
        GWC mediator = GWC.get();
        String oldLayerName = oldInfo.getName();
        String layerName = newInfo.getName();
        boolean bl = isRename = !Objects.equal((Object)oldLayerName, (Object)layerName);
        if (isRename) {
            mediator.layerRenamed(oldLayerName, layerName);
        }
        Set<XMLGridSubset> oldGridSubsets = oldInfo.getGridSubsets();
        Set<XMLGridSubset> newGridSubsets = newInfo.getGridSubsets();
        Set<String> oldGridSubsetNames = this.gridsetNames(oldGridSubsets);
        Set<String> newGridSubsetNames = this.gridsetNames(newGridSubsets);
        HashSet<String> removedGridSets = new HashSet<String>(oldGridSubsetNames);
        removedGridSets.removeAll(newGridSubsetNames);
        for (String removedGridset : removedGridSets) {
            mediator.deleteCacheByGridSetId(layerName, removedGridset);
        }
        HashSet<String> oldFormats = new HashSet<String>(oldInfo.getMimeFormats());
        if (!oldFormats.equals(newFormats = new HashSet<String>(newInfo.getMimeFormats()))) {
            oldFormats.removeAll(newFormats);
            for (String removedFormat : oldFormats) {
                String styleName = null;
                String gridSetName = null;
                BoundingBox bounds = null;
                mediator.truncate(layerName, styleName, gridSetName, bounds, removedFormat);
            }
        }
        Object oldStyles = oldInfo.cachedStyles();
        ImmutableSet<String> newStyles = newInfo.cachedStyles();
        if (!newStyles.equals(oldStyles)) {
            oldStyles = new HashSet<String>((Collection<String>)oldStyles);
            oldStyles.removeAll((Collection<?>)newStyles);
            Iterator iterator = oldStyles.iterator();
            while (iterator.hasNext()) {
                String removedStyle = (String)iterator.next();
                mediator.truncateByLayerAndStyle(layerName, removedStyle);
            }
        }
    }

    private Set<String> gridsetNames(Set<XMLGridSubset> gridSubsets) {
        HashSet<String> names = new HashSet<String>();
        for (XMLGridSubset gridSubset : gridSubsets) {
            names.add(gridSubset.getGridSetName());
        }
        return names;
    }

    public void reset() {
        this.lock.acquireWriteLock();
        try {
            this.layerCache.invalidateAll();
            this.tileLayerCatalog.reset();
            this.tileLayerCatalog.initialize();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public static String removeWorkspacePrefix(String layerName, Catalog catalog) {
        String workspaceName;
        int workspaceSeparatorIndex = layerName.indexOf(":");
        if (workspaceSeparatorIndex >= 0 && workspaceSeparatorIndex + 1 < layerName.length() && catalog.getWorkspaceByName(workspaceName = layerName.substring(0, workspaceSeparatorIndex)) != null) {
            return layerName.substring(workspaceSeparatorIndex + 1);
        }
        return layerName;
    }

    public String getLocation() {
        return this.tileLayerCatalog.getPersistenceLocation();
    }

    public void deinitialize() throws Exception {
    }

    @Autowired
    public void setGridSetBroker(@Qualifier(value="gwcGridSetBroker") GridSetBroker broker) {
        this.gridSetBroker = broker;
    }

    private final class TileLayerLoader
    extends CacheLoader<String, GeoServerTileLayer> {
        private final TileLayerCatalog tileLayerCatalog;

        private TileLayerLoader(TileLayerCatalog tileLayerCatalog) {
            this.tileLayerCatalog = tileLayerCatalog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GeoServerTileLayer load(String layerId) throws Exception {
            GeoServerTileLayer tileLayer = null;
            GridSetBroker gridSetBroker = CatalogConfiguration.this.gridSetBroker;
            CatalogConfiguration.this.lock.acquireReadLock();
            try {
                if (CatalogConfiguration.this.pendingDeletes.contains(layerId)) {
                    throw new IllegalArgumentException("Tile layer '" + layerId + "' was deleted.");
                }
                GeoServerTileLayerInfo tileLayerInfo = CatalogConfiguration.this.pendingModications.get(layerId);
                if (tileLayerInfo == null) {
                    tileLayerInfo = this.tileLayerCatalog.getLayerById(layerId);
                }
                if (tileLayerInfo == null) {
                    throw new IllegalArgumentException("GeoServerTileLayerInfo '" + layerId + "' does not exist.");
                }
                tileLayer = new GeoServerTileLayer(CatalogConfiguration.this.geoServerCatalog, layerId, gridSetBroker, tileLayerInfo);
            }
            finally {
                CatalogConfiguration.this.lock.releaseReadLock();
            }
            return tileLayer;
        }
    }
}

