/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.dispatch;

import java.util.Objects;
import org.geoserver.gwc.GWC;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.GeoServerSecurityManager;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.security.SecurityFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.SRS;
import org.geowebcache.layer.TileLayer;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class GeoServerSecurityFilter
implements SecurityFilter {
    public void checkSecurity(TileLayer layer, BoundingBox extent, SRS srs) throws SecurityException, GeoWebCacheException {
        if (GWC.get().getConfig().isSecurityEnabled()) {
            try {
                ReferencedEnvelope env = Objects.nonNull(extent) ? new ReferencedEnvelope(extent.getMinX(), extent.getMaxX(), extent.getMinY(), extent.getMaxY(), CRS.decode((String)srs.toString())) : null;
                GWC.get().verifyAccessLayer(layer.getName(), env);
            }
            catch (MismatchedDimensionException | FactoryException | ServiceException e) {
                throw new GeoWebCacheException(e);
            }
        }
    }

    public boolean isAdmin() {
        Authentication auth = this.getAuthentication();
        if (auth == null || !auth.isAuthenticated() || auth instanceof AnonymousAuthenticationToken) {
            return false;
        }
        return ((GeoServerSecurityManager)GeoServerExtensions.bean(GeoServerSecurityManager.class)).checkAuthenticationForAdminRole(auth);
    }

    public Authentication getAuthentication() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.getAuthorities().size() == 1 && "ROLE_ANONYMOUS".equals(((GrantedAuthority)auth.getAuthorities().iterator().next()).getAuthority())) {
            return null;
        }
        return auth;
    }
}

