/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.logging.Logger;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.ResourceStore;
import org.geoserver.platform.resource.Resources;
import org.geoserver.util.IOUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ConfigurationResourceProvider;

public class GeoserverXMLResourceProvider
implements ConfigurationResourceProvider {
    private static final Logger LOGGER = Logging.getLogger(GeoserverXMLResourceProvider.class);
    static final String GEOWEBCACHE_CONFIG_DIR_PROPERTY = "GEOWEBCACHE_CONFIG_DIR";
    static final String GEOWEBCACHE_CACHE_DIR_PROPERTY = "GEOWEBCACHE_CACHE_DIR";
    public static final String DEFAULT_CONFIGURATION_DIR_NAME = "gwc";
    private final Resource configDirectory;
    private final String configFileName;
    private String templateLocation;

    public GeoserverXMLResourceProvider(String providedConfigDirectory, String configFileName, ResourceStore resourceStore) throws ConfigurationException {
        this.configFileName = configFileName;
        this.configDirectory = GeoserverXMLResourceProvider.inferConfigDirectory(resourceStore, providedConfigDirectory);
        LOGGER.config(String.format("Will look for '%s' in directory '%s'.", configFileName, this.configDirectory.dir().getAbsolutePath()));
    }

    public GeoserverXMLResourceProvider(String configFileName, ResourceStore resourceStore) throws ConfigurationException {
        this(null, configFileName, resourceStore);
    }

    private static Resource inferConfigDirectory(ResourceStore resourceStore, String providedConfigDirectory) {
        File configurationDirectory;
        String configDirectoryPath = GeoserverXMLResourceProvider.findFirstDefined(GEOWEBCACHE_CONFIG_DIR_PROPERTY, GEOWEBCACHE_CACHE_DIR_PROPERTY).orElse(providedConfigDirectory);
        if (configDirectoryPath == null) {
            configDirectoryPath = DEFAULT_CONFIGURATION_DIR_NAME;
        }
        if ((configurationDirectory = new File(configDirectoryPath)).isAbsolute()) {
            return Resources.fromPath((String)configurationDirectory.getAbsolutePath());
        }
        return resourceStore.get(configDirectoryPath);
    }

    private static Optional<String> findFirstDefined(String ... propertiesNames) {
        for (String propertyName : propertiesNames) {
            String propertyValue = GeoServerExtensions.getProperty((String)propertyName);
            if (propertyValue == null) continue;
            LOGGER.fine(String.format("Property '%s' is set with value '%s'.", propertyName, propertyValue));
            return Optional.of(propertyValue);
        }
        return Optional.empty();
    }

    public Resource getConfigDirectory() {
        return this.configDirectory;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public InputStream in() throws IOException {
        return this.findOrCreateConfFile().in();
    }

    public OutputStream out() throws IOException {
        return this.findOrCreateConfFile().out();
    }

    public void backup() throws IOException {
        this.backUpConfig(this.findOrCreateConfFile());
    }

    public String getId() {
        return this.configDirectory.path();
    }

    public void setTemplate(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    private Resource findConfigFile() throws IOException {
        return this.configDirectory.get(this.configFileName);
    }

    public String getLocation() throws IOException {
        return this.findConfigFile().path();
    }

    private Resource findOrCreateConfFile() throws IOException {
        Resource xmlFile = this.findConfigFile();
        if (Resources.exists((Resource)xmlFile)) {
            LOGGER.fine("Found configuration file '" + xmlFile.path() + "'");
        } else if (this.templateLocation != null) {
            LOGGER.config("Create configuration file '" + xmlFile.path() + "' from template " + this.getClass().getResource(this.templateLocation).toExternalForm());
            try {
                IOUtils.copy((InputStream)this.getClass().getResourceAsStream(this.templateLocation), (OutputStream)xmlFile.out());
            }
            catch (IOException e) {
                throw new IOException("Error copying template config to " + xmlFile.path(), e);
            }
        }
        return xmlFile;
    }

    private void backUpConfig(Resource xmlFile) throws IOException {
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd'T'HHmmss").format(new Date());
        String backUpFileName = "geowebcache_" + timeStamp + ".bak";
        Resource parentFile = xmlFile.parent();
        LOGGER.fine("Backing up config file " + xmlFile.name() + " to " + backUpFileName);
        List previousBackUps = Resources.list((Resource)parentFile, res -> {
            if (this.configFileName.equals(res.name())) {
                return false;
            }
            return res.name().startsWith(this.configFileName) && res.name().endsWith(".bak");
        });
        int maxBackups = 10;
        if (previousBackUps.size() > 10) {
            Collections.sort(previousBackUps, (o1, o2) -> (int)(o1.lastmodified() - o2.lastmodified()));
            Resource oldest = (Resource)previousBackUps.get(0);
            LOGGER.fine("Deleting oldest config backup " + oldest + " to keep a maximum of 10 backups.");
            oldest.delete();
        }
        Resource backUpFile = parentFile.get(backUpFileName);
        IOUtils.copy((InputStream)xmlFile.in(), (OutputStream)backUpFile.out());
        LOGGER.fine("Config backup done");
    }

    public boolean hasInput() {
        try {
            return Resources.exists((Resource)this.findOrCreateConfFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean hasOutput() {
        return true;
    }
}

