/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.config;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.geoserver.config.GeoServer;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geowebcache.service.HttpErrorCodeException;
import org.geowebcache.service.Service;

public class GWCServiceEnablementInterceptor
implements MethodInterceptor {
    private GWC gwcFacade;
    private final GeoServer geoServer;

    public GWCServiceEnablementInterceptor(GWC gwc, GeoServer geoServer) {
        this.gwcFacade = gwc;
        this.geoServer = geoServer;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Service service;
        boolean serviceEnabled;
        String methodName = invocation.getMethod().getName();
        if (("getConveyor".equals(methodName) || "handleRequest".equals(methodName)) && !(serviceEnabled = (service = (Service)invocation.getThis()).getPathName().equals("wmts") ? ((WMTSInfo)this.geoServer.getService(WMTSInfo.class)).isEnabled() : this.gwcFacade.isServiceEnabled(service))) {
            throw new HttpErrorCodeException(400, "Service is disabled");
        }
        return invocation.proceed();
    }
}

