/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.storage.PageStats;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.geowebcache.diskquota.storage.TileSetVisitor;

public class DummyQuotaStore
implements QuotaStore {
    private static final Quota EMPTY_QUOTA = new Quota(BigInteger.valueOf(0L));
    TilePageCalculator calculator;

    public DummyQuotaStore(TilePageCalculator calculator) {
        this.calculator = calculator;
    }

    public void createLayer(String layerName) throws InterruptedException {
    }

    public Quota getGloballyUsedQuota() throws InterruptedException {
        return EMPTY_QUOTA;
    }

    public Quota getUsedQuotaByTileSetId(String tileSetId) throws InterruptedException {
        return EMPTY_QUOTA;
    }

    public void deleteLayer(String layerName) {
    }

    public void renameLayer(String oldLayerName, String newLayerName) throws InterruptedException {
    }

    public Quota getUsedQuotaByLayerName(String layerName) throws InterruptedException {
        return EMPTY_QUOTA;
    }

    public long[][] getTilesForPage(TilePage page) throws InterruptedException {
        TileSet tileSet = this.getTileSetById(page.getTileSetId());
        long[][] gridCoverage = this.calculator.toGridCoverage(tileSet, page);
        return gridCoverage;
    }

    public Set<TileSet> getTileSets() {
        return Collections.emptySet();
    }

    public TileSet getTileSetById(String tileSetId) throws InterruptedException {
        return null;
    }

    public void accept(TileSetVisitor visitor) {
    }

    public TilePageCalculator getTilePageCalculator() {
        return this.calculator;
    }

    public void addToQuotaAndTileCounts(TileSet tileSet, Quota quotaDiff, Collection<PageStatsPayload> tileCountDiffs) throws InterruptedException {
    }

    public Future<List<PageStats>> addHitsAndSetAccesTime(Collection<PageStatsPayload> statsUpdates) {
        return new Future<List<PageStats>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return true;
            }

            @Override
            public boolean isCancelled() {
                return true;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public List<PageStats> get() throws InterruptedException, ExecutionException {
                return Collections.emptyList();
            }

            @Override
            public List<PageStats> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return Collections.emptyList();
            }
        };
    }

    public TilePage getLeastFrequentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        return null;
    }

    public TilePage getLeastRecentlyUsedPage(Set<String> layerNames) throws InterruptedException {
        return null;
    }

    public PageStats setTruncated(TilePage tilePage) throws InterruptedException {
        return null;
    }

    public void deleteGridSubset(String layerName, String gridSetId) {
    }

    public void close() throws Exception {
    }

    public void deleteParameters(String layerName, String parametersId) {
    }
}

